/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.internal.helper.JavaVersion;
import org.eclipse.persistence.testing.framework.ReflectionHelper;
import org.eclipse.persistence.testing.tests.helper.JavaUtilTest;
import org.junit.Test;

public class JavaVersionTest
extends TestCase {
    private static boolean hasRuntimeVersion() {
        Method[] methods;
        for (Method method : methods = Runtime.class.getDeclaredMethods()) {
            if (!"version".equals(method.getName()) || method.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testRuntimeVersion() {
        if (!JavaVersionTest.hasRuntimeVersion()) {
            return;
        }
        try {
            JavaVersion version = (JavaVersion)ReflectionHelper.invokeStaticMethod((String)"runtimeVersion", JavaVersion.class, null, JavaVersion.class, (Object[])new Object[0]);
            JavaVersionTest.assertTrue((String)"Minimal Java 9 required", (version.getMajor() >= 9 ? 1 : 0) != 0);
        }
        catch (ReflectiveOperationException e) {
            JavaVersionTest.fail((String)("Exception: " + e.getMessage()));
        }
    }

    @Test
    public void testPropertyVersion() {
        try {
            String versionString = (String)ReflectionHelper.invokeStaticMethod((String)"vmVersionString", JavaVersion.class, null, String.class, (Object[])new Object[0]);
            JavaVersion javaVersion = (JavaVersion)ReflectionHelper.invokeStaticMethod((String)"propertyVersionParser", JavaVersion.class, (Class[])new Class[]{String.class}, JavaVersion.class, (Object[])new Object[]{versionString});
        }
        catch (ReflectiveOperationException e) {
            JavaVersionTest.fail((String)("Exception: " + e.getMessage()));
        }
    }

    @Test
    public void testPropertyVersionParser() {
        JavaVersion javaVersion;
        String versionString;
        int minor;
        int major;
        for (int[] version : JavaUtilTest.VALID) {
            major = version[0];
            minor = version[1];
            versionString = JavaSEPlatform.versionString((int)major, (int)minor);
            try {
                javaVersion = (JavaVersion)ReflectionHelper.invokeStaticMethod((String)"propertyVersionParser", JavaVersion.class, (Class[])new Class[]{String.class}, JavaVersion.class, (Object[])new Object[]{versionString});
                JavaVersionTest.assertNotNull((String)("JavaVersion instance must be returned for valid platform version number [" + Integer.toString(major) + "," + Integer.toString(minor) + "]"), (Object)javaVersion);
                JavaVersionTest.assertTrue((String)("Returned JavaVersion instance numbers do not match provided version number [" + Integer.toString(major) + "," + Integer.toString(minor) + "]"), (major == javaVersion.getMajor() && minor == javaVersion.getMinor() ? 1 : 0) != 0);
            }
            catch (ReflectiveOperationException e) {
                JavaVersionTest.fail((String)("Exception: " + e.getMessage()));
            }
        }
        for (int[] version : JavaUtilTest.INVALID) {
            major = version[0];
            minor = version[1];
            versionString = JavaSEPlatform.versionString((int)major, (int)minor);
            try {
                javaVersion = (JavaVersion)ReflectionHelper.invokeStaticMethod((String)"propertyVersionParser", JavaVersion.class, (Class[])new Class[]{String.class}, JavaVersion.class, (Object[])new Object[]{versionString});
                JavaVersionTest.assertNotNull((String)("JavaVersion instance must be returned for invalid platform version number [" + Integer.toString(major) + "," + Integer.toString(minor) + "]"), (Object)javaVersion);
                JavaVersionTest.assertTrue((String)("Returned JavaVersion instance numbers do not match provided version number [" + Integer.toString(major) + "," + Integer.toString(minor) + "]"), (major == javaVersion.getMajor() && minor == javaVersion.getMinor() ? 1 : 0) != 0);
            }
            catch (ReflectiveOperationException e) {
                JavaVersionTest.fail((String)("Exception: " + e.getMessage()));
            }
        }
    }
}

