/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning;

import java.math.BigDecimal;
import junit.framework.Test;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.tests.aggregate.AggregateTestModel;
import org.eclipse.persistence.testing.tests.employee.EmployeeBasicTestModel;
import org.eclipse.persistence.testing.tests.inheritance.InheritanceTestModel;
import org.eclipse.persistence.testing.tests.returning.DescriptorExceptionTest;
import org.eclipse.persistence.testing.tests.returning.SubstituteSequencingWithReturningPolicyAdapter;
import org.eclipse.persistence.testing.tests.returning.TestModelAdapted;
import org.eclipse.persistence.testing.tests.returning.model.AdapterForReturningProject;
import org.eclipse.persistence.testing.tests.returning.model.ReturningMappingsTestModel;
import org.eclipse.persistence.testing.tests.writing.ComplexUpdateAndUnitOfWorkTestModel;

public class ReturningPolicyTestModel
extends TestModel {
    boolean supportsAutoCommitOriginal;

    public ReturningPolicyTestModel() {
        this.setDescription("ReturningPolicy Test Model.");
    }

    public void addTests() {
        this.addTest((Test)ReturningPolicyTestModel.getDescriptorExceptionTestSuite());
        if (this.getSession().getPlatform().canBuildCallWithReturning()) {
            this.addTest((Test)new TestModelAdapted(new ComplexUpdateAndUnitOfWorkTestModel(), new SubstituteSequencingWithReturningPolicyAdapter(false)));
            this.addTest((Test)new TestModelAdapted(new EmployeeBasicTestModel(), new SubstituteSequencingWithReturningPolicyAdapter()));
            SubstituteSequencingWithReturningPolicyAdapter substitute = new SubstituteSequencingWithReturningPolicyAdapter();
            substitute.getTableToField().put("BUILDER_CUSTOMER", "CUSTOMER_ID");
            substitute.getTableToSequence().put("BUILDER_CUSTOMER", "CUSTOMER_SEQ");
            this.addTest((Test)new TestModelAdapted(new AggregateTestModel(), substitute));
            this.addTest((Test)new TestModelAdapted(new InheritanceTestModel(), new SubstituteSequencingWithReturningPolicyAdapter()));
        }
        if (this.getSession().getPlatform().canBuildCallWithReturning()) {
            AdapterForReturningProject adapter1 = new AdapterForReturningProject();
            adapter1.addInsertSequenceReadOnly("RETURNING.ID");
            adapter1.addInsert("RETURNING.A1", new BigDecimal(1.5), true);
            adapter1.addInsert("RETURNING.B1", new BigDecimal(0), false);
            adapter1.addInsert("RETURNING.C1", new BigDecimal(0.5), true);
            adapter1.addInsert("RETURNING.A2", new BigDecimal(1.5), true);
            adapter1.addInsert("RETURNING.B2", new BigDecimal(0), false);
            adapter1.addInsert("RETURNING.C2", new BigDecimal(0.5), true);
            adapter1.addUpdate("RETURNING.A1", new BigDecimal(3.5), true);
            adapter1.addUpdate("RETURNING.B1", new BigDecimal(2.5), false);
            adapter1.addUpdate("RETURNING.C1", new BigDecimal(1.5), true);
            adapter1.addUpdate("RETURNING.A2", new BigDecimal(3.5), true);
            adapter1.addUpdate("RETURNING.B2", new BigDecimal(2.5), false);
            adapter1.addUpdate("RETURNING.C2", new BigDecimal(1.5), true);
            TestModelAdapted testModel1 = new TestModelAdapted(new ReturningMappingsTestModel(adapter1), adapter1);
            testModel1.setName(testModel1.getName() + " 1");
            this.addTest((Test)testModel1);
            AdapterForReturningProject adapter2 = new AdapterForReturningProject();
            adapter2.addInsertSequenceReadOnly("RETURNING.ID");
            adapter2.addInsert("RETURNING.B1", new BigDecimal(0), false);
            adapter2.addInsert("RETURNING.C1", new BigDecimal(0.5), true);
            adapter2.addInsert("RETURNING.B2", new BigDecimal(0), false);
            adapter2.addInsert("RETURNING.C2", new BigDecimal(0.5), true);
            adapter2.addUpdate("RETURNING.A1", null, false);
            adapter2.addUpdate("RETURNING.B1", null, false);
            adapter2.addUpdate("RETURNING.C1", null, false);
            adapter2.addUpdate("RETURNING.A2", null, false);
            adapter2.addUpdate("RETURNING.B2", null, false);
            adapter2.addUpdate("RETURNING.C2", null, false);
            TestModelAdapted testModel2 = new TestModelAdapted(new ReturningMappingsTestModel(adapter2), adapter2);
            testModel2.setName(testModel2.getName() + " 2");
            this.addTest((Test)testModel2);
            AdapterForReturningProject adapter3 = new AdapterForReturningProject();
            adapter3.addInsertSequenceReadOnly("RETURNING.ID");
            adapter3.addInsert("RETURNING.A1", new BigDecimal(1.5), true);
            adapter3.addInsert("RETURNING.B1", new BigDecimal(0), false);
            adapter3.addInsert("RETURNING.C1", new BigDecimal(0.5), true);
            adapter3.addInsert("RETURNING.A2", new BigDecimal(1.5), true);
            adapter3.addInsert("RETURNING.B2", new BigDecimal(0), false);
            adapter3.addInsert("RETURNING.C2", new BigDecimal(0.5), true);
            adapter3.addUpdate("RETURNING.A1", new BigDecimal(3.5), false);
            adapter3.addUpdate("RETURNING.B1", new BigDecimal(2.5), false);
            adapter3.addUpdate("RETURNING.C1", new BigDecimal(1.5), false);
            adapter3.addUpdate("RETURNING.A2", new BigDecimal(3.5), false);
            adapter3.addUpdate("RETURNING.B2", new BigDecimal(2.5), false);
            adapter3.addUpdate("RETURNING.C2", new BigDecimal(1.5), false);
            TestModelAdapted testModel3 = new TestModelAdapted(new ReturningMappingsTestModel(adapter3), adapter3);
            testModel3.setName(testModel3.getName() + " 3");
            this.addTest((Test)testModel3);
            AdapterForReturningProject adapter4 = new AdapterForReturningProject();
            adapter4.addInsertSequenceReadOnly("RETURNING.ID");
            adapter4.addInsert("RETURNING.A1", new BigDecimal(1.5), true);
            adapter4.addInsert("RETURNING.B1", new BigDecimal(0), false);
            adapter4.addInsert("RETURNING.C1", new BigDecimal(0.5), true);
            adapter4.addInsert("RETURNING.A2", null, false);
            adapter4.addInsert("RETURNING.B2", null, false);
            adapter4.addInsert("RETURNING.C2", null, false);
            adapter4.addUpdate("RETURNING.B1", new BigDecimal(2.5), true);
            adapter4.addUpdate("RETURNING.C1", new BigDecimal(1.5), true);
            adapter4.addUpdate("RETURNING.B2", new BigDecimal(2.5), true);
            adapter4.addUpdate("RETURNING.C2", new BigDecimal(1.5), true);
            TestModelAdapted testModel4 = new TestModelAdapted(new ReturningMappingsTestModel(adapter4), adapter4);
            testModel4.setName(testModel4.getName() + " 4");
            this.addTest((Test)testModel4);
        }
    }

    public void setup() {
        if (this.getSession().getPlatform().isSybase() || this.getSession().getPlatform().isSQLAnywhere()) {
            this.supportsAutoCommitOriginal = this.getSession().getPlatform().supportsAutoCommit();
            this.getSession().getPlatform().setSupportsAutoCommit(false);
        }
        super.setup();
    }

    public void reset() {
        super.reset();
        if (this.getSession().getPlatform().isSybase() || this.getSession().getPlatform().isSQLAnywhere()) {
            this.getSession().getPlatform().setSupportsAutoCommit(this.supportsAutoCommitOriginal);
        }
    }

    public static TestSuite getDescriptorExceptionTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("DescriptorExceptionTestSuite");
        suite.setDescription("This suite tests DescriptorExceptions thrown during ReturningPolicy.initialize");
        suite.addTest((Test)new DescriptorExceptionTest(185));
        suite.addTest((Test)new DescriptorExceptionTest(186));
        suite.addTest((Test)new DescriptorExceptionTest(187));
        suite.addTest((Test)new DescriptorExceptionTest(188));
        suite.addTest((Test)new DescriptorExceptionTest(190));
        suite.addTest((Test)new DescriptorExceptionTest(191, "sequence"));
        suite.addTest((Test)new DescriptorExceptionTest(191, "locking"));
        suite.addTest((Test)new DescriptorExceptionTest(191, "class"));
        suite.addTest((Test)new DescriptorExceptionTest(192));
        suite.addTest((Test)new DescriptorExceptionTest(193));
        return suite;
    }
}

