/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import java.lang.instrument.IllegalClassFormatException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.weaving.ClassDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassWeaver;
import org.eclipse.persistence.internal.jpa.weaving.ComputeClassWriter;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.commons.SerialVersionUIDAdder;
import org.eclipse.persistence.internal.logging.StdErrLogger;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderFromCurrentThread;
import org.eclipse.persistence.sessions.Session;

public class PersistenceWeaver
implements ClassTransformer {
    protected Map<String, ClassDetails> classDetailsMap;

    public PersistenceWeaver(Session session, Map<String, ClassDetails> classDetailsMap) {
        this.classDetailsMap = classDetailsMap;
    }

    public PersistenceWeaver(Map<String, ClassDetails> classDetailsMap) {
        this.classDetailsMap = classDetailsMap;
    }

    public void clear() {
        this.classDetailsMap = null;
    }

    public Map<String, ClassDetails> getClassDetailsMap() {
        return this.classDetailsMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        boolean shouldLogFinest;
        block25: {
            shouldLogFinest = StdErrLogger.shouldLog((int)1, (String)"weaver");
            Map<String, ClassDetails> classDetailsMap = this.classDetailsMap;
            if (classDetailsMap == null) {
                return null;
            }
            try {
                ClassDetails classDetails = classDetailsMap.get(Helper.toSlashedClassName((String)className));
                if (classDetails != null) {
                    if (shouldLogFinest) {
                        StdErrLogger.log((int)1, (String)"weaver", (String)"begin_weaving_class", (Object[])new Object[]{className});
                    }
                    ClassReader classReader = new ClassReader(classfileBuffer);
                    String reflectiveIntrospectionProperty = PrivilegedAccessHelper.getSystemProperty((String)"eclipselink.weaving.reflective-introspection");
                    ClassWriter classWriter = reflectiveIntrospectionProperty != null ? new ClassWriter(2) : new ComputeClassWriter(loader, 2);
                    ClassWeaver classWeaver = new ClassWeaver((ClassVisitor)classWriter, classDetails);
                    SerialVersionUIDAdder sv = new SerialVersionUIDAdder((ClassVisitor)classWeaver);
                    if (shouldLogFinest) {
                        ClassLoader contextClassLoader;
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderFromCurrentThread());
                            }
                            catch (PrivilegedActionException ex) {
                                throw (RuntimeException)ex.getCause();
                            }
                        } else {
                            contextClassLoader = Thread.currentThread().getContextClassLoader();
                        }
                        if (reflectiveIntrospectionProperty != null) {
                            StdErrLogger.log((int)1, (String)"weaver", (String)"weaving_init_class_writer", (Object[])new Object[]{className, Integer.toHexString(System.identityHashCode(contextClassLoader))});
                        } else {
                            StdErrLogger.log((int)1, (String)"weaver", (String)"weaving_init_compute_class_writer", (Object[])new Object[]{className, Integer.toHexString(System.identityHashCode(contextClassLoader)), loader != null ? Integer.toHexString(System.identityHashCode(loader)) : "null"});
                        }
                    }
                    classReader.accept((ClassVisitor)sv, 0);
                    if (classWeaver.alreadyWeaved) {
                        if (shouldLogFinest) {
                            StdErrLogger.log((int)1, (String)"weaver", (String)"end_weaving_class", (Object[])new Object[]{className});
                        }
                        return null;
                    }
                    if (classWeaver.weaved) {
                        byte[] bytes = classWriter.toByteArray();
                        String outputPath = PrivilegedAccessHelper.getSystemProperty((String)"eclipselink.weaving.output.path", (String)"");
                        if (!outputPath.equals("")) {
                            Helper.outputClassFile((String)className, (byte[])bytes, (String)outputPath);
                        }
                        if (shouldLogFinest) {
                            if (classWeaver.weavedPersistenceEntity) {
                                StdErrLogger.log((int)1, (String)"weaver", (String)"weaved_persistenceentity", (Object[])new Object[]{className});
                            }
                            if (classWeaver.weavedChangeTracker) {
                                StdErrLogger.log((int)1, (String)"weaver", (String)"weaved_changetracker", (Object[])new Object[]{className});
                            }
                            if (classWeaver.weavedLazy) {
                                StdErrLogger.log((int)1, (String)"weaver", (String)"weaved_lazy", (Object[])new Object[]{className});
                            }
                            if (classWeaver.weavedFetchGroups) {
                                StdErrLogger.log((int)1, (String)"weaver", (String)"weaved_fetchgroups", (Object[])new Object[]{className});
                            }
                            if (classWeaver.weavedRest) {
                                StdErrLogger.log((int)1, (String)"weaver", (String)"weaved_rest", (Object[])new Object[]{className});
                            }
                            StdErrLogger.log((int)1, (String)"weaver", (String)"end_weaving_class", (Object[])new Object[]{className});
                        }
                        return bytes;
                    }
                    if (shouldLogFinest) {
                        StdErrLogger.log((int)1, (String)"weaver", (String)"end_weaving_class", (Object[])new Object[]{className});
                    }
                    break block25;
                }
                if (shouldLogFinest) {
                    StdErrLogger.log((int)1, (String)"weaver", (String)"transform_missing_class_details", (Object[])new Object[]{className});
                }
            }
            catch (Throwable exception) {
                if (!StdErrLogger.shouldLog((int)6, (String)"weaver")) break block25;
                StdErrLogger.log((int)6, (String)"weaver", (String)"exception_while_weaving", (Object[])new Object[]{className, exception.getLocalizedMessage()});
                if (!shouldLogFinest) break block25;
                StdErrLogger.logThrowable((int)1, (String)"weaver", (Throwable)exception);
            }
        }
        if (shouldLogFinest) {
            StdErrLogger.log((int)1, (String)"weaver", (String)"transform_existing_class_bytes", (Object[])new Object[]{className});
        }
        return null;
    }

    protected static String getShortName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            if ((name = name.substring(pos + 1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return "";
    }
}

