/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.aggregate.nested.Guardian;
import org.eclipse.persistence.testing.models.aggregate.nested.MailingAddress;
import org.eclipse.persistence.testing.models.aggregate.nested.Student;

public class NestedAggregateTestCase
extends AutoVerifyTestCase {
    public void reset() {
        this.rollbackTransaction();
    }

    protected void setup() {
        this.beginTransaction();
        MailingAddress mailingAddress = new MailingAddress();
        mailingAddress.setStreet("123 Any Street");
        mailingAddress.setCity("Willow Beach");
        mailingAddress.setProvince("Ontario");
        mailingAddress.setCountry("Canada");
        mailingAddress.setPostalCode("A1B 2C3");
        Guardian guardian = new Guardian();
        guardian.setFirstName("John");
        guardian.setLastName("Doe");
        guardian.setMailingAddress(mailingAddress);
        Student student = new Student();
        student.setFirstName("Jane");
        student.setLastName("Doe");
        student.setGuardian(guardian);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)student);
        uow.commit();
    }

    public void test() {
        Student student = (Student)this.getSession().readObject(Student.class);
        student.setGuardian(null);
        this.getSession().refreshObject((Object)student);
    }

    public void verify() {
    }
}

