/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.types;

import java.util.Enumeration;
import junit.framework.Test;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.tests.types.BLOBTester;
import org.eclipse.persistence.testing.tests.types.BooleanTester;
import org.eclipse.persistence.testing.tests.types.CLOBTester;
import org.eclipse.persistence.testing.tests.types.NumericTester;
import org.eclipse.persistence.testing.tests.types.StringTester;
import org.eclipse.persistence.testing.tests.types.TimeDateTester;
import org.eclipse.persistence.testing.tests.types.TypeTestSystem;
import org.eclipse.persistence.testing.tests.types.TypeTester;
import org.eclipse.persistence.testing.tests.types.WriteTypeObjectTest;

public class TypeTestModel
extends TestModel {
    protected boolean useAccessors;

    public TypeTestModel() {
        this(true);
    }

    public TypeTestModel(boolean usingAccessors) {
        this.useAccessors = usingAccessors;
        this.setName(this.toString());
        if (this.useAccessors) {
            this.setDescription("Testing of all the JAVA types and their mappings in TopLink (using Accessors)");
        } else {
            this.setDescription("Testing of all the JAVA types and their mappings in TopLink (without Accessors)");
        }
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new TypeTestSystem());
    }

    public void addTests() {
        this.addTest((Test)TypeTestModel.getBooleanTestSuite());
        this.addTest((Test)TypeTestModel.getTimeDateTestSuite());
        this.addTest((Test)TypeTestModel.getStringTestSuite());
        this.addTest((Test)this.getNumericTestSuite());
        this.addTest((Test)TypeTestModel.getBLOBTestSuite());
        this.addTest((Test)TypeTestModel.getCLOBTestSuite());
    }

    public static TestSuite getBLOBTestSuite() {
        TestSuite suite = new TestSuite();
        Enumeration examples = BLOBTester.testInstances().elements();
        suite.setName("BLOB Types Test Suite");
        suite.setDescription("Tests the use of large byte arrays in JAVA with TopLink");
        while (examples.hasMoreElements()) {
            suite.addTest((Test)new WriteTypeObjectTest((TypeTester)examples.nextElement()));
        }
        return suite;
    }

    public static TestSuite getBooleanTestSuite() {
        TestSuite suite = new TestSuite();
        Enumeration examples = BooleanTester.testInstances().elements();
        suite.setName("Boolean Types Test Suite");
        suite.setDescription("Tests the use of JAVA types boolean & Boolean");
        while (examples.hasMoreElements()) {
            suite.addTest((Test)new WriteTypeObjectTest((TypeTester)examples.nextElement()));
        }
        return suite;
    }

    public static TestSuite getCLOBTestSuite() {
        TestSuite suite = new TestSuite();
        Enumeration examples = CLOBTester.testInstances().elements();
        suite.setName("CLOB Types Test Suite");
        suite.setDescription("Tests the use of long string with TopLink");
        while (examples.hasMoreElements()) {
            suite.addTest((Test)new WriteTypeObjectTest((TypeTester)examples.nextElement()));
        }
        return suite;
    }

    public TestSuite getNumericTestSuite() {
        TestSuite suite = new TestSuite();
        Enumeration examples = NumericTester.testInstances(this.getSession()).elements();
        suite.setName("Numeric Types Test Suite");
        suite.setDescription("Tests the use of all the numeric types in JAVA with TopLink");
        while (examples.hasMoreElements()) {
            suite.addTest((Test)new WriteTypeObjectTest((TypeTester)examples.nextElement()));
        }
        return suite;
    }

    public static TestSuite getStringTestSuite() {
        TestSuite suite = new TestSuite();
        Enumeration examples = StringTester.testInstances().elements();
        suite.setName("String Types Test Suite");
        suite.setDescription("Tests the use of fixed & variable length strings");
        while (examples.hasMoreElements()) {
            suite.addTest((Test)new WriteTypeObjectTest((TypeTester)examples.nextElement()));
        }
        return suite;
    }

    public static TestSuite getTimeDateTestSuite() {
        TestSuite suite = new TestSuite();
        Enumeration examples = TimeDateTester.testInstances().elements();
        suite.setName("Date & Time Types Test Suite");
        suite.setDescription("Tests the use of Date(s)/Time/Timestamp with TopLink");
        while (examples.hasMoreElements()) {
            suite.addTest((Test)new WriteTypeObjectTest((TypeTester)examples.nextElement()));
        }
        return suite;
    }

    public void setup() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        if (this.useAccessors) {
            session.addDescriptor((ClassDescriptor)BooleanTester.descriptorWithAccessors());
            session.addDescriptor((ClassDescriptor)TimeDateTester.descriptorWithAccessors());
            session.addDescriptor((ClassDescriptor)NumericTester.descriptorWithAccessors());
            session.addDescriptor((ClassDescriptor)StringTester.descriptorWithAccessors());
            session.addDescriptor((ClassDescriptor)CLOBTester.descriptorWithAccessors());
            session.addDescriptor((ClassDescriptor)BLOBTester.descriptorWithAccessors());
        } else {
            session.addDescriptor((ClassDescriptor)BooleanTester.descriptor());
            session.addDescriptor((ClassDescriptor)TimeDateTester.descriptor());
            session.addDescriptor((ClassDescriptor)NumericTester.descriptor());
            session.addDescriptor((ClassDescriptor)StringTester.descriptor());
            session.addDescriptor((ClassDescriptor)CLOBTester.descriptor());
            session.addDescriptor((ClassDescriptor)BLOBTester.descriptor());
        }
    }

    public String toString() {
        if (this.useAccessors) {
            return super.toString() + " with Accessors";
        }
        return super.toString() + " without Accessors";
    }
}

