/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReadWeakIdentityMapTest
extends TestCase {
    protected Class identityMapClass;
    protected Class originalIdentityMapClass;
    protected int originalIdentityMapSize;
    protected int querySize;

    public ReadWeakIdentityMapTest(Class mapClass) {
        this.identityMapClass = mapClass;
    }

    protected WeakIdentityMap getIdentityMap() {
        return (WeakIdentityMap)this.getAbstractSession().getIdentityMapAccessorInstance().getIdentityMap(Employee.class);
    }

    public void reset() {
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(this.originalIdentityMapClass);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(this.originalIdentityMapSize);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void setup() {
        this.originalIdentityMapClass = this.getSession().getDescriptor(Employee.class).getIdentityMapClass();
        this.originalIdentityMapSize = this.getSession().getDescriptor(Employee.class).getIdentityMapSize();
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(this.identityMapClass);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(10);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Vector objects = this.getSession().readAllObjects(Employee.class);
        this.querySize = objects.size();
        this.getSession().logMessage("Read " + objects.size() + " objects.");
        this.getSession().logMessage(this.getIdentityMap().getSize() + " are left in the cache.");
    }

    public void test() {
        if (this.getIdentityMap().getSize() == 0) {
            throw new TestWarningException("We did not fill the cache, the test is invalid.");
        }
        int numObjects = 0;
        for (int loops = 0; loops < 10; ++loops) {
            Vector<BigDecimal> vector = new Vector<BigDecimal>(50000);
            for (int i = 0; i < 50000; ++i) {
                vector.addElement(new BigDecimal(i));
            }
            System.gc();
            System.runFinalization();
            Map cache = this.getIdentityMap().getCacheKeys();
            numObjects = 0;
            for (CacheKey key : cache.values()) {
                if (key.getObject() == null) continue;
                ++numObjects;
            }
            if (numObjects == 0) break;
        }
        if (numObjects == this.querySize) {
            throw new TestErrorException("The WeakIdentityMap did not allow any garbage collection.");
        }
        if (numObjects > this.querySize / 2) {
            throw new TestWarningException("The WeakIdentityMap did not garbage collect half of the objects. This may be because of VM differences.");
        }
        if (numObjects > 0) {
            throw new TestWarningException("The WeakIdentityMap did not garbage collect all of the objects. This may be because of VM differences.");
        }
    }
}

