/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReadAllBindAllParametersTest
extends AutoVerifyTestCase {
    protected boolean shouldBindAllParametersSessionOriginal;
    protected Writer originalWriter;
    protected int originalMessageLogging;
    protected ReadAllQuery query;
    protected Vector v = new Vector(2);

    public ReadAllBindAllParametersTest() {
        this.v.addElement(new BigDecimal(1001));
        this.v.addElement(new BigDecimal(1002));
        this.setName("ReadAllBindAllParametersTest");
        this.setDescription("Tests all combinations of shouldBindAllParameters attributes on Session and Query");
    }

    protected void setup() {
        this.shouldBindAllParametersSessionOriginal = this.getSession().getPlatform().shouldBindAllParameters();
        this.originalMessageLogging = this.getSession().getLogLevel();
        this.originalWriter = this.getSession().getLog();
        this.getSession().setLog((Writer)new StringWriter());
        this.getSession().setLogLevel(3);
    }

    protected boolean shouldBind() {
        return !this.query.shouldIgnoreBindAllParameters() && this.query.shouldBindAllParameters() || this.query.shouldIgnoreBindAllParameters() && this.getSession().getPlatform().shouldBindAllParameters();
    }

    protected boolean wasBound() {
        return this.getSession().getLog().toString().indexOf("bind =>") != -1;
    }

    protected void test() {
        for (int i = 0; i <= 1; ++i) {
            this.getSession().getPlatform().setShouldBindAllParameters(i != 0);
            for (int j = 0; j <= 2; ++j) {
                this.query = new ReadAllQuery(Employee.class);
                ExpressionBuilder builder = new ExpressionBuilder();
                Vector<Expression> vExp = new Vector<Expression>(2);
                vExp.add(builder.getParameter("p1"));
                this.query.addArgument("p1");
                vExp.add(builder.getParameter("p2"));
                this.query.addArgument("p2");
                Expression exp = builder.get("id").in(vExp);
                this.query.setSelectionCriteria(exp);
                switch (j) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.query.setShouldBindAllParameters(false);
                        break;
                    }
                    case 2: {
                        this.query.setShouldBindAllParameters(true);
                    }
                }
                ((StringWriter)this.getSession().getLog()).getBuffer().setLength(0);
                try {
                    this.getSession().executeQuery((DatabaseQuery)this.query, (List)this.v);
                }
                catch (DatabaseException e) {
                    throw new TestProblemException("executeQuery threw DatabaseException");
                }
                if (this.shouldBind() == this.wasBound()) continue;
                return;
            }
        }
    }

    protected void verify() throws Exception {
        if (this.shouldBind() != this.wasBound()) {
            String message = this.shouldBind() ? new String("Failed to bind") : new String("Wrongfully bound");
            throw new TestErrorException(message);
        }
    }

    public void reset() {
        this.getSession().getPlatform().setShouldBindAllParameters(this.shouldBindAllParametersSessionOriginal);
        this.getSession().setLog(this.originalWriter);
        this.getSession().setLogLevel(this.originalMessageLogging);
    }
}

