/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.readonly;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Country
implements Serializable {
    public Number id;
    public String name;

    public static Country canada() {
        Country example = new Country();
        example.setName("Canada");
        return example;
    }

    public static Vector countries() {
        Vector<Country> countries = new Vector<Country>();
        countries.addElement(Country.canada());
        countries.addElement(Country.usa());
        countries.addElement(Country.russia());
        countries.addElement(Country.vietnam());
        countries.addElement(Country.india());
        countries.addElement(Country.czech());
        countries.addElement(Country.uk());
        return countries;
    }

    public static Country czech() {
        Country example = new Country();
        example.setName("Czech Republic");
        return example;
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Country.class);
        descriptor.setTableName("COUNTRY");
        descriptor.addPrimaryKeyFieldName("COUNTRY_ID");
        descriptor.setSequenceNumberName("COUNTRY_SEQ");
        descriptor.setSequenceNumberFieldName("COUNTRY_ID");
        descriptor.addDirectMapping("id", "COUNTRY_ID");
        descriptor.addDirectMapping("name", "NAME");
        return descriptor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Country other = (Country)obj;
        return this.getName().equals(other.getName());
    }

    public String getName() {
        return this.name;
    }

    public static Country india() {
        Country example = new Country();
        example.setName("India");
        return example;
    }

    public static Country russia() {
        Country example = new Country();
        example.setName("Russia");
        return example;
    }

    public void setName(String newValue) {
        this.name = newValue;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("COUNTRY");
        definition.addIdentityField("COUNTRY_ID", BigDecimal.class, 15);
        definition.addField("NAME", String.class, 50);
        return definition;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getName() + ") ";
    }

    public static Country uk() {
        Country example = new Country();
        example.setName("United Kingdom");
        return example;
    }

    public static Country usa() {
        Country example = new Country();
        example.setName("USA");
        return example;
    }

    public static Country vietnam() {
        Country example = new Country();
        example.setName("Vietnam");
        return example;
    }
}

