/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.transactionisolation;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.unitofwork.transactionisolation.TransactionIsolationMergeTest;

public class TransactionIsolationMergeOriginalsExistTest
extends TransactionIsolationMergeTest {
    @Override
    public void test() {
        this.unitOfWork.beginEarlyTransaction();
        this.original = (Employee)this.getSession().readObject(Employee.class);
        this.originalFirstName = this.original.getFirstName();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").equal((Object)this.original.getFirstName()).and(builder.get("lastName").equal((Object)this.original.getLastName()));
        Employee employeeClone = (Employee)this.unitOfWork.readAllObjects(Employee.class, expression).elementAt(0);
        employeeClone.setFirstName("elle");
        this.unitOfWork.commit();
        this.unitOfWork = null;
        ReadObjectQuery cacheQuery = new ReadObjectQuery(Employee.class);
        cacheQuery.checkCacheOnly();
        Employee newOriginal = (Employee)this.getSession().executeQuery((DatabaseQuery)cacheQuery);
        this.strongAssert(newOriginal != null, "There should now be an original in the shared cache.");
        this.strongAssert(newOriginal == this.original, "The original should in the shared cache should still have its identity.");
        this.strongAssert(newOriginal.getFirstName().equals("elle"), "Changes were not merged into the shared cache");
    }
}

