/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMPersistAndCommitTest
extends EntityContainerTestBase {
    protected boolean reset = false;
    public Integer[] empIDs = new Integer[2];
    public Integer[] projIDs = new Integer[3];
    public Integer[] addrIDs = new Integer[1];

    public EMPersistAndCommitTest() {
        this.setDescription("Test persist and commit in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        this.reset = true;
    }

    @Override
    public void reset() {
        if (this.reset) {
            this.reset = false;
        }
        super.reset();
    }

    public void test() {
        Employee employee = new Employee();
        Address address = new Address();
        try {
            this.beginTransaction();
            employee.setFirstName("First");
            employee.setLastName("Bean");
            address.setCountry("Canada");
            address.setCity("Ottawa");
            employee.setAddress(address);
            this.getEntityManager().persist((Object)employee);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring create of employee" + ex);
        }
        this.empIDs[0] = employee.getId();
        Project project = new Project();
        try {
            this.beginTransaction();
            project.setName("Project # 1");
            project.setDescription("A simple Project");
            this.getEntityManager().persist((Object)project);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring create of project" + ex);
        }
        this.projIDs[0] = project.getId();
        project = new SmallProject();
        try {
            this.beginTransaction();
            project.setName("Small Project # 1");
            project.setDescription("A small Project");
            this.getEntityManager().persist((Object)project);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring create of SmallProject" + ex);
        }
        this.projIDs[1] = project.getId();
        project = new LargeProject();
        try {
            this.beginTransaction();
            project.setName("LargeProject # 1");
            project.setDescription("A Large Project");
            ((LargeProject)project).setBudget(23000.01);
            this.getEntityManager().persist((Object)project);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring create of largeproject" + ex);
        }
        this.projIDs[2] = project.getId();
        address = new Address();
        try {
            this.beginTransaction();
            address.setCountry("Russia");
            address.setCity("Moscow");
            this.getEntityManager().persist((Object)address);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring create of address1" + ex);
        }
        this.addrIDs[0] = address.getID();
        try {
            this.beginTransaction();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
            emp.addPhoneNumber(ModelExamples.phoneExample1());
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring addition of phonenumber" + ex);
        }
    }

    public void verify() {
        Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (emp == null) {
            throw new TestErrorException("Employee, empID: " + this.empIDs[0] + " Not created");
        }
        if (emp.getPhoneNumbers().size() != 1) {
            throw new TestErrorException("Employee, empID: " + this.empIDs[0] + " PhoneNumber not added");
        }
        if (emp.getAddress() == null) {
            throw new TestErrorException("Employee, empID: " + this.empIDs[0] + " Address not set");
        }
        Project proj = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[0]);
        if (proj == null) {
            throw new TestErrorException("Project, projIDs: " + this.projIDs[0] + " Not created");
        }
        proj = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[1]);
        if (proj == null) {
            throw new TestErrorException("Project, projIDs: " + this.projIDs[1] + " Not created");
        }
        proj = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[2]);
        if (proj == null) {
            throw new TestErrorException("Project, projIDs: " + this.projIDs[2] + " Not created");
        }
        ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        emp = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (emp == null) {
            throw new TestErrorException("Employee, empID: " + this.empIDs[0] + " Not created");
        }
        if (emp.getPhoneNumbers().size() != 1) {
            throw new TestErrorException("Employee, empID: " + this.empIDs[0] + " PhoneNumber not added");
        }
        proj = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[0]);
        if (proj == null) {
            throw new TestErrorException("Project, projIDs: " + this.projIDs[0] + " Not created");
        }
        proj = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[1]);
        if (proj == null) {
            throw new TestErrorException("Project, projIDs: " + this.projIDs[1] + " Not created");
        }
        proj = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[2]);
        if (proj == null) {
            throw new TestErrorException("Project, projIDs: " + this.projIDs[2] + " Not created");
        }
        Address address = (Address)this.getEntityManager().find(Address.class, (Object)this.addrIDs[0]);
        if (address == null) {
            throw new TestErrorException("Address, addrIDs: " + this.addrIDs[0] + " Not created");
        }
    }
}

