/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Room;
import org.eclipse.persistence.testing.models.jpa.advanced.SimpleRoom;
import org.eclipse.persistence.testing.models.jpa.advanced.entities.EntyA;
import org.eclipse.persistence.testing.models.jpa.advanced.entities.EntyC;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;

public class JUnitJPQLUnitTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public JUnitJPQLUnitTestSuite() {
    }

    public JUnitJPQLUnitTestSuite(String name) {
        super(name);
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLUnitTestSuite");
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testSetup"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testSelectPhoneNumberAreaCode"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testSelectPhoneNumberAreaCodeWithEmployee"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testSelectPhoneNumberNumberWithEmployeeWithExplicitJoin"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testSelectPhoneNumberNumberWithEmployeeWithFirstNameFirst"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testSelectEmployeeWithSameParameterUsedMultipleTimes"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testOuterJoinOnOneToOne"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testOuterJoinPolymorphic"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testFirstResultOnNamedQuery"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testInvertedSelectionCriteriaNullPK"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testInvertedSelectionCriteriaInvalidQueryKey"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testMaxAndFirstResultsOnDataQuery"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testMaxAndFirstResultsOnDataQueryWithGroupBy"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testMaxAndFirstResultsOnObjectQueryOnInheritanceRoot"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testDistinctSelectForEmployeeWithNullAddress"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testObjectNullComparisonWithoutForeignKey"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testCollectionMappingInSelectClause"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testCollectionMappingInWhereClause_1"));
        suite.addTest((Test)new JUnitJPQLUnitTestSuite("testCollectionMappingInWhereClause_2"));
        if (!JUnitJPQLUnitTestSuite.isJPA10()) {
            suite.addTest((Test)new JUnitJPQLUnitTestSuite("testResetFirstResultOnQuery"));
            suite.addTest((Test)new JUnitJPQLUnitTestSuite("testSelectNewJPQLQueryWithQueryResultsCache"));
        }
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
    }

    public Vector getAttributeFromAll(String attributeName, Vector objects, Class referenceClass) {
        EntityManager em = this.createEntityManager();
        ClassDescriptor descriptor = JUnitJPQLUnitTestSuite.getServerSession().getClassDescriptor(referenceClass);
        DirectToFieldMapping mapping = (DirectToFieldMapping)descriptor.getMappingForAttributeName(attributeName);
        Vector<Object> attributes = new Vector<Object>();
        for (int i = 0; i < objects.size(); ++i) {
            Object currentObject = objects.elementAt(i);
            if (currentObject.getClass() == ReportQueryResult.class) {
                attributes.addElement(((ReportQueryResult)currentObject).get(attributeName));
                continue;
            }
            attributes.addElement(mapping.getAttributeValueFromObject(currentObject));
        }
        return attributes;
    }

    public void testFirstResultOnNamedQuery() {
        EntityManager em = this.createEntityManager();
        this.clearCache();
        Query query = em.createNamedQuery("findAllEmployeesByFirstName");
        List initialList = query.setParameter("firstname", (Object)"Nancy").setFirstResult(0).getResultList();
        List secondList = query.setParameter("firstname", (Object)"Nancy").setFirstResult(1).getResultList();
        Iterator i = initialList.iterator();
        while (i.hasNext()) {
            JUnitJPQLUnitTestSuite.assertTrue((String)"Employee with incorrect name returned on first query.", (boolean)((Employee)i.next()).getFirstName().equals("Nancy"));
        }
        i = secondList.iterator();
        while (i.hasNext()) {
            JUnitJPQLUnitTestSuite.assertTrue((String)"Employee with incorrect name returned on second query.", (boolean)((Employee)i.next()).getFirstName().equals("Nancy"));
        }
    }

    public void testResetFirstResultOnQuery() {
        EntityManager em = this.createEntityManager();
        this.clearCache();
        Query query = em.createQuery("SELECT e FROM Employee e");
        JUnitJPQLUnitTestSuite.assertEquals((String)"Query's firstResult should be zero", (int)0, (int)query.getFirstResult());
        List controlList = query.getResultList();
        List shortenedResults = query.setFirstResult(2).getResultList();
        JUnitJPQLUnitTestSuite.assertEquals((String)"Full list should be shorter than the control results list", (int)(controlList.size() - 2), (int)shortenedResults.size());
        query.setFirstResult(0);
        JUnitJPQLUnitTestSuite.assertEquals((String)"Query's firstResult should have been reset to zero", (int)0, (int)query.getFirstResult());
        List fullResults = query.getResultList();
        JUnitJPQLUnitTestSuite.assertEquals((String)"Full list should be the same as the control results list", (int)controlList.size(), (int)fullResults.size());
        List shortenedResults2 = query.setFirstResult(3).getResultList();
        JUnitJPQLUnitTestSuite.assertEquals((String)"Full list should be shorter than the control results list #2", (int)(controlList.size() - 3), (int)shortenedResults2.size());
        query.setFirstResult(0);
        JUnitJPQLUnitTestSuite.assertEquals((String)"Query's firstResult should have been reset to zero", (int)0, (int)query.getFirstResult());
    }

    public void testOuterJoinOnOneToOne() {
        EntityManager em = this.createEntityManager();
        this.clearCache();
        this.beginTransaction(em);
        int initialSize = em.createQuery("SELECT e from Employee e JOIN e.address a").getResultList().size();
        Employee emp = new Employee();
        emp.setFirstName("Steve");
        emp.setLastName("Harp");
        em.persist((Object)emp);
        em.flush();
        List result = em.createQuery("SELECT e from Employee e LEFT OUTER JOIN e.address a").getResultList();
        JUnitJPQLUnitTestSuite.assertTrue((String)"Outer join was not properly added to the query", (initialSize + 1 == result.size() ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testOuterJoinPolymorphic() {
        EntityManager em = this.createEntityManager();
        this.clearCache();
        List resultList = null;
        try {
            resultList = em.createQuery("SELECT p FROM Project p").getResultList();
        }
        catch (Exception exception) {
            JUnitJPQLUnitTestSuite.fail((String)("Exception caught while executing polymorphic query.  This may mean that outer join is not working correctly on your database platfrom: " + exception.toString()));
        }
        JUnitJPQLUnitTestSuite.assertTrue((String)"Incorrect number of projects returned.", (resultList.size() == 15 ? 1 : 0) != 0);
    }

    public void testSelectPhoneNumberAreaCode() {
        ExpressionBuilder employeeBuilder = new ExpressionBuilder();
        Expression phones = employeeBuilder.anyOf("phoneNumbers");
        Expression whereClause = phones.get("areaCode").equal((Object)"613");
        ReportQuery rq = new ReportQuery();
        rq.setSelectionCriteria(whereClause);
        rq.addAttribute("areaCode", new ExpressionBuilder().anyOf("phoneNumbers").get("areaCode"));
        rq.setReferenceClass(Employee.class);
        rq.dontUseDistinct();
        EntityManager em = this.createEntityManager();
        Vector expectedResult = this.getAttributeFromAll("areaCode", (Vector)JUnitJPQLUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)rq), Employee.class);
        this.clearCache();
        List result = em.createQuery("SELECT phone.areaCode FROM Employee employee, IN (employee.phoneNumbers) phone WHERE phone.areaCode = \"613\"").getResultList();
        Assert.assertTrue((String)"SimpleSelectPhoneNumberAreaCode test failed !", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void testSelectPhoneNumberAreaCodeWithEmployee() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").equal((Object)"Bob");
        exp = exp.and(employees.get("lastName").equal((Object)"Smith"));
        Employee emp = (Employee)JUnitJPQLUnitTestSuite.getServerSession().readAllObjects(Employee.class, exp).firstElement();
        PhoneNumber phone = (PhoneNumber)((Vector)emp.getPhoneNumbers()).firstElement();
        String areaCode = phone.getAreaCode();
        String firstName = emp.getFirstName();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder();
        Expression phones = employeeBuilder.anyOf("phoneNumbers");
        Expression whereClause = phones.get("areaCode").equal((Object)areaCode).and(phones.get("owner").get("firstName").equal((Object)firstName));
        ReportQuery rq = new ReportQuery();
        rq.setSelectionCriteria(whereClause);
        rq.addAttribute("areaCode", phones.get("areaCode"));
        rq.setReferenceClass(Employee.class);
        rq.dontMaintainCache();
        Vector expectedResult = this.getAttributeFromAll("areaCode", (Vector)JUnitJPQLUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)rq), Employee.class);
        this.clearCache();
        String ejbqlString = "SELECT phone.areaCode FROM Employee employee, IN (employee.phoneNumbers) phone WHERE phone.areaCode = \"" + areaCode + "\" AND phone.owner.firstName = \"" + firstName + "\"";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"SimpleSelectPhoneNumberAreaCodeWithEmployee test failed !", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void testSelectPhoneNumberNumberWithEmployeeWithExplicitJoin() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").equal((Object)"Bob");
        exp = exp.and(employees.get("lastName").equal((Object)"Smith"));
        Employee emp = (Employee)JUnitJPQLUnitTestSuite.getServerSession().readAllObjects(Employee.class, exp).firstElement();
        PhoneNumber phone = (PhoneNumber)((Vector)emp.getPhoneNumbers()).firstElement();
        String areaCode = phone.getAreaCode();
        String firstName = emp.getFirstName();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        Expression phones = employeeBuilder.anyOf("phoneNumbers");
        Expression whereClause = phones.get("areaCode").equal((Object)areaCode).and(phones.get("owner").get("id").equal(employeeBuilder.get("id")).and(employeeBuilder.get("firstName").equal((Object)firstName)));
        ReportQuery rq = new ReportQuery();
        rq.addAttribute("number", new ExpressionBuilder().anyOf("phoneNumbers").get("number"));
        rq.setSelectionCriteria(whereClause);
        rq.setReferenceClass(Employee.class);
        Vector expectedResult = this.getAttributeFromAll("number", (Vector)JUnitJPQLUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)rq), Employee.class);
        this.clearCache();
        String ejbqlString = "SELECT phone.number FROM Employee employee, IN (employee.phoneNumbers) phone WHERE phone.areaCode = \"" + areaCode + "\" AND (phone.owner.id = employee.id AND employee.firstName = \"" + firstName + "\")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"SimpleSelectPhoneNumberAreaCodeWithEmployee test failed !", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void testSelectPhoneNumberNumberWithEmployeeWithFirstNameFirst() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").equal((Object)"Bob");
        exp = exp.and(employees.get("lastName").equal((Object)"Smith"));
        Employee emp = (Employee)JUnitJPQLUnitTestSuite.getServerSession().readAllObjects(Employee.class, exp).firstElement();
        PhoneNumber phone = (PhoneNumber)((Vector)emp.getPhoneNumbers()).firstElement();
        String areaCode = phone.getAreaCode();
        String firstName = emp.getFirstName();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder();
        Expression phones = employeeBuilder.anyOf("phoneNumbers");
        Expression whereClause = phones.get("owner").get("firstName").equal((Object)firstName).and(phones.get("areaCode").equal((Object)areaCode));
        ReportQuery rq = new ReportQuery();
        rq.setSelectionCriteria(whereClause);
        rq.addAttribute("number", phones.get("number"));
        rq.setReferenceClass(Employee.class);
        Vector expectedResult = this.getAttributeFromAll("number", (Vector)JUnitJPQLUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)rq), Employee.class);
        this.clearCache();
        String ejbqlString = "SELECT phone.number FROM Employee employee, IN(employee.phoneNumbers) phone WHERE phone.owner.firstName = \"" + firstName + "\" AND phone.areaCode = \"" + areaCode + "\"";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"SimpleSelectPhoneNumberAreaCodeWithEmployee test failed !", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void testSelectEmployeeWithSameParameterUsedMultipleTimes() {
        Exception exception = null;
        try {
            String ejbqlString = "SELECT emp FROM Employee emp WHERE emp.id > :param1 OR :param1 IS null";
            this.createEntityManager().createQuery(ejbqlString).setParameter("param1", (Object)1).getResultList();
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertNull((String)"Exception was caught.", (Object)exception);
    }

    public void testInvertedSelectionCriteriaNullPK() {
        Exception exception = null;
        try {
            String jpqlString = "SELECT e, p FROM Employee e, PhoneNumber p WHERE p.id = e.id AND e.firstName = 'Bob'";
            List list = this.createEntityManager().createQuery(jpqlString).getResultList();
        }
        catch (Exception e) {
            this.logThrowable(exception);
            exception = e;
        }
        Assert.assertNull((String)"Exception was caught.", (Object)exception);
    }

    public void testMaxAndFirstResultsOnDataQuery() {
        EntityManager em = this.createEntityManager();
        Exception exception = null;
        List resultList = null;
        this.clearCache();
        Query query = em.createQuery("SELECT e.id, m.id FROM Employee e LEFT OUTER JOIN e.manager m");
        try {
            query.setFirstResult(1);
            query.setMaxResults(1);
            resultList = query.getResultList();
        }
        catch (Exception e) {
            this.logThrowable(exception);
            exception = e;
        }
        Assert.assertNull((String)("Exception was caught: " + exception), (Object)exception);
        Assert.assertTrue((String)("Incorrect number of results returned.  Expected 1, returned " + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
    }

    public void testMaxAndFirstResultsOnDataQueryWithGroupBy() {
        EntityManager em = this.createEntityManager();
        Exception exception = null;
        List resultList = null;
        this.clearCache();
        Query query = em.createQuery("SELECT e.id FROM Employee e group by e.id");
        try {
            query.setFirstResult(1);
            query.setMaxResults(1);
            resultList = query.getResultList();
        }
        catch (Exception e) {
            this.logThrowable(exception);
            exception = e;
        }
        Assert.assertNull((String)"Exception was caught.", (Object)exception);
        Assert.assertTrue((String)("Incorrect number of results returned.  Expected 1, returned " + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
    }

    public void testMaxAndFirstResultsOnObjectQueryOnInheritanceRoot() {
        EntityManager em = this.createEntityManager();
        Exception exception = null;
        List resultList = null;
        this.clearCache();
        Query query = em.createQuery("SELECT p FROM Project p");
        try {
            query.setFirstResult(6);
            query.setMaxResults(1);
            resultList = query.getResultList();
        }
        catch (Exception e) {
            exception = e;
            this.logThrowable(exception);
        }
        Assert.assertNull((String)"Exception was caught.", (Object)exception);
        Assert.assertTrue((String)("Incorrect number of results returned.  Expected 1, returned " + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
    }

    public void testInvertedSelectionCriteriaInvalidQueryKey() {
        Exception exception = null;
        try {
            String jpqlString = "select e, a from Employee e, Address a where a.city = 'Ottawa' and e.address.country = a.country";
            List list = this.createEntityManager().createQuery(jpqlString).getResultList();
        }
        catch (Exception e) {
            this.logThrowable(e);
            exception = e;
        }
        Assert.assertNull((String)"Exception was caught.", (Object)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistinctSelectForEmployeeWithNullAddress() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Employee emp = new Employee();
            emp.setFirstName("Dummy");
            emp.setLastName("Person");
            em.persist((Object)emp);
            em.flush();
            List list = em.createQuery("SELECT DISTINCT e.address FROM Employee e").getResultList();
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObjectNullComparisonWithoutForeignKey() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            EntyC c1 = new EntyC();
            c1.setName("East");
            em.persist((Object)c1);
            EntyC c2 = new EntyC();
            c2.setName("West");
            em.persist((Object)c2);
            EntyC c3 = new EntyC();
            c3.setName("North");
            em.persist((Object)c3);
            EntyC c4 = new EntyC();
            c4.setName("South");
            em.persist((Object)c4);
            EntyA a1 = new EntyA();
            a1.setName("Left");
            a1.setEntyC(c1);
            em.persist((Object)a1);
            EntyA a2 = new EntyA();
            a2.setName("Center");
            a2.setEntyC(c2);
            em.persist((Object)a2);
            EntyA a3 = new EntyA();
            a3.setName("Right");
            a3.setEntyC(c3);
            em.persist((Object)a3);
            em.flush();
            String values = c1.getId() + ", " + c2.getId() + ", " + c4.getId();
            String jpqlString = "SELECT c FROM EntyC c WHERE c.id IN (" + values + ") AND c.entyA IS NOT NULL";
            List result = em.createQuery(jpqlString).getResultList();
            JUnitJPQLUnitTestSuite.assertEquals((String)"Incorrect result found with \"is not null\" object comparison and source without foreign key dependency to its target in One To One Mapping", (int)2, (int)result.size());
            jpqlString = "SELECT c FROM EntyC c LEFT OUTER JOIN c.entyA a WHERE c.id IN (" + values + ") AND a IS NULL";
            result = em.createQuery(jpqlString).getResultList();
            JUnitJPQLUnitTestSuite.assertEquals((String)"Incorrect result found with \"is null\" object comparison and source without foreign key dependency to its target in One To One Mapping", (int)1, (int)result.size());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testCollectionMappingInSelectClause() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createQuery("SELECT e.phoneNumbers FROM Employee e");
            query.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCollectionMappingInWhereClause_1() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createQuery("Select e.phoneNumbers from Employee e");
            List result = query.getResultList();
            query = em.createQuery("Select e from Employee e where e.phoneNumbers = :phone");
            query.setParameter("phone", result.get(0));
            query.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    public void testCollectionMappingInWhereClause_2() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createQuery("Select e from Employee e where e.phoneNumbers.areaCode = '613'");
            query.getResultList();
            JUnitJPQLUnitTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query navigating a collection valued association field in the SELECT clause.");
        }
        catch (Exception exception) {
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSelectNewJPQLQueryWithQueryResultsCache() {
        EntityManager em = this.createEntityManager();
        QuerySQLTracker tracker = null;
        this.beginTransaction(em);
        Room testRoom = new Room();
        int width = 10;
        int length = 8;
        testRoom.setWidth(10);
        testRoom.setLength(8);
        testRoom.setHeight(12);
        em.persist((Object)testRoom);
        this.commitTransaction(em);
        this.clearCache();
        em = this.createEntityManager();
        try {
            int numberOfExecutions = 6;
            for (int i = 0; i < numberOfExecutions; ++i) {
                Query query = em.createNamedQuery("room.findSimpleRoomByWidthLength");
                query.setParameter("width", (Object)10);
                query.setParameter("length", (Object)8);
                SimpleRoom simpleRoom = (SimpleRoom)query.getSingleResult();
                JUnitJPQLUnitTestSuite.assertNotNull((String)"Returned Entity should be non-null", (Object)simpleRoom);
                JUnitJPQLUnitTestSuite.assertEquals((String)"width must be the same", (int)simpleRoom.getWidth(), (int)10);
                JUnitJPQLUnitTestSuite.assertEquals((String)"length must be the same", (int)simpleRoom.getLength(), (int)8);
                if (tracker != null) continue;
                tracker = new QuerySQLTracker((Session)JUnitJPQLUnitTestSuite.getServerSession());
            }
            JUnitJPQLUnitTestSuite.assertEquals((String)"More SQL queries executed than expected", (int)0, (int)tracker.getSqlStatements().size());
        }
        finally {
            Room existingRoom;
            if (tracker != null) {
                tracker.remove();
            }
            if (testRoom != null && (existingRoom = (Room)em.find(Room.class, (Object)testRoom.getId())) != null) {
                this.beginTransaction(em);
                em.remove(em.find(Room.class, (Object)testRoom.getId()));
                this.commitTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

