/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.testing.framework.TestCase;

public abstract class MemoryLeakTestCase
extends TestCase {
    protected List<WeakReference> weakList;
    protected int threshold = 0;

    public void addWeakReference(Object reference) {
        this.weakList.add(new WeakReference<Object>(reference));
    }

    public void addWeakReferences(List references) {
        for (Object ref : references) {
            this.addWeakReference(ref);
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void setup() {
        this.weakList = new ArrayList<WeakReference>();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    @Override
    public void verify() {
        this.forceGC();
        int count = 0;
        for (WeakReference ref : this.weakList) {
            if (ref.get() == null) continue;
            ++count;
        }
        if (count > this.threshold) {
            this.throwError("Objects did not garbage collect: " + count);
        }
    }
}

