/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.schemaframework;

import junit.framework.Test;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public final class TablesCheckTestSuite
extends TestSuite {
    private static final TableDefinition BEER_TD = TablesCheckTestSuite.tableDefinition("TCT_BEER");
    private static final TableDefinition WATER_TD = TablesCheckTestSuite.tableDefinition("TCT_WATER");

    public static TestSuite suite() {
        TablesCheckTestSuite suite = new TablesCheckTestSuite();
        suite.setName("Test table existence check");
        suite.addTest((Test)new CurrentPlatformExistingTableTablesCheckTest());
        suite.addTest((Test)new CurrentPlatformNonExistingTableTablesCheckTest());
        suite.addTest((Test)new DefaultPlatformExistingTableTablesCheckTest());
        suite.addTest((Test)new DefaultPlatformNonExistingTableTablesCheckTest());
        return suite;
    }

    private static final TableDefinition tableDefinition(String name) {
        TableDefinition table = new TableDefinition();
        table.setName(name);
        table.addField("NAME", Integer.class);
        table.addField("BRAND", String.class);
        return table;
    }

    public void setup() {
        TableCreator creator = new TableCreator();
        creator.addTableDefinition(BEER_TD);
        DatabaseSession session = this.getDatabaseSession();
        SchemaManager manager = new SchemaManager(this.getDatabaseSession());
        creator.createTables(session, manager);
    }

    public static final class DefaultPlatformNonExistingTableTablesCheckTest
    extends TablesCheckTest {
        DefaultPlatformNonExistingTableTablesCheckTest() {
        }

        public void test() {
            DatabasePlatform defaultPlatform = new DatabasePlatform();
            boolean waterExists = defaultPlatform.checkTableExists((DatabaseSessionImpl)this.session, WATER_TD, false);
            DefaultPlatformNonExistingTableTablesCheckTest.assertFalse((boolean)waterExists);
        }
    }

    public static final class DefaultPlatformExistingTableTablesCheckTest
    extends TablesCheckTest {
        DefaultPlatformExistingTableTablesCheckTest() {
        }

        public void test() {
            DatabasePlatform defaultPlatform = new DatabasePlatform();
            boolean beerExists = defaultPlatform.checkTableExists((DatabaseSessionImpl)this.session, BEER_TD, false);
            DefaultPlatformExistingTableTablesCheckTest.assertTrue((boolean)beerExists);
        }
    }

    public static final class CurrentPlatformNonExistingTableTablesCheckTest
    extends TablesCheckTest {
        CurrentPlatformNonExistingTableTablesCheckTest() {
        }

        public void test() {
            boolean waterExists = this.manager.checkTableExists(WATER_TD, false);
            CurrentPlatformNonExistingTableTablesCheckTest.assertFalse((boolean)waterExists);
        }
    }

    public static final class CurrentPlatformExistingTableTablesCheckTest
    extends TablesCheckTest {
        CurrentPlatformExistingTableTablesCheckTest() {
        }

        public void test() {
            boolean beerExists = this.manager.checkTableExists(BEER_TD, false);
            CurrentPlatformExistingTableTablesCheckTest.assertTrue((boolean)beerExists);
        }
    }

    public static abstract class TablesCheckTest
    extends TestCase {
        protected DatabaseSession session = null;
        protected SchemaManager manager = null;

        TablesCheckTest() {
        }

        public void setup() {
            this.session = this.getDatabaseSession();
            this.manager = new SchemaManager(this.getDatabaseSession());
        }

        public void reset() {
            this.manager = null;
            this.session = null;
        }
    }

    public static final class Model
    extends TestModel {
        public void addTests() {
            this.addTest((Test)TablesCheckTestSuite.suite());
        }
    }
}

