/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.Handle;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.TypePath;
import org.eclipse.persistence.internal.libraries.asm.TypeReference;
import org.eclipse.persistence.internal.libraries.asm.signature.SignatureReader;
import org.eclipse.persistence.internal.libraries.asm.util.Printer;
import org.eclipse.persistence.internal.libraries.asm.util.Textifiable;
import org.eclipse.persistence.internal.libraries.asm.util.TraceSignatureVisitor;

public class Textifier
extends Printer {
    public static final int INTERNAL_NAME = 0;
    public static final int FIELD_DESCRIPTOR = 1;
    public static final int FIELD_SIGNATURE = 2;
    public static final int METHOD_DESCRIPTOR = 3;
    public static final int METHOD_SIGNATURE = 4;
    public static final int CLASS_SIGNATURE = 5;
    @Deprecated
    public static final int TYPE_DECLARATION = 6;
    @Deprecated
    public static final int CLASS_DECLARATION = 7;
    @Deprecated
    public static final int PARAMETERS_DECLARATION = 8;
    public static final int HANDLE_DESCRIPTOR = 9;
    private static final String CLASS_SUFFIX = ".class";
    private static final String DEPRECATED = "// DEPRECATED\n";
    private static final String INVISIBLE = " // invisible\n";
    protected String tab = "  ";
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    protected Map<Label, String> labelNames;
    private int access;
    private int numAnnotationValues;

    public Textifier() {
        this(393216);
        if (this.getClass() != Textifier.class) {
            throw new IllegalStateException();
        }
    }

    protected Textifier(int n) {
        super(n);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "Prints a disassembled view of the given class.\nUsage: Textifier [-debug] <fully qualified class name or class file name>";
        Textifier.main(string, new Textifier(), stringArray);
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        if ((n2 & 0x8000) != 0) {
            return;
        }
        this.access = n2;
        int n3 = n & 0xFFFF;
        int n4 = n >>> 16;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("// class version ").append(n3).append('.').append(n4).append(" (").append(n).append(")\n");
        if ((n2 & 0x20000) != 0) {
            this.stringBuilder.append(DEPRECATED);
        }
        this.appendRawAccess(n2);
        this.appendDescriptor(5, string2);
        if (string2 != null) {
            this.appendJavaDeclaration(string2);
        }
        this.appendAccess(n2 & 0xFFFF7FDF);
        if ((n2 & 0x2000) != 0) {
            this.stringBuilder.append("@interface ");
        } else if ((n2 & 0x200) != 0) {
            this.stringBuilder.append("interface ");
        } else if ((n2 & 0x4000) == 0) {
            this.stringBuilder.append("class ");
        }
        this.appendDescriptor(0, string);
        if (string3 != null && !"java/lang/Object".equals(string3)) {
            this.stringBuilder.append(" extends ");
            this.appendDescriptor(0, string3);
            this.stringBuilder.append(' ');
        }
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append(" implements ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.appendDescriptor(0, stringArray[i]);
                this.stringBuilder.append(' ');
            }
        }
        this.stringBuilder.append(" {\n\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitSource(String string, String string2) {
        this.stringBuilder.setLength(0);
        if (string != null) {
            this.stringBuilder.append(this.tab).append("// compiled from: ").append(string).append('\n');
        }
        if (string2 != null) {
            this.stringBuilder.append(this.tab).append("// debug info: ").append(string2).append('\n');
        }
        if (this.stringBuilder.length() > 0) {
            this.text.add(this.stringBuilder.toString());
        }
    }

    @Override
    public Printer visitModule(String string, int n, String string2) {
        this.stringBuilder.setLength(0);
        if ((n & 0x20) != 0) {
            this.stringBuilder.append("open ");
        }
        this.stringBuilder.append("module ").append(string).append(" { ").append(string2 == null ? "" : "// " + string2).append("\n\n");
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("OUTERCLASS ");
        this.appendDescriptor(0, string);
        this.stringBuilder.append(' ');
        if (string2 != null) {
            this.stringBuilder.append(string2).append(' ');
        }
        this.appendDescriptor(3, string3);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public Textifier visitClassAnnotation(String string, boolean bl) {
        this.text.add("\n");
        return this.visitAnnotation(string, bl);
    }

    @Override
    public Printer visitClassTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.text.add("\n");
        return this.visitTypeAnnotation(n, typePath, string, bl);
    }

    @Override
    public void visitClassAttribute(Attribute attribute) {
        this.text.add("\n");
        this.visitAttribute(attribute);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(n & 0xFFFFFFDF);
        this.stringBuilder.append(this.tab);
        this.appendAccess(n);
        this.stringBuilder.append("INNERCLASS ");
        this.appendDescriptor(0, string);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, string2);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, string3);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public Textifier visitField(int n, String string, String string2, String string3, Object object) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append('\n');
        if ((n & 0x20000) != 0) {
            this.stringBuilder.append(this.tab).append(DEPRECATED);
        }
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(n);
        if (string3 != null) {
            this.stringBuilder.append(this.tab);
            this.appendDescriptor(2, string3);
            this.stringBuilder.append(this.tab);
            this.appendJavaDeclaration(string3);
        }
        this.stringBuilder.append(this.tab);
        this.appendAccess(n);
        this.appendDescriptor(1, string2);
        this.stringBuilder.append(' ').append(string);
        if (object != null) {
            this.stringBuilder.append(" = ");
            if (object instanceof String) {
                this.stringBuilder.append('\"').append(object).append('\"');
            } else {
                this.stringBuilder.append(object);
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    @Override
    public Textifier visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append('\n');
        if ((n & 0x20000) != 0) {
            this.stringBuilder.append(this.tab).append(DEPRECATED);
        }
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(n);
        if (string3 != null) {
            this.stringBuilder.append(this.tab);
            this.appendDescriptor(4, string3);
            this.stringBuilder.append(this.tab);
            this.appendJavaDeclaration(string3);
        }
        this.stringBuilder.append(this.tab);
        this.appendAccess(n & 0xFFFFFF3F);
        if ((n & 0x100) != 0) {
            this.stringBuilder.append("native ");
        }
        if ((n & 0x80) != 0) {
            this.stringBuilder.append("varargs ");
        }
        if ((n & 0x40) != 0) {
            this.stringBuilder.append("bridge ");
        }
        if ((this.access & 0x200) != 0 && (n & 0x408) == 0) {
            this.stringBuilder.append("default ");
        }
        this.stringBuilder.append(string);
        this.appendDescriptor(3, string2);
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append(" throws ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.appendDescriptor(0, stringArray[i]);
                this.stringBuilder.append(' ');
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    @Override
    public void visitClassEnd() {
        this.text.add("}\n");
    }

    @Override
    public void visitMainClass(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("  // main class ").append(string).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitPackage(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("  // package ").append(string).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitRequire(String string, int n, String string2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("requires ");
        if ((n & 0x20) != 0) {
            this.stringBuilder.append("transitive ");
        }
        if ((n & 0x40) != 0) {
            this.stringBuilder.append("static ");
        }
        this.stringBuilder.append(string).append(';');
        this.appendRawAccess(n);
        if (string2 != null) {
            this.stringBuilder.append("  // version ").append(string2).append('\n');
        }
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitExport(String string, int n, String ... stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("exports ");
        this.stringBuilder.append(string);
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append(" to");
        } else {
            this.stringBuilder.append(';');
        }
        this.appendRawAccess(n);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.stringBuilder.append(this.tab2).append(stringArray[i]);
                this.stringBuilder.append(i != stringArray.length - 1 ? ",\n" : ";\n");
            }
        }
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitOpen(String string, int n, String ... stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("opens ");
        this.stringBuilder.append(string);
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append(" to");
        } else {
            this.stringBuilder.append(';');
        }
        this.appendRawAccess(n);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.stringBuilder.append(this.tab2).append(stringArray[i]);
                this.stringBuilder.append(i != stringArray.length - 1 ? ",\n" : ";\n");
            }
        }
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitUse(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("uses ");
        this.appendDescriptor(0, string);
        this.stringBuilder.append(";\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitProvide(String string, String ... stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("provides ");
        this.appendDescriptor(0, string);
        this.stringBuilder.append(" with\n");
        for (int i = 0; i < stringArray.length; ++i) {
            this.stringBuilder.append(this.tab2);
            this.appendDescriptor(0, stringArray[i]);
            this.stringBuilder.append(i != stringArray.length - 1 ? ",\n" : ";\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitModuleEnd() {
    }

    @Override
    public void visit(String string, Object object) {
        this.visitAnnotationValue(string);
        if (object instanceof String) {
            this.visitString((String)object);
        } else if (object instanceof Type) {
            this.visitType((Type)object);
        } else if (object instanceof Byte) {
            this.visitByte((Byte)object);
        } else if (object instanceof Boolean) {
            this.visitBoolean((Boolean)object);
        } else if (object instanceof Short) {
            this.visitShort((Short)object);
        } else if (object instanceof Character) {
            this.visitChar(((Character)object).charValue());
        } else if (object instanceof Integer) {
            this.visitInt((Integer)object);
        } else if (object instanceof Float) {
            this.visitFloat(((Float)object).floatValue());
        } else if (object instanceof Long) {
            this.visitLong((Long)object);
        } else if (object instanceof Double) {
            this.visitDouble((Double)object);
        } else if (object.getClass().isArray()) {
            this.stringBuilder.append('{');
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < byArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitByte(byArray[i]);
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < blArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitBoolean(blArray[i]);
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                for (int i = 0; i < sArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitShort(sArray[i]);
                }
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                for (int i = 0; i < cArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitChar(cArray[i]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitInt(nArray[i]);
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitLong(lArray[i]);
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                for (int i = 0; i < fArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitFloat(fArray[i]);
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                for (int i = 0; i < dArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitDouble(dArray[i]);
                }
            }
            this.stringBuilder.append('}');
        }
        this.text.add(this.stringBuilder.toString());
    }

    private void visitInt(int n) {
        this.stringBuilder.append(n);
    }

    private void visitLong(long l) {
        this.stringBuilder.append(l).append('L');
    }

    private void visitFloat(float f) {
        this.stringBuilder.append(f).append('F');
    }

    private void visitDouble(double d) {
        this.stringBuilder.append(d).append('D');
    }

    private void visitChar(char c) {
        this.stringBuilder.append("(char)").append((int)c);
    }

    private void visitShort(short s) {
        this.stringBuilder.append("(short)").append(s);
    }

    private void visitByte(byte by) {
        this.stringBuilder.append("(byte)").append(by);
    }

    private void visitBoolean(boolean bl) {
        this.stringBuilder.append(bl);
    }

    private void visitString(String string) {
        Textifier.appendString(this.stringBuilder, string);
    }

    private void visitType(Type type) {
        this.stringBuilder.append(type.getClassName()).append(CLASS_SUFFIX);
    }

    @Override
    public void visitEnum(String string, String string2, String string3) {
        this.visitAnnotationValue(string);
        this.appendDescriptor(1, string2);
        this.stringBuilder.append('.').append(string3);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public Textifier visitAnnotation(String string, String string2) {
        this.visitAnnotationValue(string);
        this.stringBuilder.append('@');
        this.appendDescriptor(1, string2);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(")");
    }

    @Override
    public Textifier visitArray(String string) {
        this.visitAnnotationValue(string);
        this.stringBuilder.append('{');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier("}");
    }

    @Override
    public void visitAnnotationEnd() {
    }

    private void visitAnnotationValue(String string) {
        this.stringBuilder.setLength(0);
        this.maybeAppendComma(this.numAnnotationValues++);
        if (string != null) {
            this.stringBuilder.append(string).append('=');
        }
    }

    @Override
    public Textifier visitFieldAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    @Override
    public Printer visitFieldTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n, typePath, string, bl);
    }

    @Override
    public void visitFieldAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    @Override
    public void visitFieldEnd() {
    }

    @Override
    public void visitParameter(String string, int n) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("// parameter ");
        this.appendAccess(n);
        this.stringBuilder.append(' ').append(string == null ? "<no name>" : string).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public Textifier visitAnnotationDefault() {
        this.text.add(this.tab2 + "default=");
        return this.addNewTextifier("\n");
    }

    @Override
    public Textifier visitMethodAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    @Override
    public Printer visitMethodTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n, typePath, string, bl);
    }

    @Override
    public Textifier visitAnnotableParameterCount(int n, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("// annotable parameter count: ");
        this.stringBuilder.append(n);
        this.stringBuilder.append(bl ? " (visible)\n" : " (invisible)\n");
        this.text.add(this.stringBuilder.toString());
        return this;
    }

    @Override
    public Textifier visitParameterAnnotation(int n, String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append('@');
        this.appendDescriptor(1, string);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(bl ? ") // parameter " : ") // invisible, parameter ").append(n).append('\n');
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    @Override
    public void visitMethodAttribute(Attribute attribute) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        if (attribute instanceof Textifiable) {
            StringBuffer stringBuffer = new StringBuffer();
            ((Textifiable)((Object)attribute)).textify(stringBuffer, this.labelNames);
            this.stringBuilder.append(stringBuffer.toString());
        } else {
            this.stringBuilder.append(" : unknown\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitCode() {
    }

    @Override
    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.ltab);
        this.stringBuilder.append("FRAME ");
        switch (n) {
            case -1: 
            case 0: {
                this.stringBuilder.append("FULL [");
                this.appendFrameTypes(n2, objectArray);
                this.stringBuilder.append("] [");
                this.appendFrameTypes(n3, objectArray2);
                this.stringBuilder.append(']');
                break;
            }
            case 1: {
                this.stringBuilder.append("APPEND [");
                this.appendFrameTypes(n2, objectArray);
                this.stringBuilder.append(']');
                break;
            }
            case 2: {
                this.stringBuilder.append("CHOP ").append(n2);
                break;
            }
            case 3: {
                this.stringBuilder.append("SAME");
                break;
            }
            case 4: {
                this.stringBuilder.append("SAME1 ");
                this.appendFrameTypes(1, objectArray2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitInsn(int n) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n]).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitIntInsn(int n, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n]).append(' ').append(n == 188 ? TYPES[n2] : Integer.toString(n2)).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n]).append(' ').append(n2).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitTypeInsn(int n, String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendDescriptor(0, string);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendDescriptor(0, string);
        this.stringBuilder.append('.').append(string2).append(" : ");
        this.appendDescriptor(1, string3);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    @Deprecated
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        if (this.api >= 327680) {
            super.visitMethodInsn(n, string, string2, string3);
            return;
        }
        this.doVisitMethodInsn(n, string, string2, string3, n == 185);
    }

    @Override
    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        if (this.api < 327680) {
            super.visitMethodInsn(n, string, string2, string3, bl);
            return;
        }
        this.doVisitMethodInsn(n, string, string2, string3, bl);
    }

    private void doVisitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendDescriptor(0, string);
        this.stringBuilder.append('.').append(string2).append(' ');
        this.appendDescriptor(3, string3);
        if (bl) {
            this.stringBuilder.append(" (itf)");
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("INVOKEDYNAMIC").append(' ');
        this.stringBuilder.append(string);
        this.appendDescriptor(3, string2);
        this.stringBuilder.append(" [");
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3);
        this.appendHandle(handle);
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3).append("// arguments:");
        if (objectArray.length == 0) {
            this.stringBuilder.append(" none");
        } else {
            this.stringBuilder.append('\n');
            for (int i = 0; i < objectArray.length; ++i) {
                this.stringBuilder.append(this.tab3);
                Object object = objectArray[i];
                if (object instanceof String) {
                    Printer.appendString(this.stringBuilder, (String)object);
                } else if (object instanceof Type) {
                    Type type = (Type)object;
                    if (type.getSort() == 11) {
                        this.appendDescriptor(3, type.getDescriptor());
                    } else {
                        this.visitType(type);
                    }
                } else if (object instanceof Handle) {
                    this.appendHandle((Handle)object);
                } else {
                    this.stringBuilder.append(object);
                }
                this.stringBuilder.append(", \n");
            }
            this.stringBuilder.setLength(this.stringBuilder.length() - 3);
        }
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab2).append("]\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitLabel(Label label) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.ltab);
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitLdcInsn(Object object) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LDC ");
        if (object instanceof String) {
            Printer.appendString(this.stringBuilder, (String)object);
        } else if (object instanceof Type) {
            this.stringBuilder.append(((Type)object).getDescriptor()).append(CLASS_SUFFIX);
        } else {
            this.stringBuilder.append(object);
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("IINC ").append(n).append(' ').append(n2).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TABLESWITCH\n");
        for (int i = 0; i < labelArray.length; ++i) {
            this.stringBuilder.append(this.tab3).append(n + i).append(": ");
            this.appendLabel(labelArray[i]);
            this.stringBuilder.append('\n');
        }
        this.stringBuilder.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOOKUPSWITCH\n");
        for (int i = 0; i < labelArray.length; ++i) {
            this.stringBuilder.append(this.tab3).append(nArray[i]).append(": ");
            this.appendLabel(labelArray[i]);
            this.stringBuilder.append('\n');
        }
        this.stringBuilder.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int n) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MULTIANEWARRAY ");
        this.appendDescriptor(1, string);
        this.stringBuilder.append(' ').append(n).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public Printer visitInsnAnnotation(int n, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n, typePath, string, bl);
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TRYCATCHBLOCK ");
        this.appendLabel(label);
        this.stringBuilder.append(' ');
        this.appendLabel(label2);
        this.stringBuilder.append(' ');
        this.appendLabel(label3);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, string);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public Printer visitTryCatchAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TRYCATCHBLOCK @");
        this.appendDescriptor(1, string);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference(n);
        this.stringBuilder.append(", ").append(typePath);
        this.stringBuilder.append(bl ? "\n" : INVISIBLE);
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOCALVARIABLE ").append(string).append(' ');
        this.appendDescriptor(1, string2);
        this.stringBuilder.append(' ');
        this.appendLabel(label);
        this.stringBuilder.append(' ');
        this.appendLabel(label2);
        this.stringBuilder.append(' ').append(n).append('\n');
        if (string3 != null) {
            this.stringBuilder.append(this.tab2);
            this.appendDescriptor(2, string3);
            this.stringBuilder.append(this.tab2);
            this.appendJavaDeclaration(string3);
        }
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public Printer visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOCALVARIABLE @");
        this.appendDescriptor(1, string);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference(n);
        this.stringBuilder.append(", ").append(typePath);
        for (int i = 0; i < labelArray.length; ++i) {
            this.stringBuilder.append(" [ ");
            this.appendLabel(labelArray[i]);
            this.stringBuilder.append(" - ");
            this.appendLabel(labelArray2[i]);
            this.stringBuilder.append(" - ").append(nArray[i]).append(" ]");
        }
        this.stringBuilder.append(bl ? "\n" : INVISIBLE);
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    @Override
    public void visitLineNumber(int n, Label label) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LINENUMBER ").append(n).append(' ');
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitMaxs(int n, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MAXSTACK = ").append(n).append('\n');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MAXLOCALS = ").append(n2).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitMethodEnd() {
    }

    public Textifier visitAnnotation(String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append('@');
        this.appendDescriptor(1, string);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(bl ? ")\n" : ") // invisible\n");
    }

    public Textifier visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append('@');
        this.appendDescriptor(1, string);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference(n);
        this.stringBuilder.append(", ").append(typePath);
        this.stringBuilder.append(bl ? "\n" : INVISIBLE);
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    public void visitAttribute(Attribute attribute) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        if (attribute instanceof Textifiable) {
            StringBuffer stringBuffer = new StringBuffer();
            ((Textifiable)((Object)attribute)).textify(stringBuffer, null);
            this.stringBuilder.append(stringBuffer.toString());
        } else {
            this.stringBuilder.append(" : unknown\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    private void appendAccess(int n) {
        if ((n & 1) != 0) {
            this.stringBuilder.append("public ");
        }
        if ((n & 2) != 0) {
            this.stringBuilder.append("private ");
        }
        if ((n & 4) != 0) {
            this.stringBuilder.append("protected ");
        }
        if ((n & 0x10) != 0) {
            this.stringBuilder.append("final ");
        }
        if ((n & 8) != 0) {
            this.stringBuilder.append("static ");
        }
        if ((n & 0x20) != 0) {
            this.stringBuilder.append("synchronized ");
        }
        if ((n & 0x40) != 0) {
            this.stringBuilder.append("volatile ");
        }
        if ((n & 0x80) != 0) {
            this.stringBuilder.append("transient ");
        }
        if ((n & 0x400) != 0) {
            this.stringBuilder.append("abstract ");
        }
        if ((n & 0x800) != 0) {
            this.stringBuilder.append("strictfp ");
        }
        if ((n & 0x1000) != 0) {
            this.stringBuilder.append("synthetic ");
        }
        if ((n & 0x8000) != 0) {
            this.stringBuilder.append("mandated ");
        }
        if ((n & 0x4000) != 0) {
            this.stringBuilder.append("enum ");
        }
    }

    private void appendRawAccess(int n) {
        this.stringBuilder.append("// access flags 0x").append(Integer.toHexString(n).toUpperCase()).append('\n');
    }

    protected void appendDescriptor(int n, String string) {
        if (n == 5 || n == 2 || n == 4) {
            if (string != null) {
                this.stringBuilder.append("// signature ").append(string).append('\n');
            }
        } else {
            this.stringBuilder.append(string);
        }
    }

    private void appendJavaDeclaration(String string) {
        TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(this.access);
        new SignatureReader(string).accept(traceSignatureVisitor);
        this.stringBuilder.append("// declaration: ");
        if (traceSignatureVisitor.getReturnType() != null) {
            this.stringBuilder.append(traceSignatureVisitor.getReturnType());
            this.stringBuilder.append(' ');
        }
        this.stringBuilder.append(traceSignatureVisitor.getDeclaration());
        if (traceSignatureVisitor.getExceptions() != null) {
            this.stringBuilder.append(" throws ").append(traceSignatureVisitor.getExceptions());
        }
        this.stringBuilder.append('\n');
    }

    protected void appendLabel(Label label) {
        String string;
        if (this.labelNames == null) {
            this.labelNames = new HashMap<Label, String>();
        }
        if ((string = this.labelNames.get(label)) == null) {
            string = "L" + this.labelNames.size();
            this.labelNames.put(label, string);
        }
        this.stringBuilder.append(string);
    }

    protected void appendHandle(Handle handle) {
        int n = handle.getTag();
        this.stringBuilder.append("// handle kind 0x").append(Integer.toHexString(n)).append(" : ");
        boolean bl = false;
        switch (n) {
            case 1: {
                this.stringBuilder.append("GETFIELD");
                break;
            }
            case 2: {
                this.stringBuilder.append("GETSTATIC");
                break;
            }
            case 3: {
                this.stringBuilder.append("PUTFIELD");
                break;
            }
            case 4: {
                this.stringBuilder.append("PUTSTATIC");
                break;
            }
            case 9: {
                this.stringBuilder.append("INVOKEINTERFACE");
                bl = true;
                break;
            }
            case 7: {
                this.stringBuilder.append("INVOKESPECIAL");
                bl = true;
                break;
            }
            case 6: {
                this.stringBuilder.append("INVOKESTATIC");
                bl = true;
                break;
            }
            case 5: {
                this.stringBuilder.append("INVOKEVIRTUAL");
                bl = true;
                break;
            }
            case 8: {
                this.stringBuilder.append("NEWINVOKESPECIAL");
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3);
        this.appendDescriptor(0, handle.getOwner());
        this.stringBuilder.append('.');
        this.stringBuilder.append(handle.getName());
        if (!bl) {
            this.stringBuilder.append('(');
        }
        this.appendDescriptor(9, handle.getDesc());
        if (!bl) {
            this.stringBuilder.append(')');
        }
        if (handle.isInterface()) {
            this.stringBuilder.append(" itf");
        }
    }

    private void maybeAppendComma(int n) {
        if (n > 0) {
            this.stringBuilder.append(", ");
        }
    }

    private void appendTypeReference(int n) {
        TypeReference typeReference = new TypeReference(n);
        switch (typeReference.getSort()) {
            case 0: {
                this.stringBuilder.append("CLASS_TYPE_PARAMETER ").append(typeReference.getTypeParameterIndex());
                break;
            }
            case 1: {
                this.stringBuilder.append("METHOD_TYPE_PARAMETER ").append(typeReference.getTypeParameterIndex());
                break;
            }
            case 16: {
                this.stringBuilder.append("CLASS_EXTENDS ").append(typeReference.getSuperTypeIndex());
                break;
            }
            case 17: {
                this.stringBuilder.append("CLASS_TYPE_PARAMETER_BOUND ").append(typeReference.getTypeParameterIndex()).append(", ").append(typeReference.getTypeParameterBoundIndex());
                break;
            }
            case 18: {
                this.stringBuilder.append("METHOD_TYPE_PARAMETER_BOUND ").append(typeReference.getTypeParameterIndex()).append(", ").append(typeReference.getTypeParameterBoundIndex());
                break;
            }
            case 19: {
                this.stringBuilder.append("FIELD");
                break;
            }
            case 20: {
                this.stringBuilder.append("METHOD_RETURN");
                break;
            }
            case 21: {
                this.stringBuilder.append("METHOD_RECEIVER");
                break;
            }
            case 22: {
                this.stringBuilder.append("METHOD_FORMAL_PARAMETER ").append(typeReference.getFormalParameterIndex());
                break;
            }
            case 23: {
                this.stringBuilder.append("THROWS ").append(typeReference.getExceptionIndex());
                break;
            }
            case 64: {
                this.stringBuilder.append("LOCAL_VARIABLE");
                break;
            }
            case 65: {
                this.stringBuilder.append("RESOURCE_VARIABLE");
                break;
            }
            case 66: {
                this.stringBuilder.append("EXCEPTION_PARAMETER ").append(typeReference.getTryCatchBlockIndex());
                break;
            }
            case 67: {
                this.stringBuilder.append("INSTANCEOF");
                break;
            }
            case 68: {
                this.stringBuilder.append("NEW");
                break;
            }
            case 69: {
                this.stringBuilder.append("CONSTRUCTOR_REFERENCE");
                break;
            }
            case 70: {
                this.stringBuilder.append("METHOD_REFERENCE");
                break;
            }
            case 71: {
                this.stringBuilder.append("CAST ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 72: {
                this.stringBuilder.append("CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 73: {
                this.stringBuilder.append("METHOD_INVOCATION_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 74: {
                this.stringBuilder.append("CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 75: {
                this.stringBuilder.append("METHOD_REFERENCE_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void appendFrameTypes(int n, Object[] objectArray) {
        block9: for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.stringBuilder.append(' ');
            }
            if (objectArray[i] instanceof String) {
                String string = (String)objectArray[i];
                if (string.startsWith("[")) {
                    this.appendDescriptor(1, string);
                    continue;
                }
                this.appendDescriptor(0, string);
                continue;
            }
            if (objectArray[i] instanceof Integer) {
                switch ((Integer)objectArray[i]) {
                    case 0: {
                        this.appendDescriptor(1, "T");
                        continue block9;
                    }
                    case 1: {
                        this.appendDescriptor(1, "I");
                        continue block9;
                    }
                    case 2: {
                        this.appendDescriptor(1, "F");
                        continue block9;
                    }
                    case 3: {
                        this.appendDescriptor(1, "D");
                        continue block9;
                    }
                    case 4: {
                        this.appendDescriptor(1, "J");
                        continue block9;
                    }
                    case 5: {
                        this.appendDescriptor(1, "N");
                        continue block9;
                    }
                    case 6: {
                        this.appendDescriptor(1, "U");
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            this.appendLabel((Label)objectArray[i]);
        }
    }

    private Textifier addNewTextifier(String string) {
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        if (string != null) {
            this.text.add(string);
        }
        return textifier;
    }

    protected Textifier createTextifier() {
        return new Textifier();
    }
}

