/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm.jgroups;

import java.lang.reflect.Field;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;
import org.junit.Assert;

public class JGroupsConfigurationTest
extends ConfigurableCacheSyncDistributedTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test() throws Throwable {
        int multicastPort;
        AbstractSession session = this.getAbstractSession();
        RemoteCommandManager rcm = new RemoteCommandManager((CommandProcessor)session);
        TransportManager transport = (TransportManager)Class.forName("org.eclipse.persistence.sessions.coordination.jgroups.JGroupsTransportManager").newInstance();
        rcm.setTransportManager(transport);
        transport.createLocalConnection();
        try (RemoteConnection connection = transport.getConnectionToLocalHost();){
            multicastPort = this.getMulticastPort(connection);
            Assert.assertEquals((String)"Default multicast port different than expected", (long)45588L, (long)multicastPort);
        }
        rcm = new RemoteCommandManager((CommandProcessor)session);
        transport = (TransportManager)Class.forName("org.eclipse.persistence.sessions.coordination.jgroups.JGroupsTransportManager").newInstance();
        transport.setConfig("org/eclipse/persistence/testing/config/distributedservers/rcm/jgroups/jgroups-udp-config.xml");
        rcm.setTransportManager(transport);
        transport.createLocalConnection();
        connection = transport.getConnectionToLocalHost();
        try {
            multicastPort = this.getMulticastPort(connection);
            Assert.assertEquals((String)"Configured multicast port different than expected", (long)45678L, (long)multicastPort);
        }
        catch (Exception x) {
            Assert.fail((String)("Failed to retrieve multicast port: " + x.getMessage()));
        }
        finally {
            connection.close();
        }
    }

    private int getMulticastPort(RemoteConnection connection) throws Exception {
        Field field = Class.forName("org.eclipse.persistence.internal.sessions.coordination.jgroups.JGroupsRemoteConnection").getDeclaredField("channel");
        field.setAccessible(true);
        Object channel = field.get(connection);
        Object protocolStack = Class.forName("org.jgroups.JChannel").getMethod("getProtocolStack", new Class[0]).invoke(channel, new Object[0]);
        Object bottomProtocol = Class.forName("org.jgroups.stack.ProtocolStack").getMethod("getBottomProtocol", new Class[0]).invoke(protocolStack, new Object[0]);
        return (Integer)Class.forName("org.jgroups.protocols.UDP").getMethod("getMulticastPort", new Class[0]).invoke(bottomProtocol, new Object[0]);
    }
}

