/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning.model;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.returning.model.Class1;
import org.eclipse.persistence.testing.tests.returning.model.ReturnObjectControl;

public class ReturningInsertTestCase
extends TestCase {
    Class1 originalObject;
    Class1 workingObject;
    boolean useUOW;
    ReturnObjectControl control;

    public ReturningInsertTestCase(Class1 originalObject, boolean useUOW, ReturnObjectControl control) {
        this.originalObject = originalObject;
        this.useUOW = useUOW;
        this.setName(this.getName() + " " + originalObject);
        if (useUOW) {
            this.setName(this.getName() + " useUOW");
        }
        this.control = control;
    }

    protected void setup() {
        this.workingObject = (Class1)this.originalObject.clone();
    }

    protected void test() {
        if (this.useUOW) {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            uow.registerObject((Object)this.workingObject);
            uow.commit();
        } else {
            this.getAbstractSession().writeObject((Object)this.workingObject);
        }
    }

    protected void verify() {
        Class1 controlObject = (Class1)this.control.getObjectForInsert(this.getSession(), this.originalObject);
        if (!this.workingObject.isValid()) {
            throw new TestErrorException("Object is invalid");
        }
        if (!controlObject.compareWithoutId(this.workingObject)) {
            throw new TestErrorException("Object is wrong");
        }
    }
}

