/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import java.sql.Time;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class Client
extends Thread {
    protected Server server;
    protected Session clientSession;
    protected Session session;
    protected Object originalObject;
    protected UnitOfWork unitOfWork;
    protected Object objectToBeWritten;
    protected Expression expression;

    public Client(Server server, String employeeLastName, Session session) {
        super(employeeLastName);
        this.server = server;
        this.session = session;
        this.clientSession = this.getName().equals("Smith") ? server.serverSession.acquireClientSession() : (this.getName().equals("Way") ? server.serverSession.acquireClientSession("default") : server.serverSession.acquireClientSession((Login)session.getLogin().clone()));
        this.expression = new ExpressionBuilder().get("lastName").equal((Object)employeeLastName);
    }

    protected void changeObject() {
        if (this.getName().equals("Smith")) {
            this.changeObjectForFirstClient();
        } else if (this.getName().equals("Way")) {
            this.changeObjectForFirstClient();
        } else if (this.getName().equals("Chanley")) {
            this.changeObjectForFirstClient();
        } else {
            throw new TestErrorException("Problem in setting up a test case");
        }
    }

    public void changeObjectForFirstClient() {
        Employee employee = (Employee)this.objectToBeWritten;
        employee.setNormalHours(new Time[2]);
        employee.setStartTime(Helper.timeFromHourMinuteSecond((int)1, (int)1, (int)1));
        employee.setEndTime(Helper.timeFromHourMinuteSecond((int)1, (int)1, (int)1));
        employee.setPeriod(new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1901, (int)1, (int)1), Helper.dateFromYearMonthDate((int)1902, (int)2, (int)2)));
        employee.getAddress().setCity("foobarrrr");
    }

    public void changeObjectForSecondClient() {
        Employee employee = (Employee)this.objectToBeWritten;
        employee.addPhoneNumber(new PhoneNumber("homey", "613", "2263374"));
        employee.addPhoneNumber(new PhoneNumber("officey", "416", "8224599"));
        employee.setProjects(new Vector());
        employee.addProject((Project)this.unitOfWork.readObject(SmallProject.class));
        employee.addProject((Project)this.unitOfWork.readObject(LargeProject.class));
    }

    public void changeObjectForThirdClient() {
        Employee employee = (Employee)this.objectToBeWritten;
        employee.addResponsibility("make coffee, lots of coffe");
        employee.addResponsibility("buy donuts, pink douts");
        employee.getAddress().setCity("Putkiss land");
        employee.setManager((Employee)this.unitOfWork.readObject(Employee.class));
    }

    public void release() {
        this.clientSession.release();
    }

    @Override
    public void run() {
        try {
            this.originalObject = this.clientSession.readObject(Employee.class, this.expression);
            this.unitOfWork = this.clientSession.acquireUnitOfWork();
            this.unitOfWork.readAllObjects(Employee.class);
            this.objectToBeWritten = this.unitOfWork.registerObject(this.originalObject);
            this.changeObject();
            if (!((AbstractSession)this.session).compareObjectsDontMatch(this.originalObject, this.objectToBeWritten)) {
                throw new TestErrorException("The original object was changed through changing the clone.");
            }
            this.unitOfWork.commit();
        }
        catch (Exception exception) {
            this.server.errorOccured = true;
            exception.printStackTrace(System.out);
        }
    }
}

