/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadAllComplexvsConformTest
extends PerformanceComparisonTestCase {
    protected UnitOfWork uow;

    public ReadAllComplexvsConformTest() {
        this.setDescription("This test compares the performance of read all in unit of work vs conform read all.");
        this.addReadAllConformTest();
    }

    public void setup() {
        this.uow = this.getSession().acquireUnitOfWork();
        Vector employees = this.uow.readAllObjects(Employee.class);
        for (Employee employee : employees) {
            employee.getAddress();
            employee.getPhoneNumbers().size();
        }
        this.uow.deleteObject(employees.get(5));
        this.uow.registerNewObject((Object)new Employee());
        Employee changedEmployee = (Employee)employees.get(10);
        changedEmployee.setSalary(0);
    }

    public void test() throws Exception {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder employee = new ExpressionBuilder();
        query.setSelectionCriteria(employee.get("firstName").equal((Object)"Brendan").and(employee.get("salary").equal(100000)).and(employee.get("address").get("city").like("%pean%")).and(employee.anyOf("phoneNumbers").get("type").equal((Object)"Home")));
        List results = (List)this.uow.executeQuery((DatabaseQuery)query);
    }

    public void addReadAllConformTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                ExpressionBuilder employee = new ExpressionBuilder();
                query.setSelectionCriteria(employee.get("firstName").equal((Object)"Brendan").and(employee.get("salary").equal(100000)).and(employee.get("address").get("city").like("%pean%")).and(employee.anyOf("phoneNumbers").get("type").equal((Object)"Home")));
                query.conformResultsInUnitOfWork();
                List results = (List)ReadAllComplexvsConformTest.this.uow.executeQuery((DatabaseQuery)query);
            }
        };
        test.setName("ReadAllConformTest");
        test.setAllowableDecrease(-25.0);
        this.addTest((TestCase)test);
    }
}

