/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.advanced;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.JoinedAttributeTestHelper;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Project;

public class JoinedAttributeAdvancedJunitTest
extends JUnitTestCase {
    protected static Class[] classes = new Class[]{Employee.class, Address.class, PhoneNumber.class, Project.class};
    protected static Vector[] objectVectors = new Vector[]{null, null, null, null};
    protected static EmployeePopulator populator = new EmployeePopulator();
    protected DatabaseSession dbSession;

    public JoinedAttributeAdvancedJunitTest() {
    }

    public JoinedAttributeAdvancedJunitTest(String name) {
        super(name);
    }

    protected DatabaseSession getDbSession() {
        if (this.dbSession == null) {
            this.dbSession = JoinedAttributeAdvancedJunitTest.getServerSession((String)"fieldaccess");
        }
        return this.dbSession;
    }

    protected UnitOfWork acquireUnitOfWork() {
        return this.getDbSession().acquireUnitOfWork();
    }

    protected void clear() {
        UnitOfWork uow = this.acquireUnitOfWork();
        if (!JUnitTestCase.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            UpdateAllQuery updateEmployees = new UpdateAllQuery(Employee.class);
            updateEmployees.addUpdate("manager", null);
            updateEmployees.addUpdate("address", null);
            uow.executeQuery((DatabaseQuery)updateEmployees);
            uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Employee.class));
        } else {
            for (Employee emp : uow.readAllObjects(Employee.class)) {
                emp.setManager(null);
                emp.setAddress(null);
                uow.deleteObject((Object)emp);
            }
        }
        UpdateAllQuery updateProjects = new UpdateAllQuery(Project.class);
        updateProjects.addUpdate("teamLeader", null);
        uow.executeQuery((DatabaseQuery)updateProjects);
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(PhoneNumber.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Address.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Project.class));
        uow.commit();
        this.dbSessionClearCache();
    }

    protected void populate() {
        populator.buildExamples();
        populator.persistExample((Session)this.getDbSession());
        this.dbSessionClearCache();
        for (int i = 0; i < classes.length; ++i) {
            JoinedAttributeAdvancedJunitTest.objectVectors[i] = this.getDbSession().readAllObjects(classes[i]);
        }
    }

    public static Test suiteSpring() {
        TestSuite suite = new TestSuite();
        suite.setName("JoinedAttributeAdvancedJunitTest (fieldaccess)");
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testSetup"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectJoinTeamMembers"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectJoinTeamLeaderJoinAddressWhereTeamLeaderNotNull"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectJoinTeamMembersJoinAddress"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectOuterJoinTeamMembersJoinAddress"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectJoinTeamMembersOuterJoinAddress"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeJoinProjects"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeJoinProjectsJoinTeamLeaderJoinAddressWhereManagerIsNull"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectOuterJoinTeamLeaderAddressTeamMembersAddressPhonesWhereProjectName"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhones"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testEmployeeJoinManagerAddressOuterJoinManagerAddress"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testTwoUnrelatedResultWithOneToManyJoins"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testMultipleUnrelatedResultWithOneToManyJoins"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testTwoUnrelatedResultWithOneToOneJoins"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testTwoUnrelatedResultWithOneToOneJoinsWithExtraItem"));
        return suite;
    }

    public static Test suite() {
        TestSuite suite = (TestSuite)JoinedAttributeAdvancedJunitTest.suiteSpring();
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProjectOuterJoinTeamMembersOuterJoinAddress"));
        suite.addTest((Test)new JoinedAttributeAdvancedJunitTest("testProblemReporterProjectJoinTeamMembersJoinAddress"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"fieldaccess"));
        this.populate();
        JoinedAttributeAdvancedJunitTest.clearCache((String)"fieldaccess");
    }

    public void tearDown() {
        this.dbSessionClearCache();
        this.dbSession = null;
        super.tearDown();
    }

    public void testProjectJoinTeamMembers() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().anyOf("teamMembers"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectJoinTeamLeaderJoinAddressWhereTeamLeaderNotNull() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        Expression teamLeader = query.getExpressionBuilder().get("teamLeader");
        query.setSelectionCriteria(teamLeader.notNull());
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(teamLeader);
        Expression teamLeaderAddress = teamLeader.get("address");
        query.addJoinedAttribute(teamLeaderAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectJoinTeamMembersJoinAddress() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOf("teamMembers");
        query.addJoinedAttribute(teamMembers);
        Expression teamMembersAddress = teamMembers.get("address");
        query.addJoinedAttribute(teamMembersAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectOuterJoinTeamMembersJoinAddress() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOfAllowingNone("teamMembers");
        query.addJoinedAttribute(teamMembers);
        Expression teamMembersAddress = teamMembers.get("address");
        query.addJoinedAttribute(teamMembersAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectOuterJoinTeamMembersOuterJoinAddress() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOfAllowingNone("teamMembers");
        query.addJoinedAttribute(teamMembers);
        Expression teamMembersAddress = teamMembers.getAllowingNull("address");
        query.addJoinedAttribute(teamMembersAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectJoinTeamMembersOuterJoinAddress() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOf("teamMembers");
        query.addJoinedAttribute(teamMembers);
        Expression teamMembersAddress = teamMembers.getAllowingNull("address");
        query.addJoinedAttribute(teamMembersAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProblemReporterProjectJoinTeamMembersJoinAddress() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("name").equal((Object)"Problem Reporter"));
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOf("teamMembers");
        query.addJoinedAttribute(teamMembers);
        Expression teamMembersAddress = teamMembers.get("address");
        query.addJoinedAttribute(teamMembersAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testEmployeeJoinProjects() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().anyOf("projects"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testEmployeeJoinProjectsJoinTeamLeaderJoinAddressWhereManagerIsNull() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("manager").isNull());
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression projects = query.getExpressionBuilder().anyOf("projects");
        query.addJoinedAttribute(projects);
        Expression teamLeader = projects.get("teamLeader");
        query.addJoinedAttribute(teamLeader);
        Expression teamLeaderAddress = teamLeader.get("address");
        query.addJoinedAttribute(teamLeaderAddress);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testProjectOuterJoinTeamLeaderAddressTeamMembersAddressPhonesWhereProjectName() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Project.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("name").equal((Object)"Problem Reporting System").or(query.getExpressionBuilder().get("name").equal((Object)"Bleep Blob")));
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamLeader = query.getExpressionBuilder().getAllowingNull("teamLeader");
        query.addJoinedAttribute(teamLeader);
        Expression teamLeaderAddress = teamLeader.getAllowingNull("address");
        query.addJoinedAttribute(teamLeaderAddress);
        Expression teamMembers = query.getExpressionBuilder().anyOfAllowingNone("teamMembers");
        query.addJoinedAttribute(teamMembers);
        Expression teamMembersAddress = teamMembers.getAllowingNull("address");
        query.addJoinedAttribute(teamMembersAddress);
        Expression teamMembersPhones = teamMembers.anyOfAllowingNone("phoneNumbers");
        query.addJoinedAttribute(teamMembersPhones);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testEmployeeOuterJoinAddressPhoneProjectsTeamLeaderAddressTeamMembersPhones() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().getAllowingNull("address"));
        query.addJoinedAttribute(query.getExpressionBuilder().anyOfAllowingNone("phoneNumbers"));
        Expression projects = query.getExpressionBuilder().anyOfAllowingNone("projects");
        query.addJoinedAttribute(projects);
        Expression teamLeader = projects.getAllowingNull("teamLeader");
        query.addJoinedAttribute(teamLeader);
        Expression teamLeaderAddress = teamLeader.getAllowingNull("address");
        query.addJoinedAttribute(teamLeaderAddress);
        Expression teamMembers = projects.anyOfAllowingNone("teamMembers");
        query.addJoinedAttribute(teamMembers);
        Expression teamMembersPhones = teamMembers.anyOfAllowingNone("phoneNumbers");
        query.addJoinedAttribute(teamMembersPhones);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    public void testEmployeeJoinManagerAddressOuterJoinManagerAddress() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("lastName").equal((Object)"Way").or(query.getExpressionBuilder().get("lastName").equal((Object)"Jones")));
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression manager = query.getExpressionBuilder().get("manager");
        query.addJoinedAttribute(manager);
        query.addJoinedAttribute(manager.get("address"));
        Expression managersManager = manager.getAllowingNull("manager");
        query.addJoinedAttribute(managersManager);
        query.addJoinedAttribute(managersManager.get("address"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoUnrelatedResultWithOneToManyJoins() {
        if (JoinedAttributeAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            JoinedAttributeAdvancedJunitTest.getServerSession((String)"fieldaccess").logMessage("Test testTwoUnrelatedResultWithOneToManyJoins skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("lastName").equal((Object)"Way").or(raq.getExpressionBuilder().get("lastName").equal((Object)"Jones")));
        Employee emp = (Employee)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        emp.getPhoneNumbers();
        Iterator iterator = emp.getPhoneNumbers().iterator();
        while (iterator.hasNext()) {
            ((PhoneNumber)iterator.next()).getOwner();
        }
        raq = new ReadAllQuery(Address.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("city").like("%ttawa%"));
        Address addr = (Address)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        addr.getEmployees();
        Iterator iterator2 = addr.getEmployees().iterator();
        while (iterator2.hasNext()) {
            ((Employee)iterator2.next()).getAddress();
        }
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReportQuery query = new ReportQuery();
        query.setShouldReturnWithoutReportQueryResult(true);
        query.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder(Address.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("id").equal((Object)emp.getId()).and(eb.get("id").equal((Object)addr.getId())));
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(query.getExpressionBuilder().anyOf("phoneNumbers"));
        query.addItem("employee", (Expression)query.getExpressionBuilder(), list);
        list = new ArrayList();
        list.add(eb.anyOf("employees"));
        query.addItem("address", (Expression)eb, list);
        Vector result = (Vector)this.getDbSession().executeQuery((DatabaseQuery)query);
        DeleteAllQuery deleteAll = new DeleteAllQuery(PhoneNumber.class);
        deleteAll.setSelectionCriteria(deleteAll.getExpressionBuilder().get("owner").get("id").equal((Object)emp.getId()));
        UnitOfWork uow = this.getDbSession().acquireUnitOfWork();
        uow.executeQuery((DatabaseQuery)deleteAll);
        UpdateAllQuery updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("address").get("id").equal((Object)addr.getId()));
        uow.executeQuery((DatabaseQuery)updall);
        uow.commit();
        try {
            Employee emp2 = (Employee)((Object[])result.firstElement())[0];
            Address addr2 = (Address)((Object[])result.firstElement())[1];
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("PhoneNumbers were not joined correctly, emp.getPhoneNumbers().size = " + emp.getPhoneNumbers().size() + " emp2.getPhoneNumbers().size = " + emp2.getPhoneNumbers().size()), (emp.getPhoneNumbers().size() == emp2.getPhoneNumbers().size() ? 1 : 0) != 0);
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("Employees were not joined correctly, addr.employees.size = " + addr.getEmployees().size() + "addr2.employees.size = " + addr2.getEmployees().size()), (addr.getEmployees().size() == addr2.getEmployees().size() ? 1 : 0) != 0);
        }
        finally {
            this.testSetup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleUnrelatedResultWithOneToManyJoins() {
        if (JoinedAttributeAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            JoinedAttributeAdvancedJunitTest.getServerSession((String)"fieldaccess").logMessage("Test testMultipleUnrelatedResultWithOneToManyJoins skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().notEmpty("phoneNumbers"));
        Employee emp = (Employee)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        emp.getPhoneNumbers();
        Iterator iterator = emp.getPhoneNumbers().iterator();
        while (iterator.hasNext()) {
            ((PhoneNumber)iterator.next()).getOwner();
        }
        raq = new ReadAllQuery(Address.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("city").like("%ttawa%"));
        Address addr = (Address)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        addr.getEmployees();
        for (Employee addrEmp : addr.getEmployees()) {
            addrEmp.getAddress();
            addrEmp.getPhoneNumbers().size();
        }
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReportQuery query = new ReportQuery();
        query.setShouldReturnWithoutReportQueryResult(true);
        query.setReferenceClass(Address.class);
        ExpressionBuilder eb = new ExpressionBuilder(Employee.class);
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(eb.anyOf("phoneNumbers"));
        query.addItem("employee", (Expression)eb, list);
        list = new ArrayList();
        list.add(query.getExpressionBuilder().anyOf("employees"));
        query.addItem("address", (Expression)query.getExpressionBuilder(), list);
        query.setSelectionCriteria(query.getExpressionBuilder().get("id").equal((Object)addr.getId()));
        Vector result = (Vector)this.getDbSession().executeQuery((DatabaseQuery)query);
        DeleteAllQuery deleteAll = new DeleteAllQuery(PhoneNumber.class);
        deleteAll.setSelectionCriteria(deleteAll.getExpressionBuilder().get("owner").get("id").equal((Object)emp.getId()));
        UnitOfWork uow = this.getDbSession().acquireUnitOfWork();
        uow.executeQuery((DatabaseQuery)deleteAll);
        UpdateAllQuery updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("address").get("id").equal((Object)addr.getId()));
        uow.executeQuery((DatabaseQuery)updall);
        uow.commit();
        try {
            Employee emp2 = null;
            Address addr2 = null;
            for (Object[] items : result) {
                emp2 = (Employee)items[0];
                if (!emp2.getId().equals(emp.getId())) continue;
                addr2 = (Address)items[1];
                break;
            }
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("PhoneNumbers were not joined correctly, emp.getPhoneNumbers().size = " + emp.getPhoneNumbers().size() + " emp2.getPhoneNumbers().size = " + emp2.getPhoneNumbers().size()), (emp.getPhoneNumbers().size() == emp2.getPhoneNumbers().size() ? 1 : 0) != 0);
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("Employees were not joined correctly, addr.employees.size = " + addr.getEmployees().size() + "addr2.employees.size = " + addr2.getEmployees().size()), (addr.getEmployees().size() == addr2.getEmployees().size() ? 1 : 0) != 0);
        }
        finally {
            this.testSetup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoUnrelatedResultWithOneToOneJoins() {
        if (JoinedAttributeAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            JoinedAttributeAdvancedJunitTest.getServerSession((String)"fieldaccess").logMessage("Test testTwoUnrelatedResultWithOneToOneJoins skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("lastName").equal((Object)"Way").or(raq.getExpressionBuilder().get("lastName").equal((Object)"Jones")));
        Employee emp = (Employee)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        emp.getAddress();
        raq = new ReadAllQuery(Address.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("city").like("%ttawa%"));
        Address addr = (Address)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        addr.getEmployees();
        Iterator iterator = addr.getEmployees().iterator();
        while (iterator.hasNext()) {
            ((Employee)iterator.next()).getAddress();
        }
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReportQuery query = new ReportQuery();
        query.setShouldReturnWithoutReportQueryResult(true);
        query.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder(Address.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("id").equal((Object)emp.getId()).and(eb.get("id").equal((Object)addr.getId())));
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(query.getExpressionBuilder().get("address"));
        query.addItem("employee", (Expression)query.getExpressionBuilder(), list);
        list = new ArrayList();
        list.add(eb.anyOf("employees"));
        query.addItem("address", (Expression)eb, list);
        Vector result = (Vector)this.getDbSession().executeQuery((DatabaseQuery)query);
        UpdateAllQuery updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("id").equal((Object)emp.getId()));
        UnitOfWork uow = this.getDbSession().acquireUnitOfWork();
        uow.executeQuery((DatabaseQuery)updall);
        updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("address").get("id").equal((Object)addr.getId()));
        uow.executeQuery((DatabaseQuery)updall);
        uow.commit();
        try {
            Employee emp2 = (Employee)((Object[])result.firstElement())[0];
            Address addr2 = (Address)((Object[])result.firstElement())[1];
            JoinedAttributeAdvancedJunitTest.assertTrue((String)"Address were not joined correctly, emp.getAddress() = null", (emp2.getAddress() != null ? 1 : 0) != 0);
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("Employees were not joined correctly, addr.employees.size = " + addr.getEmployees().size() + "addr2.employees.size = " + addr2.getEmployees().size()), (addr.getEmployees().size() == addr2.getEmployees().size() ? 1 : 0) != 0);
        }
        finally {
            this.testSetup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoUnrelatedResultWithOneToOneJoinsWithExtraItem() {
        if (JoinedAttributeAdvancedJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            JoinedAttributeAdvancedJunitTest.getServerSession((String)"fieldaccess").logMessage("Test testTwoUnrelatedResultWithOneToOneJoinsWithExtraItem skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("lastName").equal((Object)"Way").or(raq.getExpressionBuilder().get("lastName").equal((Object)"Jones")));
        Employee emp = (Employee)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        emp.getAddress();
        raq = new ReadAllQuery(Address.class);
        raq.setSelectionCriteria(raq.getExpressionBuilder().get("city").like("%ttawa%"));
        Address addr = (Address)((Vector)this.getDbSession().executeQuery((DatabaseQuery)raq)).firstElement();
        addr.getEmployees();
        Iterator iterator = addr.getEmployees().iterator();
        while (iterator.hasNext()) {
            ((Employee)iterator.next()).getAddress();
        }
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReportQuery query = new ReportQuery();
        query.setShouldReturnWithoutReportQueryResult(true);
        query.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder(Address.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("id").equal((Object)emp.getId()).and(eb.get("id").equal((Object)addr.getId())));
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(query.getExpressionBuilder().get("address"));
        query.addItem("employee", (Expression)query.getExpressionBuilder(), list);
        query.addItem("employee_name", query.getExpressionBuilder().get("firstName"));
        list = new ArrayList();
        list.add(eb.anyOf("employees"));
        query.addItem("address", (Expression)eb, list);
        Vector result = (Vector)this.getDbSession().executeQuery((DatabaseQuery)query);
        UpdateAllQuery updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("id").equal((Object)emp.getId()));
        UnitOfWork uow = this.getDbSession().acquireUnitOfWork();
        uow.executeQuery((DatabaseQuery)updall);
        updall = new UpdateAllQuery(Employee.class);
        updall.addUpdate("address", null);
        updall.setSelectionCriteria(updall.getExpressionBuilder().get("address").get("id").equal((Object)addr.getId()));
        uow.executeQuery((DatabaseQuery)updall);
        uow.commit();
        Employee emp2 = (Employee)((Object[])result.firstElement())[0];
        Address addr2 = (Address)((Object[])result.firstElement())[2];
        try {
            JoinedAttributeAdvancedJunitTest.assertTrue((String)"Address were not joined correctly, emp.getAddress() = null", (emp2.getAddress() != null ? 1 : 0) != 0);
            JoinedAttributeAdvancedJunitTest.assertTrue((String)("Employees were not joined correctly, addr.employees.size = " + addr.getEmployees().size() + "addr2.employees.size = " + addr2.getEmployees().size()), (addr.getEmployees().size() == addr2.getEmployees().size() ? 1 : 0) != 0);
            if (!emp2.getFirstName().equals(((Object[])result.firstElement())[1])) {
                JoinedAttributeAdvancedJunitTest.fail((String)"Failed to return employee name as an separate item");
            }
        }
        finally {
            this.testSetup();
        }
    }

    protected String executeQueriesAndCompareResults(ObjectLevelReadQuery controlQuery, ObjectLevelReadQuery queryWithJoins) {
        return JoinedAttributeTestHelper.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)queryWithJoins, (AbstractSession)((AbstractSession)this.getDbSession()));
    }

    protected boolean compare() {
        for (int i = 0; i < classes.length; ++i) {
            if (this.compare(i)) continue;
            return false;
        }
        return true;
    }

    protected boolean compare(int i) {
        if (objectVectors[i] == null) {
            return false;
        }
        Vector currentVector = this.getDbSession().readAllObjects(classes[i]);
        if (currentVector.size() != objectVectors[i].size()) {
            return false;
        }
        ClassDescriptor descriptor = this.getDbSession().getDescriptor(classes[i]);
        for (int j = 0; j < currentVector.size(); ++j) {
            Object obj1 = objectVectors[i].elementAt(j);
            Object obj2 = currentVector.elementAt(j);
            if (descriptor.getObjectBuilder().compareObjects(obj1, obj2, (AbstractSession)this.getDbSession())) continue;
            return false;
        }
        return true;
    }

    public void dbSessionClearCache() {
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

