/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ViolateObjectSpaceTest
extends TransactionalTestCase {
    protected Object objectToBeWritten;
    SessionEventListener listener;

    public ViolateObjectSpaceTest() {
        this.setDescription("Test using no validation.");
    }

    public void reset() {
        super.reset();
        if (this.listener != null) {
            this.getAbstractSession().getParent().getEventManager().removeListener(this.listener);
            this.listener = null;
        }
    }

    protected void setup() {
        if (this.getSession().isClientSession()) {
            this.listener = this.checkTransactionIsolation();
        }
        super.setup();
    }

    public void test() {
        this.testPartial();
        this.testFull();
        this.testNone();
    }

    public void testFull() {
        Employee employeeFromCache = (Employee)this.getSession().readObject(Employee.class);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.performFullValidation();
        Employee newEmployee = new Employee();
        newEmployee.setId(employeeFromCache.getId());
        ValidationException exception = null;
        try {
            uow.registerObject((Object)newEmployee);
        }
        catch (ValidationException caught) {
            exception = caught;
        }
        if (exception == null || exception.getErrorCode() != 7056) {
            throw new TestErrorException("incorrect exception thrown.");
        }
    }

    public void testNone() {
        Employee employeeFromCache = (Employee)this.getSession().readObject(Employee.class);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee newObject = (Employee)uow.newInstance(Employee.class);
        this.objectToBeWritten = newObject;
        uow.dontPerformValidation();
        newObject.setManager(employeeFromCache);
        uow.commit();
    }

    public void testPartial() {
        Employee employeeFromCache = (Employee)this.getSession().readObject(Employee.class);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee newObject = (Employee)uow.newInstance(Employee.class);
        uow.performPartialValidation();
        newObject.setManager(employeeFromCache);
        QueryException exception = null;
        try {
            uow.commit();
        }
        catch (QueryException caught) {
            exception = caught;
        }
        if (exception == null || exception.getErrorCode() != 6004) {
            throw new TestErrorException("incorrect exception thrown.");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Object objectFromDatabase = this.getSession().readObject(this.objectToBeWritten);
        if (!this.compareObjects(this.objectToBeWritten, objectFromDatabase)) {
            throw new TestErrorException("The object inserted into the database, '" + objectFromDatabase + "' does not match the original, '" + this.objectToBeWritten + ".");
        }
    }
}

