/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.queries.MultiNameQueriesTestCase;

public class NamedQueriesUOWTest
extends MultiNameQueriesTestCase {
    protected Server serverSession;
    protected UnitOfWork uow;
    protected Exception caughtException;

    public NamedQueriesUOWTest() {
        this.setDescription("Verifies if a Named Queries with different argument sets can be cached on UnitOfWork");
    }

    public void reset() {
        this.uow.removeQuery("namedQuerySameName");
        this.uow.release();
        this.serverSession.logout();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        EmployeeProject proj = new EmployeeProject();
        proj.setDatasourceLogin(this.getSession().getDatasourceLogin().clone());
        this.serverSession = proj.createServerSession(1, 1);
        this.serverSession.useReadConnectionPool(1, 1);
        this.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.serverSession.login();
        this.uow = this.serverSession.acquireUnitOfWork();
        this.serverSession.getIdentityMapAccessor().initializeIdentityMaps();
        this.addNamedQueryFirstName();
        this.addNamedQueryFirstAndLastName();
    }

    public void useNamedQueryFirstName() {
        Vector empsByFirstName = (Vector)this.uow.executeQuery("namedQuerySameName", (Object)new String("Jill"));
    }

    public void useNamedQueryFirstAndLastName() {
        Vector empsByFirstAndLastName = (Vector)this.uow.executeQuery("namedQuerySameName", (Object)new String("Jill"), (Object)new String("May"));
    }

    public void addNamedQueryFirstName() {
        this.uow.addQuery("namedQuerySameName", (DatabaseQuery)this.getNamedQueryFirstName());
    }

    public void addNamedQueryFirstAndLastName() {
        this.uow.addQuery("namedQuerySameName", (DatabaseQuery)this.getNamedQueryFirstAndLastName());
    }

    public void test() {
        try {
            this.useNamedQueryFirstName();
            this.useNamedQueryFirstAndLastName();
        }
        catch (ClassCastException e) {
            this.caughtException = e;
        }
    }

    public void verify() {
        if (this.caughtException != null) {
            throw new TestErrorException("Multiple queries with the same named cached on the UnitOfWork.\nEach with different argument sets.\nThis exception thrown while testing test case.\n----- NamedQueriesUOWTest() -----\n");
        }
    }
}

