/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.oracle;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class BasicReadTest
extends TestCase {
    static String HINT_STRING = "/*+ ALL_ROWS */";
    static String INNER_HINT = "/*+ RULE */";
    DatabaseQuery query;
    boolean subselect = false;

    public BasicReadTest(DatabaseQuery theQuery) {
        this.query = theQuery;
    }

    public void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("This test is intended for Oracle databases only");
        }
    }

    public void reset() {
    }

    public void test() {
        this.query.setHintString(HINT_STRING);
        this.getSession().executeQuery(this.query);
    }

    public void verify() throws Exception {
        String SQLString = this.query.getSQLString();
        if (SQLString.indexOf(HINT_STRING) == -1) {
            throw new TestErrorException("Hint String not in SQL String");
        }
        if (this.subselect && SQLString.indexOf(INNER_HINT) == -1) {
            throw new TestErrorException("Inner Hint String not in SQL String");
        }
    }

    public void setSubselect(boolean sub) {
        this.subselect = sub;
    }
}

