/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking.cascaded;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.Award;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.Bar;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.Bartender;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.License;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.Qualification;

public class BarProject
extends Project {
    public BarProject(DatabaseSession session) {
        this.setName("Bar");
        this.applyLogin(session);
        this.addDescriptor(this.buildBarDescriptor());
        this.addDescriptor(this.buildBartenderDescriptor());
        this.addDescriptor(this.buildLicenseDescriptor());
        this.addDescriptor(this.buildQualificationDescriptor());
        this.addDescriptor(this.buildAwardDescriptor());
    }

    public void applyLogin(DatabaseSession session) {
        DatabaseLogin login = (DatabaseLogin)session.getLogin().clone();
        login.setShouldBindAllParameters(false);
        login.setShouldCacheAllStatements(false);
        login.setUsesByteArrayBinding(true);
        login.setUsesStringBinding(false);
        if (login.shouldUseByteArrayBinding()) {
            login.setUsesStreamsForBinding(false);
        }
        login.setShouldForceFieldNamesToUpperCase(false);
        login.setShouldOptimizeDataConversion(true);
        login.setShouldTrimStrings(true);
        login.setUsesBatchWriting(false);
        if (login.shouldUseBatchWriting()) {
            login.setUsesJDBCBatchWriting(true);
        }
        login.setUsesExternalConnectionPooling(false);
        login.setUsesExternalTransactionController(false);
        this.setLogin(login);
    }

    public ClassDescriptor buildAwardDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Award.class);
        descriptor.addTableName("CASCADE_AWARD");
        descriptor.addPrimaryKeyFieldName("CASCADE_AWARD.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("CASCADE_AWARD.ID");
        descriptor.setSequenceNumberName("CASCADE_AWARD_SEQ");
        descriptor.setAlias("Award");
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.getQueryManager().setQueryTimeout(0);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("CASCADE_AWARD.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("CASCADE_AWARD.DESCRIPTION");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        OneToOneMapping qualificationMapping = new OneToOneMapping();
        qualificationMapping.setAttributeName("qualification");
        qualificationMapping.setReferenceClass(Qualification.class);
        qualificationMapping.useBasicIndirection();
        qualificationMapping.addForeignKeyFieldName("CASCADE_AWARD.QUALIFICATION_ID", "CASCADE_QUALIFICATION.ID");
        descriptor.addMapping((DatabaseMapping)qualificationMapping);
        return descriptor;
    }

    public ClassDescriptor buildBarDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Bar.class);
        descriptor.addTableName("CASCADE_BAR");
        descriptor.addPrimaryKeyFieldName("CASCADE_BAR.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("CASCADE_BAR.ID");
        descriptor.setSequenceNumberName("CASCADE_BAR_SEQ");
        descriptor.setAlias("Bar");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("CASCADE_BAR.VERSION");
        lockingPolicy.setIsCascaded(true);
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.getQueryManager().setQueryTimeout(0);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("CASCADE_BAR.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("CASCADE_BAR.NAME");
        nameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        DirectToFieldMapping versionMapping = new DirectToFieldMapping();
        versionMapping.setAttributeName("version");
        versionMapping.setFieldName("CASCADE_BAR.VERSION");
        versionMapping.setIsReadOnly(true);
        descriptor.addMapping((DatabaseMapping)versionMapping);
        OneToOneMapping licenseMapping = new OneToOneMapping();
        licenseMapping.setAttributeName("license");
        licenseMapping.setReferenceClass(License.class);
        licenseMapping.useBasicIndirection();
        licenseMapping.privateOwnedRelationship();
        licenseMapping.addForeignKeyFieldName("CASCADE_BAR.LICENSE_ID", "CASCADE_LICENSE.ID");
        descriptor.addMapping((DatabaseMapping)licenseMapping);
        OneToManyMapping bartendersMapping = new OneToManyMapping();
        bartendersMapping.setAttributeName("bartenders");
        bartendersMapping.setReferenceClass(Bartender.class);
        bartendersMapping.useBasicIndirection();
        bartendersMapping.privateOwnedRelationship();
        bartendersMapping.addTargetForeignKeyFieldName("CASCADE_BARTENDER.BAR_ID", "CASCADE_BAR.ID");
        descriptor.addMapping((DatabaseMapping)bartendersMapping);
        return descriptor;
    }

    public ClassDescriptor buildBartenderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Bartender.class);
        descriptor.addTableName("CASCADE_BARTENDER");
        descriptor.addPrimaryKeyFieldName("CASCADE_BARTENDER.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("CASCADE_BARTENDER.ID");
        descriptor.setSequenceNumberName("CASCADE_BARTENDER_SEQ");
        descriptor.setAlias("Bartender");
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.getQueryManager().setQueryTimeout(0);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("CASCADE_BARTENDER.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("CASCADE_BARTENDER.F_NAME");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("CASCADE_BARTENDER.L_NAME");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        OneToOneMapping barMapping = new OneToOneMapping();
        barMapping.setAttributeName("bar");
        barMapping.setReferenceClass(Bar.class);
        barMapping.useBasicIndirection();
        barMapping.addForeignKeyFieldName("CASCADE_BARTENDER.BAR_ID", "CASCADE_BAR.ID");
        descriptor.addMapping((DatabaseMapping)barMapping);
        OneToOneMapping qualificationMapping = new OneToOneMapping();
        qualificationMapping.setAttributeName("qualification");
        qualificationMapping.setReferenceClass(Qualification.class);
        qualificationMapping.useBasicIndirection();
        qualificationMapping.privateOwnedRelationship();
        qualificationMapping.addForeignKeyFieldName("CASCADE_BARTENDER.QUALIFICATION_ID", "CASCADE_QUALIFICATION.ID");
        descriptor.addMapping((DatabaseMapping)qualificationMapping);
        return descriptor;
    }

    public ClassDescriptor buildLicenseDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(License.class);
        descriptor.addTableName("CASCADE_LICENSE");
        descriptor.addPrimaryKeyFieldName("CASCADE_LICENSE.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("CASCADE_LICENSE.ID");
        descriptor.setSequenceNumberName("CASCADE_LICENSE_SEQ");
        descriptor.setAlias("License");
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.getQueryManager().setQueryTimeout(0);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("CASCADE_LICENSE.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping classMapping = new DirectToFieldMapping();
        classMapping.setAttributeName("licenseClass");
        classMapping.setFieldName("CASCADE_LICENSE.LICENSE_CLASS");
        descriptor.addMapping((DatabaseMapping)classMapping);
        return descriptor;
    }

    public ClassDescriptor buildQualificationDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Qualification.class);
        descriptor.addTableName("CASCADE_QUALIFICATION");
        descriptor.addPrimaryKeyFieldName("CASCADE_QUALIFICATION.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("CASCADE_QUALIFICATION.ID");
        descriptor.setSequenceNumberName("CASCADE_QUALIFICATION_SEQ");
        descriptor.setAlias("Qualification");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("CASCADE_QUALIFICATION.VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.getQueryManager().setQueryTimeout(0);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("CASCADE_QUALIFICATION.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping yearsOfExperienceMapping = new DirectToFieldMapping();
        yearsOfExperienceMapping.setAttributeName("yearsOfExperience");
        yearsOfExperienceMapping.setFieldName("CASCADE_QUALIFICATION.YEARS");
        yearsOfExperienceMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)yearsOfExperienceMapping);
        DirectToFieldMapping versionMapping = new DirectToFieldMapping();
        versionMapping.setAttributeName("version");
        versionMapping.setFieldName("CASCADE_QUALIFICATION.VERSION");
        versionMapping.setIsReadOnly(true);
        descriptor.addMapping((DatabaseMapping)versionMapping);
        OneToManyMapping awardsMapping = new OneToManyMapping();
        awardsMapping.setAttributeName("awards");
        awardsMapping.setReferenceClass(Award.class);
        awardsMapping.useBasicIndirection();
        awardsMapping.privateOwnedRelationship();
        awardsMapping.addTargetForeignKeyFieldName("CASCADE_AWARD.QUALIFICATION_ID", "CASCADE_QUALIFICATION.ID");
        descriptor.addMapping((DatabaseMapping)awardsMapping);
        return descriptor;
    }
}

