/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;

public class MetadataField
extends MetadataAnnotatedElement {
    protected MetadataClass declaringClass;

    public MetadataField(MetadataClass metadataClass) {
        super(metadataClass.getMetadataFactory());
        this.declaringClass = metadataClass;
    }

    public MetadataClass getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isEclipseLinkWeavedField() {
        return this.getName().startsWith("_persistence_");
    }

    public boolean isValidPersistenceField(boolean mustBeExplicit, ClassAccessor classAccessor) {
        if (this.isValidPersistenceElement(mustBeExplicit, "FIELD", classAccessor)) {
            return this.isValidPersistenceField(classAccessor, this.hasDeclaredAnnotations(classAccessor));
        }
        return false;
    }

    public boolean isValidPersistenceField(ClassAccessor classAccessor, boolean userDecorated) {
        if (!this.isValidPersistenceElement(this.getModifiers())) {
            if (userDecorated) {
                this.getLogger().logConfigMessage("metadata_warning_ignore_mapping_metadata", this, (Object)classAccessor.getDescriptorJavaClass());
            }
            return false;
        }
        return true;
    }

    public void setDeclaringClass(MetadataClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    public boolean shouldBeIgnored() {
        return this.getName() != null && this.getName().startsWith("_persistence_");
    }
}

