/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.mapping.Computer;
import org.eclipse.persistence.testing.models.mapping.Monitor;

public class BidirectionalUOWInsertTest
extends AutoVerifyTestCase {
    UnitOfWork unitOfWork;

    public BidirectionalUOWInsertTest() {
        this.setDescription("Test bidirectional insert in a unit of work.");
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        this.beginTransaction();
    }

    protected void test() {
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        Computer computer = new Computer();
        Monitor monitor = Monitor.example1();
        computer.setDescription("IBM PS2");
        computer.notMacintosh();
        computer.setMonitor(monitor);
        computer.getMonitor().setComputer(computer);
        computer.setSerialNumber("1124345-1876212-2");
        this.unitOfWork.registerObject((Object)computer);
        this.unitOfWork.commit();
    }

    protected void verify() {
        int size = ((UnitOfWorkImpl)this.unitOfWork).getCloneMapping().size();
        if (size != 2) {
            throw new TestErrorException("cloneMapping hashtable contains " + size + " elements, should contain 2.");
        }
    }
}

