/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.math.BigDecimal;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.aggregate.Agent;
import org.eclipse.persistence.testing.models.aggregate.Builder;
import org.eclipse.persistence.testing.models.legacy.Computer;
import org.eclipse.persistence.testing.models.legacy.Employee;
import org.eclipse.persistence.testing.models.legacy.Order;
import org.eclipse.persistence.testing.models.legacy.Shipment;
import org.eclipse.persistence.testing.tests.queries.inmemory.CacheHitOnPKWithInheritanceTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.CacheHitTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.CacheHitWithInheritance;
import org.eclipse.persistence.testing.tests.queries.inmemory.CacheHitWithNonPKCriteriaTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.CacheMissTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.DescriptorUnitOfWorkConformObjectTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.InMemoryCacheHitTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.InMemoryCacheMissTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.InMemoryReadAllCacheHitTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryAcrossAggregateCollectionMapping;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryAcrossDirectCollectionMapping;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryAcrossManyToManyAcrossOneToManyMapping;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryAcrossManyToManyMapping;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryAcrossNestedOneToManyMapping;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryAcrossOneToManyAcrossOneToOneMapping;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryAcrossOneToManyMapping;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryAcrossOneToManyMapping2;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryAcrossOneToOneMapping;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryForFunctionsAcrossOneToManyAcrossOneToOneMapping;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryForFunctionsAcrossOneToManyMapping;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryLike;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryReturnConformedOnIndirection;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryReturnNotConformedOnIndirection;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryThrowExceptionOnIndirection;
import org.eclipse.persistence.testing.tests.queries.inmemory.MemoryQueryTriggerIndirection;
import org.eclipse.persistence.testing.tests.queries.inmemory.NamedQueryConformNullPointerException;
import org.eclipse.persistence.testing.tests.queries.inmemory.OneToOneCacheHitTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.QueryCacheHitDisabledAndDescriptorDisabledTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.QueryCacheHitDisabledAndDescriptorEnabledTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.QueryCacheHitEnabledAndDescriptorDisabledTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.QueryCacheHitEnabledAndDescriptorEnabledTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.QueryCacheHitUndefinedAndDescriptorDisabledTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.QueryCacheHitUndefinedAndDescriptorEnabledTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.UnitOfWorkConformAcrossIndirectionTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.UnitOfWorkConformDuplicateTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.UnitOfWorkConformLikeSpecialCharacterTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.UnitOfWorkConformLikeTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.UnitOfWorkConformNewObjectTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.UnitOfWorkConformObjectTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.UnitOfWorkConformReadObjectWithCriteriaTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.UnitOfWorkConformTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.UnitOfWorkConformWithOrderTest;
import org.eclipse.persistence.testing.tests.queries.inmemory.UnitOfWorkConformWithoutRegisteringTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class CacheHitAndInMemoryTestSuite
extends TestSuite {
    public CacheHitAndInMemoryTestSuite() {
        this.setDescription("This suite tests cache hits and in-memory querying.");
    }

    public void addCacheTests() {
        PopulationManager manager = PopulationManager.getDefaultManager();
        this.addTest((Test)new CacheMissTest());
        this.addTest((Test)new OneToOneCacheHitTest());
        this.addTest((Test)new CacheHitTest(manager.getObject(org.eclipse.persistence.testing.models.employee.domain.Employee.class, "0001")));
        this.addTest((Test)new CacheHitTest(manager.getObject(Shipment.class, "example1")));
        Order order = (Order)((Shipment)Employee.example1().shipments.elementAt((int)0)).orders.elementAt(0);
        order.shipment.shipmentNumber = new Integer(order.shipment.shipmentNumber.intValue());
        this.addTest((Test)new CacheHitTest(order));
        Employee employee = (Employee)manager.getObject(Employee.class, "example1");
        this.addTest((Test)new CacheHitTest(employee));
        Computer computer = employee.computer;
        this.addTest((Test)new CacheHitTest(computer));
        this.addTest((Test)new CacheHitWithInheritance());
        this.addTest((Test)new CacheHitWithNonPKCriteriaTest());
        this.addTest((Test)new CacheHitOnPKWithInheritanceTest());
        this.addTest((Test)new QueryCacheHitDisabledAndDescriptorDisabledTest());
        this.addTest((Test)new QueryCacheHitDisabledAndDescriptorEnabledTest());
        this.addTest((Test)new QueryCacheHitEnabledAndDescriptorDisabledTest());
        this.addTest((Test)new QueryCacheHitEnabledAndDescriptorEnabledTest());
        this.addTest((Test)new QueryCacheHitUndefinedAndDescriptorDisabledTest());
        this.addTest((Test)new QueryCacheHitUndefinedAndDescriptorEnabledTest());
    }

    public void addInMemoryHitTests() {
        PopulationManager manager = PopulationManager.getDefaultManager();
        org.eclipse.persistence.testing.models.employee.domain.Employee example = (org.eclipse.persistence.testing.models.employee.domain.Employee)manager.getObject(org.eclipse.persistence.testing.models.employee.domain.Employee.class, "0001");
        ExpressionBuilder builder = new ExpressionBuilder();
        ReadObjectQuery query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()));
        InMemoryCacheHitTest test = new InMemoryCacheHitTest(query);
        test.setName("InMemoryCacheHitTest - by key exact");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()));
        test = new InMemoryCacheHitTest(query);
        query.checkCacheByExactPrimaryKey();
        test.setName("InMemoryCacheHitTest - by key exact required");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery();
        query.setSelectionObject((Object)example);
        test = new InMemoryCacheHitTest(query);
        query.checkCacheByExactPrimaryKey();
        test.setName("InMemoryCacheHitTest - by selection object exact required");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()).and(builder.get("firstName").equal((Object)example.getFirstName())));
        test = new InMemoryCacheHitTest(query);
        test.setName("InMemoryCacheHitTest - by key non exact and");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()).or(builder.get("firstName").equal((Object)"Jonney5")));
        test = new InMemoryCacheHitTest(query);
        test.setName("InMemoryCacheHitTest - by key non exact or");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()).and(builder.get("firstName").toUpperCase().equal((Object)example.getFirstName().toUpperCase())));
        test = new InMemoryCacheHitTest(query);
        test.setName("InMemoryCacheHitTest - by key non exact upper");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)example.getFirstName()));
        test = new InMemoryCacheHitTest(query);
        query.checkCacheThenDatabase();
        test.setName("InMemoryCacheHitTest - by name");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("lastName").equal((Object)example.getLastName()).and(builder.get("firstName").toUpperCase().equal((Object)example.getFirstName().toUpperCase())));
        test = new InMemoryCacheHitTest(query);
        query.checkCacheThenDatabase();
        test.setName("InMemoryCacheHitTest - by f/l name upper");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("lastName").concat((Object)builder.get("firstName")).equal((Object)(example.getLastName() + example.getFirstName())).and(ExpressionMath.multiply((Expression)builder.get("salary"), (int)2).greaterThan(10)));
        test = new InMemoryCacheHitTest(query);
        query.checkCacheThenDatabase();
        test.setName("InMemoryCacheHitTest - by functions");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        Vector<String> names = new Vector<String>();
        names.addElement("jonesy");
        names.addElement(example.getLastName());
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("lastName").in(names));
        test = new InMemoryCacheHitTest(query);
        query.checkCacheThenDatabase();
        test.setName("InMemoryCacheHitTest - in");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        Vector<Number> ids = new Vector<Number>();
        ids.addElement(new Long(123456789L));
        ids.addElement(example.getId());
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").in(ids));
        test = new InMemoryCacheHitTest(query);
        query.checkCacheThenDatabase();
        test.setName("InMemoryCacheHitTest - in on primary key");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("salary").between(0, 1000000));
        test = new InMemoryCacheHitTest(query);
        query.checkCacheThenDatabase();
        test.setName("InMemoryCacheHitTest - between");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)example.getFirstName()).and(builder.get("lastName").equal((Object)example.getLastName())));
        test = new InMemoryCacheHitTest(query);
        test.setName("InMemoryCacheHitTest - name index");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("salary").between(0, -1000000));
        test = new InMemoryCacheHitTest(query);
        query.checkCacheOnly();
        test.setName("InMemoryCacheHitTest - miss on only");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        ReadAllQuery queryAll = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("salary").between(0, 100000));
        InMemoryReadAllCacheHitTest testAll = new InMemoryReadAllCacheHitTest(queryAll, 5);
        queryAll.checkCacheOnly();
        testAll.setName("InMemoryCacheHitTest - read all - between");
        this.addTest((Test)testAll);
        builder = new ExpressionBuilder();
        queryAll = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").greaterThan((Object)"ABBA"));
        testAll = new InMemoryReadAllCacheHitTest(queryAll, 5);
        queryAll.checkCacheOnly();
        testAll.setName("InMemoryCacheHitTest - read all - less than");
        this.addTest((Test)testAll);
        queryAll = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class);
        testAll = new InMemoryReadAllCacheHitTest(queryAll, 10);
        queryAll.checkCacheOnly();
        testAll.setName("InMemoryCacheHitTest - with no where clause");
        this.addTest((Test)testAll);
    }

    public void addInMemoryMissTests() {
        PopulationManager manager = PopulationManager.getDefaultManager();
        org.eclipse.persistence.testing.models.employee.domain.Employee example = (org.eclipse.persistence.testing.models.employee.domain.Employee)manager.getObject(org.eclipse.persistence.testing.models.employee.domain.Employee.class, "0001");
        ExpressionBuilder builder = new ExpressionBuilder();
        ReadObjectQuery query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()).and(builder.get("firstName").equal((Object)example.getFirstName())));
        query.checkCacheByExactPrimaryKey();
        InMemoryCacheMissTest test = new InMemoryCacheMissTest(query);
        test.setName("InMemoryCacheMissTest - by key exact");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()).and(builder.get("firstName").notEqual((Object)example.getFirstName())));
        test = new InMemoryCacheMissTest(query);
        query.checkCacheByPrimaryKey();
        test.setName("InMemoryCacheMissTest - by non exact");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()).and(builder.get("firstName").like(example.getLastName())));
        test = new InMemoryCacheMissTest(query);
        query.checkCacheByPrimaryKey();
        test.setName("InMemoryCacheMissTest - by non exact - exception");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()).and(builder.get("firstName").like(example.getLastName())));
        test = new InMemoryCacheMissTest(query);
        query.checkCacheThenDatabase();
        test.setName("InMemoryCacheMissTest - by non exact - exception");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)example.getLastName()).and(builder.get("lastName").equal((Object)example.getFirstName())));
        test = new InMemoryCacheMissTest(query);
        test.setName("InMemoryCacheMissTest - name index");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)example.getFirstName()).and(builder.get("lastName").equal((Object)example.getLastName())).and(builder.get("salary").notEqual(example.getSalary())));
        test = new InMemoryCacheMissTest(query);
        test.setName("InMemoryCacheMissTest - name index");
        this.addTest((Test)test);
    }

    public void addTests() {
        this.addCacheTests();
        this.addInMemoryHitTests();
        this.addInMemoryMissTests();
        this.addUOWConformTests();
        this.addUOWConformObjectTests();
        this.addUOWConformWithoutRegisteringTests();
    }

    public void addUOWConformObjectTests() {
        PopulationManager manager = PopulationManager.getDefaultManager();
        org.eclipse.persistence.testing.models.employee.domain.Employee example = (org.eclipse.persistence.testing.models.employee.domain.Employee)manager.getObject(org.eclipse.persistence.testing.models.employee.domain.Employee.class, "0001");
        ExpressionBuilder builder = new ExpressionBuilder();
        ReadObjectQuery query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").greaterThan((Object)example.getId().subtract(new BigDecimal(1))).and(builder.get("id").lessThanEqual((Object)example.getId())));
        query.conformResultsInUnitOfWork();
        UnitOfWorkConformObjectTest test = new UnitOfWorkConformObjectTest(query, true);
        test.setName("UnitOfWorkConformTest - hit");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)"Sarah").or(builder.get("lastName").equal((Object)"")));
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformObjectTest(query, true);
        test.setName("UnitOfWorkConformTest - dead-hit");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)"Bobbyiop").and(builder.get("lastName").equal(null)));
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformObjectTest(query, false);
        test.setName("UnitOfWorkConformTest - miss");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)"Bob").and(builder.get("lastName").equal(null)));
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformObjectTest(query, true);
        test.setName("UnitOfWorkConformTest - new");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("lastName").equal((Object)"Bobo"));
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformObjectTest(query, true);
        test.setName("UnitOfWorkConformTest - changed");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)"Sarah"));
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformObjectTest(query, false);
        test.setName("UnitOfWorkConformTest - deleted");
        this.addTest((Test)test);
        this.addTest((Test)new UnitOfWorkConformLikeTest());
        this.addTest((Test)new UnitOfWorkConformLikeSpecialCharacterTest());
        this.addTest((Test)new NamedQueryConformNullPointerException());
        this.addTest((Test)new MemoryQueryAcrossOneToOneMapping());
        this.addTest((Test)new MemoryQueryAcrossNestedOneToManyMapping());
        this.addTest((Test)new MemoryQueryAcrossOneToManyMapping());
        this.addTest((Test)new MemoryQueryForFunctionsAcrossOneToManyMapping());
        this.addTest((Test)new MemoryQueryForFunctionsAcrossOneToManyAcrossOneToOneMapping());
        this.addTest((Test)new MemoryQueryAcrossOneToManyMapping2());
        this.addTest((Test)new MemoryQueryAcrossOneToManyAcrossOneToOneMapping());
        this.addTest((Test)new MemoryQueryAcrossManyToManyMapping());
        this.addTest((Test)new MemoryQueryAcrossManyToManyAcrossOneToManyMapping());
        this.addTest((Test)new MemoryQueryAcrossDirectCollectionMapping());
        this.addTest((Test)new MemoryQueryAcrossAggregateCollectionMapping(Agent.class));
        this.addTest((Test)new MemoryQueryAcrossAggregateCollectionMapping(Builder.class));
        this.addTest((Test)new NamedQueryConformNullPointerException());
        this.addTest((Test)new MemoryQueryTriggerIndirection());
        this.addTest((Test)new MemoryQueryReturnConformedOnIndirection());
        this.addTest((Test)new MemoryQueryReturnNotConformedOnIndirection());
        this.addTest((Test)new MemoryQueryThrowExceptionOnIndirection());
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("lastName").equal(null));
        DescriptorUnitOfWorkConformObjectTest test2 = new DescriptorUnitOfWorkConformObjectTest(query, true);
        test2.setName("DescriptorUOWConformTest - hit");
        this.addTest((Test)test2);
        builder = new ExpressionBuilder();
        query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)"Sarah"));
        test2 = new DescriptorUnitOfWorkConformObjectTest(query, false);
        test2.setName("DescriptorUOWConformTest - miss");
        this.addTest((Test)test2);
        this.addTest((Test)new MemoryQueryLike());
        this.addTest((Test)new UnitOfWorkConformReadObjectWithCriteriaTest());
    }

    public void addUOWConformTests() {
        PopulationManager manager = PopulationManager.getDefaultManager();
        org.eclipse.persistence.testing.models.employee.domain.Employee example = (org.eclipse.persistence.testing.models.employee.domain.Employee)manager.getObject(org.eclipse.persistence.testing.models.employee.domain.Employee.class, "0001");
        ExpressionBuilder builder = new ExpressionBuilder();
        ReadAllQuery query = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()).and(builder.get("firstName").equal((Object)example.getFirstName())));
        query.conformResultsInUnitOfWork();
        UnitOfWorkConformTest test = new UnitOfWorkConformTest(query, 1);
        test.setName("UnitOfWorkConformTest - by key");
        this.addTest((Test)test);
        query = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class);
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformTest(query, 13);
        test.setName("UnitOfWorkConformTest - no selection criteria");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)"Bob"));
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformTest(query, 2);
        test.setName("UnitOfWorkConformTest - by name, new object");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)"newBobby"));
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformTest(query, 1);
        test.setName("UnitOfWorkConformTest - by name, new object");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("firstName").equal((Object)"Sarah"));
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformTest(query, 0);
        test.setName("UnitOfWorkConformTest - by name, deleted object");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()).and(builder.get("lastName").equal((Object)example.getLastName())));
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformTest(query, 0);
        test.setName("UnitOfWorkConformTest - by name, changed object, remove");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class, builder.get("id").equal((Object)example.getId()).and(builder.get("lastName").equal((Object)"Bobo")));
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformTest(query, 1);
        test.setName("UnitOfWorkConformTest - by name, changed object, add");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        query = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Employee.class);
        query.conformResultsInUnitOfWork();
        test = new UnitOfWorkConformDuplicateTest(query, 13);
        test.setName("UnitOfWorkConformDuplicateTest - all");
        this.addTest((Test)test);
        this.addTest((Test)new UnitOfWorkConformAcrossIndirectionTest());
        this.addTest((Test)new UnitOfWorkConformWithOrderTest());
        this.addTest((Test)new UnitOfWorkConformNewObjectTest());
    }

    public void addUOWConformWithoutRegisteringTests() {
        this.addTest((Test)new UnitOfWorkConformWithoutRegisteringTest());
    }
}

