/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;
import org.eclipse.persistence.testing.tests.validation.PersonWithValueHolder;

public class ParameterAndMappingWithTransparentIndirectionMismatchTest
extends ExceptionTest {
    IntegrityChecker orgIntegrityChecker;

    public ParameterAndMappingWithTransparentIndirectionMismatchTest() {
        this.setDescription("This tests Parameter And Mapping With Transparent Indirection Mismatch (TL-ERROR 140)");
    }

    protected void setup() {
        this.expectedException = DescriptorException.parameterAndMappingWithTransparentIndirectionMismatch((DatabaseMapping)new OneToManyMapping(), null, null);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        ForeignReferenceMapping phoneNumbersMapping = (ForeignReferenceMapping)this.descriptor().getMappingForAttributeName("phoneNumbers");
        try {
            phoneNumbersMapping.getIndirectionPolicy().validateSetMethodParameterType(PhoneNumber.class, this.getSession().getIntegrityChecker());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(PersonWithValueHolder.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("p_id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        idMapping.setGetMethodName("getId");
        idMapping.setSetMethodName("setId");
        ((MethodAttributeAccessor)idMapping.getAttributeAccessor()).initializeAttributes(PersonWithValueHolder.class);
        descriptor.addMapping((DatabaseMapping)idMapping);
        OneToManyMapping phoneNumbersMapping = new OneToManyMapping();
        phoneNumbersMapping.setAttributeName("phoneNumbers");
        phoneNumbersMapping.setReferenceClass(PhoneNumber.class);
        phoneNumbersMapping.dontUseIndirection();
        phoneNumbersMapping.useTransparentCollection();
        phoneNumbersMapping.setSetMethodName("setPhones");
        phoneNumbersMapping.setGetMethodName("getPhones");
        phoneNumbersMapping.addTargetForeignKeyFieldName("PHONE.EMP_ID", "EMPLOYEE.EMP_ID");
        ((MethodAttributeAccessor)phoneNumbersMapping.getAttributeAccessor()).initializeAttributes(PersonWithValueHolder.class);
        descriptor.addMapping((DatabaseMapping)phoneNumbersMapping);
        return descriptor;
    }
}

