/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.beans;

import java.io.OutputStream;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;

public class TextAreaOutputStream
extends OutputStream {
    protected JTextArea text;
    protected boolean shouldAutoScroll;

    public TextAreaOutputStream(JTextArea text) {
        this(text, false);
    }

    public TextAreaOutputStream(JTextArea text, boolean shouldAutoScroll) {
        this.text = text;
        this.shouldAutoScroll = shouldAutoScroll;
    }

    public JTextArea getText() {
        return this.text;
    }

    public void scrollToEnd() {
        if (this.shouldAutoScroll() && this.getText().getParent() instanceof JViewport) {
            int max = ((JScrollPane)((JViewport)this.getText().getParent()).getParent()).getVerticalScrollBar().getMaximum();
            ((JScrollPane)((JViewport)this.getText().getParent()).getParent()).getVerticalScrollBar().setValue(max);
        }
    }

    public void setShouldAutoScroll(boolean shouldAutoScroll) {
        this.shouldAutoScroll = shouldAutoScroll;
    }

    public void setText(JTextArea text) {
        this.text = text;
    }

    public boolean shouldAutoScroll() {
        return this.shouldAutoScroll;
    }

    @Override
    public void write(byte[] bytes) {
        this.getText().append(new String(bytes));
        this.scrollToEnd();
    }

    @Override
    public void write(byte[] bytes, int offset, int length) {
        byte[] buffer = new byte[length];
        System.arraycopy(bytes, offset, buffer, 0, length);
        this.getText().append(new String(buffer));
        this.scrollToEnd();
    }

    @Override
    public void write(int b) {
        byte[] bytes = new byte[]{(byte)b};
        this.getText().append(new String(bytes));
        this.scrollToEnd();
    }
}

