/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers;

import java.rmi.registry.Registry;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.broker.SessionBroker;

public abstract class DistributedServer {
    public DatabaseSession session;
    public String serverName;

    public DistributedServer(Session testSssion) {
        if (testSssion.isSessionBroker()) {
            this.session = new SessionBroker();
            for (String name : ((SessionBroker)testSssion).getSessionsByName().keySet()) {
                DatabaseSession newMemberSession = ((SessionBroker)testSssion).getSessionForName(name).getProject().createDatabaseSession();
                ((SessionBroker)this.session).registerSession(name, (Session)newMemberSession);
            }
        } else {
            this.session = testSssion.getProject().createDatabaseSession();
        }
        this.session.setSessionLog(testSssion.getSessionLog());
        this.session.login();
        if (testSssion.isSessionBroker()) {
            for (String name : ((SessionBroker)testSssion).getSessionsByName().keySet()) {
                AbstractSession oldMemberSession = ((SessionBroker)testSssion).getSessionForName(name);
                AbstractSession newMemberSession = ((SessionBroker)this.session).getSessionForName(name);
                ((DatabaseAccessor)newMemberSession.getAccessor()).closeConnection();
                newMemberSession.setAccessor(oldMemberSession.getAccessor());
            }
        } else {
            ((DatabaseAccessor)((AbstractSession)this.session).getAccessor()).closeConnection();
            ((AbstractSession)this.session).setAccessor(((AbstractSession)testSssion).getAccessor());
        }
    }

    public DatabaseSession getDistributedSession() {
        return this.session;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isObjectValid(Object object) {
        return this.session.getIdentityMapAccessor().isValid(object);
    }

    public abstract void run();

    public abstract void stopServer();

    public void setServerName(String newServerName) {
        this.serverName = newServerName;
    }

    public void unbind(Registry registry) {
        try {
            registry.unbind(this.getServerName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

