/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class PredefinedQueryInheritanceTest
extends AutoVerifyTestCase {
    public static final String QUERY_NAME = "getProjectSubClassQuery13478";
    public static final String TEST_NAME = "PredefinedQueryInheritanceTest";
    LargeProject subclassTestObjectRead;
    ReadObjectQuery query;
    ClassDescriptor descriptor;
    Exception storedException;
    String objectName;
    DatabaseQuery sessionQuery;
    DatabaseQuery descriptorQuery;

    public PredefinedQueryInheritanceTest() {
        this.setDescription("Tests that named queries work on subclasses from where they're defined.");
    }

    public void reset() {
        this.descriptor = this.getSession() instanceof RemoteSession ? RemoteModel.getServerSession().getDescriptor(Project.class) : this.getSession().getDescriptor(Project.class);
        this.descriptor.getQueryManager().removeQuery(QUERY_NAME);
        if (this.descriptorQuery != null) {
            this.descriptor.getQueryManager().addQuery(this.descriptorQuery);
        }
        if (this.sessionQuery != null) {
            this.getSession().addQuery(this.sessionQuery.getName(), this.sessionQuery);
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        this.subclassTestObjectRead = null;
        this.storedException = null;
        this.sessionQuery = null;
        this.descriptorQuery = null;
        this.objectName = "";
        this.descriptor = this.getSession() instanceof RemoteSession ? RemoteModel.getServerSession().getDescriptor(Project.class) : this.getSession().getDescriptor(Project.class);
        try {
            this.subclassTestObjectRead = (LargeProject)this.getSession().readObject(LargeProject.class);
        }
        catch (Exception e) {
            this.setStoredException((Exception)new TestErrorException("No LargeProject test objects available for:PredefinedQueryInheritanceTest"));
        }
        this.objectName = this.subclassTestObjectRead.getName();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression nameExpression = builder.get("name").equal((Object)this.objectName);
        this.query = new ReadObjectQuery();
        this.query.setReferenceClass(Project.class);
        this.query.setSelectionCriteria(nameExpression);
        this.descriptorQuery = this.descriptor.getQueryManager().getQuery(QUERY_NAME);
        this.sessionQuery = this.getSession().getQuery(QUERY_NAME);
        this.getSession().removeQuery(QUERY_NAME);
        this.descriptor.getQueryManager().removeQuery(QUERY_NAME);
        this.descriptor.getQueryManager().addQuery(QUERY_NAME, (DatabaseQuery)this.query);
    }

    protected void test() {
        this.subclassTestObjectRead = null;
        try {
            this.subclassTestObjectRead = (LargeProject)this.getSession().executeQuery(QUERY_NAME, LargeProject.class);
        }
        catch (Exception e) {
            this.setStoredException((Exception)new TestErrorException("Error reading with inherited named query in test:PredefinedQueryInheritanceTest", (Throwable)e));
            return;
        }
        if (this.subclassTestObjectRead == null) {
            this.setStoredException((Exception)new TestErrorException("Inherited named query returned null object in test:PredefinedQueryInheritanceTest"));
            return;
        }
    }

    protected void verify() throws Exception {
        if (this.storedException != null) {
            throw this.storedException;
        }
    }

    protected void setStoredException(Exception e) {
        if (this.storedException == null) {
            this.storedException = e;
        }
    }
}

