/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inheritance;

import jakarta.persistence.EntityManager;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.inheritance.MacBook;
import org.eclipse.persistence.testing.models.jpa.inheritance.MacBookPro;
import org.eclipse.persistence.testing.models.jpa.inheritance.MudTireInfo;
import org.eclipse.persistence.testing.models.jpa.inheritance.RockTireInfo;
import org.eclipse.persistence.testing.models.jpa.inheritance.SubclassEntityJoined;
import org.eclipse.persistence.testing.models.jpa.inheritance.SubclassEntitySingleTable;
import org.eclipse.persistence.testing.models.jpa.inheritance.SubclassEntityTablePerClass;
import org.eclipse.persistence.testing.models.jpa.inheritance.SuperclassEntityJoined;
import org.eclipse.persistence.testing.models.jpa.inheritance.SuperclassEntitySingleTable;
import org.eclipse.persistence.testing.models.jpa.inheritance.SuperclassEntityTablePerClass;
import org.eclipse.persistence.testing.models.jpa.inheritance.TireRating;
import org.eclipse.persistence.testing.models.jpa.inheritance.TireRatingComment;
import org.eclipse.persistence.testing.models.jpa.inheritance.listeners.TireInfoListener;

public class MixedInheritanceJUnitTestCase
extends JUnitTestCase {
    private static int mudTireId;
    private static int rockTireId;

    public MixedInheritanceJUnitTestCase() {
    }

    public MixedInheritanceJUnitTestCase(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("MixedInheritanceJUnitTestCase");
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testSetup"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testCreateNewMudTire"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testCreateNewRockTire"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testReadNewMudTire"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testReadNewRockTire"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testAppleComputers"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testCreateNewJoinedTableSuperclass"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testCreateNewSingleTableSuperclass"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testCreateNewTablePerClassSuperclass"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testCreateNewJoinedTableSubclass"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testCreateNewSingleTableSubclass"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testCreateNewTablePerClassSubclass"));
        return suite;
    }

    public void testSetup() {
        new InheritanceTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppleComputers() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        MacBook macBook1 = new MacBook();
        macBook1.setRam(Integer.valueOf(2));
        MacBook macBook2 = new MacBook();
        macBook2.setRam(Integer.valueOf(4));
        MacBookPro macBookPro1 = new MacBookPro();
        macBookPro1.setRam(Integer.valueOf(4));
        macBookPro1.setColor("Black");
        MacBookPro macBookPro2 = new MacBookPro();
        macBookPro2.setRam(Integer.valueOf(6));
        macBookPro2.setColor("Red");
        MacBookPro macBookPro3 = new MacBookPro();
        macBookPro3.setRam(Integer.valueOf(8));
        macBookPro3.setColor("Green");
        MacBookPro macBookPro4 = new MacBookPro();
        macBookPro4.setRam(Integer.valueOf(8));
        macBookPro4.setColor("Blue");
        try {
            em.persist((Object)macBook1);
            em.persist((Object)macBook2);
            em.persist((Object)macBookPro1);
            em.persist((Object)macBookPro2);
            em.persist((Object)macBookPro3);
            em.persist((Object)macBookPro4);
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting macbooks: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        this.clearCache();
        em = this.createEntityManager();
        List macBooks = em.createNamedQuery("findAllMacBooks").getResultList();
        MixedInheritanceJUnitTestCase.assertTrue((String)("The wrong number of mac books were returned: " + macBooks.size() + ", expected: 6"), (macBooks.size() == 6 ? 1 : 0) != 0);
        List macBookPros = em.createNamedQuery("findAllMacBookPros").getResultList();
        MixedInheritanceJUnitTestCase.assertTrue((String)("The wrong number of mac book pros were returned: " + macBookPros.size() + ", expected: 4"), (macBookPros.size() == 4 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNewMudTire() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        MudTireInfo mudTire = new MudTireInfo();
        mudTire.setName("Goodyear Mud Tracks");
        mudTire.setCode("MT-674-A4");
        mudTire.setPressure(new Integer(100));
        mudTire.setTreadDepth(3);
        TireRating tireRating = new TireRating();
        tireRating.setRating("Excellent");
        tireRating.setComment(new TireRatingComment("Tire outperformed all others in adverse conditions"));
        mudTire.setTireRating(tireRating);
        try {
            int prePersistCountBefore = TireInfoListener.PRE_PERSIST_COUNT;
            em.persist((Object)mudTire);
            mudTireId = mudTire.getId();
            this.commitTransaction(em);
            int prePersistCountAfter = TireInfoListener.PRE_PERSIST_COUNT;
            int perPersistCountTotal = prePersistCountAfter - prePersistCountBefore;
            MixedInheritanceJUnitTestCase.assertTrue((String)("The pre persist method was called more than once (" + perPersistCountTotal + ")"), (perPersistCountTotal == 1 ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting mud tire: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNewRockTire() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        RockTireInfo rockTire = new RockTireInfo();
        rockTire.setName("Goodyear Mud Tracks");
        rockTire.setCode("AE-678");
        rockTire.setPressure(new Integer(100));
        rockTire.setGrip(RockTireInfo.Grip.SUPER);
        try {
            em.persist((Object)rockTire);
            rockTireId = rockTire.getId();
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting rock tire: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testReadNewMudTire() {
        MixedInheritanceJUnitTestCase.assertNotNull((String)"The new mud tire info could not be read back.", (Object)this.createEntityManager().find(MudTireInfo.class, (Object)mudTireId));
    }

    public void testReadNewRockTire() {
        MixedInheritanceJUnitTestCase.assertNotNull((String)"The new rock tire info could not be read back.", (Object)this.createEntityManager().find(RockTireInfo.class, (Object)rockTireId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNewJoinedTableSuperclass() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        SuperclassEntityJoined newObject = new SuperclassEntityJoined();
        newObject.setSuperclassAttribute("superclass-entity-joined");
        long persistedId = 0L;
        try {
            em.persist((Object)newObject);
            persistedId = newObject.getId();
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting new object: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            SuperclassEntityJoined readObject = (SuperclassEntityJoined)em.find(SuperclassEntityJoined.class, (Object)persistedId);
            MixedInheritanceJUnitTestCase.assertNotNull((String)("Object read back with pk " + persistedId + " must not be null"), (Object)readObject);
            MixedInheritanceJUnitTestCase.assertEquals((String)"id", (long)newObject.getId(), (long)readObject.getId());
            MixedInheritanceJUnitTestCase.assertEquals((String)"superclassAttribute", (String)newObject.getSuperclassAttribute(), (String)readObject.getSuperclassAttribute());
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNewSingleTableSuperclass() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        SuperclassEntitySingleTable newObject = new SuperclassEntitySingleTable();
        newObject.setSuperclassAttribute("superclass-entity-singletable");
        long persistedId = 0L;
        try {
            em.persist((Object)newObject);
            persistedId = newObject.getId();
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting new object: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            SuperclassEntitySingleTable readObject = (SuperclassEntitySingleTable)em.find(SuperclassEntitySingleTable.class, (Object)persistedId);
            MixedInheritanceJUnitTestCase.assertNotNull((String)("Object read back with pk " + persistedId + " must not be null"), (Object)readObject);
            MixedInheritanceJUnitTestCase.assertEquals((String)"id", (long)newObject.getId(), (long)readObject.getId());
            MixedInheritanceJUnitTestCase.assertEquals((String)"superclassAttribute", (String)newObject.getSuperclassAttribute(), (String)readObject.getSuperclassAttribute());
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNewTablePerClassSuperclass() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        SuperclassEntityTablePerClass newObject = new SuperclassEntityTablePerClass();
        newObject.setSuperclassAttribute("superclass-entity-tableperclass");
        long persistedId = 0L;
        try {
            em.persist((Object)newObject);
            persistedId = newObject.getId();
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting new object: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            SuperclassEntityTablePerClass readObject = (SuperclassEntityTablePerClass)em.find(SuperclassEntityTablePerClass.class, (Object)persistedId);
            MixedInheritanceJUnitTestCase.assertNotNull((String)("Object read back with pk " + persistedId + " must not be null"), (Object)readObject);
            MixedInheritanceJUnitTestCase.assertEquals((String)"id", (long)newObject.getId(), (long)readObject.getId());
            MixedInheritanceJUnitTestCase.assertEquals((String)"superclassAttribute", (String)newObject.getSuperclassAttribute(), (String)readObject.getSuperclassAttribute());
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNewJoinedTableSubclass() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        SubclassEntityJoined newObject = new SubclassEntityJoined();
        newObject.setSuperclassAttribute("superclass-entity-joined");
        newObject.setSubclassAttribute("subclass-entity-joined");
        long persistedId = 0L;
        try {
            em.persist((Object)newObject);
            persistedId = newObject.getId();
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting new object: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            SubclassEntityJoined readObject = (SubclassEntityJoined)em.find(SubclassEntityJoined.class, (Object)persistedId);
            MixedInheritanceJUnitTestCase.assertNotNull((String)("Object read back with pk " + persistedId + " must not be null"), (Object)readObject);
            MixedInheritanceJUnitTestCase.assertEquals((String)"id", (long)newObject.getId(), (long)readObject.getId());
            MixedInheritanceJUnitTestCase.assertEquals((String)"superclassAttribute", (String)newObject.getSuperclassAttribute(), (String)readObject.getSuperclassAttribute());
            MixedInheritanceJUnitTestCase.assertEquals((String)"subclassAttribute", (String)newObject.getSubclassAttribute(), (String)readObject.getSubclassAttribute());
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNewSingleTableSubclass() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        SubclassEntitySingleTable newObject = new SubclassEntitySingleTable();
        newObject.setSuperclassAttribute("superclass-entity-singletable");
        newObject.setSubclassAttribute("subclass-entity-singletable");
        long persistedId = 0L;
        try {
            em.persist((Object)newObject);
            persistedId = newObject.getId();
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting new object: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            SubclassEntitySingleTable readObject = (SubclassEntitySingleTable)em.find(SubclassEntitySingleTable.class, (Object)persistedId);
            MixedInheritanceJUnitTestCase.assertNotNull((String)("Object read back with pk " + persistedId + " must not be null"), (Object)readObject);
            MixedInheritanceJUnitTestCase.assertEquals((String)"id", (long)newObject.getId(), (long)readObject.getId());
            MixedInheritanceJUnitTestCase.assertEquals((String)"superclassAttribute", (String)newObject.getSuperclassAttribute(), (String)readObject.getSuperclassAttribute());
            MixedInheritanceJUnitTestCase.assertEquals((String)"subclassAttribute", (String)newObject.getSubclassAttribute(), (String)readObject.getSubclassAttribute());
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNewTablePerClassSubclass() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        SubclassEntityTablePerClass newObject = new SubclassEntityTablePerClass();
        newObject.setSuperclassAttribute("superclass-entity-tableperclass");
        newObject.setSubclassAttribute("subclass-entity-tableperclass");
        long persistedId = 0L;
        try {
            em.persist((Object)newObject);
            persistedId = newObject.getId();
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting new object: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            SubclassEntityTablePerClass readObject = (SubclassEntityTablePerClass)em.find(SubclassEntityTablePerClass.class, (Object)persistedId);
            MixedInheritanceJUnitTestCase.assertNotNull((String)("Object read back with pk " + persistedId + " must not be null"), (Object)readObject);
            MixedInheritanceJUnitTestCase.assertEquals((String)"id", (long)newObject.getId(), (long)readObject.getId());
            MixedInheritanceJUnitTestCase.assertEquals((String)"superclassAttribute", (String)newObject.getSuperclassAttribute(), (String)readObject.getSuperclassAttribute());
            MixedInheritanceJUnitTestCase.assertEquals((String)"subclassAttribute", (String)newObject.getSubclassAttribute(), (String)readObject.getSubclassAttribute());
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
    }
}

