/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.reading;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTestCase;

public class JPAReadPerformanceComparisonTest
extends PerformanceRegressionTestCase {
    protected boolean isReadOnly;

    public JPAReadPerformanceComparisonTest() {
        this.isReadOnly = true;
    }

    public JPAReadPerformanceComparisonTest(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public List list(Query query, EntityManager session) {
        List result = null;
        if (!this.isReadOnly()) {
            session.getTransaction().begin();
            result = query.getResultList();
            session.getTransaction().commit();
        } else {
            session.getTransaction().begin();
            query.setHint("org.hibernate.readOnly", (Object)Boolean.TRUE);
            query.setHint("eclipselink.read-only", (Object)Boolean.TRUE);
            query.setHint("toplink.return-shared", (Object)Boolean.TRUE);
            result = query.getResultList();
            session.getTransaction().commit();
        }
        return result;
    }

    public Object uniqueResult(Query query, EntityManager session) {
        Object result = null;
        if (!this.isReadOnly()) {
            session.getTransaction().begin();
            result = query.getSingleResult();
            session.getTransaction().commit();
        } else {
            session.getTransaction().begin();
            query.setHint("org.hibernate.readOnly", (Object)Boolean.TRUE);
            query.setHint("eclipselink.return-shared", (Object)Boolean.TRUE);
            result = query.getSingleResult();
            session.getTransaction().commit();
        }
        return result;
    }
}

