/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.metamodel.BasicTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EmbeddableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.IdentifiableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MappedSuperclassTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sessions.Project;

public class MetamodelImpl
implements Metamodel,
Serializable {
    private static final long serialVersionUID = -7352420189248464690L;
    private AbstractSession session;
    private Map<String, EntityTypeImpl<?>> entities;
    private Map<String, EmbeddableTypeImpl<?>> embeddables;
    private Map<String, ManagedTypeImpl<?>> managedTypes;
    private Map<String, TypeImpl<?>> types;
    private Set<MappedSuperclassTypeImpl<?>> mappedSuperclasses;
    private boolean isInitialized = false;
    public static final Class DEFAULT_ELEMENT_TYPE_FOR_UNSUPPORTED_MAPPINGS = Object.class;

    public MetamodelImpl(AbstractSession session) {
        this.session = session;
        this.preInitialize();
    }

    public MetamodelImpl(EntityManager em) {
        this(JpaHelper.getEntityManager(em).getAbstractSession());
    }

    public MetamodelImpl(EntityManagerFactory emf) {
        this((AbstractSession)((Object)JpaHelper.getDatabaseSession(emf)));
    }

    public MetamodelImpl(EntityManagerSetupImpl emSetupImpl) {
        this(emSetupImpl.getSession());
    }

    public <X> EmbeddableType<X> embeddable(Class<X> clazz) {
        String key = clazz == null ? null : clazz.getName();
        EmbeddableTypeImpl<?> aType = this.embeddables.get(key);
        if (aType == null) {
            this.entityEmbeddableManagedTypeNotFound(this.embeddables, null, clazz, "Embeddable", "EmbeddableType");
        }
        return aType;
    }

    private void entityEmbeddableManagedTypeNotFound(Map typeMap, Object aType, Class clazz, String metamodelType, String metamodelTypeName) {
        if (typeMap.isEmpty()) {
            AbstractSessionLog.getLog().log(6, "metamodel", "metamodel_type_collection_empty_during_lookup", (Object)clazz, (Object)metamodelTypeName);
        }
        if (null == clazz) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_class_null_type_instance_for_null_key", new Object[]{metamodelTypeName, metamodelType}));
        }
        if (null == aType) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_class_null_type_instance", new Object[]{clazz.getCanonicalName(), metamodelTypeName, metamodelType}));
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_class_incorrect_type_instance", new Object[]{clazz, metamodelTypeName, aType}));
    }

    public <X> EntityType<X> entity(Class<X> clazz) {
        String key = clazz == null ? null : clazz.getName();
        EntityTypeImpl<?> aType = this.entities.get(key);
        if (aType == null) {
            this.entityEmbeddableManagedTypeNotFound(this.entities, null, clazz, "Entity", "EntityType");
        }
        return aType;
    }

    public List<Attribute> getAllManagedTypeAttributes() {
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        for (ManagedType managedType : this.managedTypes.values()) {
            attributeList.addAll(managedType.getAttributes());
        }
        return attributeList;
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return new LinkedHashSet(this.embeddables.values());
    }

    public Set<EntityType<?>> getEntities() {
        return new LinkedHashSet(this.entities.values());
    }

    public Map<String, ManagedTypeImpl<?>> getManagedTypesMap() {
        return this.managedTypes;
    }

    public Set<ManagedType<?>> getManagedTypes() {
        return new LinkedHashSet(this.managedTypes.values());
    }

    public Set<MappedSuperclassTypeImpl<?>> getMappedSuperclasses() {
        return new LinkedHashSet(this.mappedSuperclasses);
    }

    public Project getProject() {
        return this.getSession().getProject();
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    private boolean putType(String javaClassKey, TypeImpl typeValue) {
        boolean isValid = true;
        if (null == javaClassKey) {
            isValid = false;
        }
        this.types.put(javaClassKey, typeValue);
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> TypeImpl<X> getType(Class<X> javaClass) {
        String key = javaClass == null ? null : javaClass.getName();
        TypeImpl<?> type = this.types.get(key);
        if (null == type) {
            Map<String, TypeImpl<?>> map = this.types;
            synchronized (map) {
                type = this.types.get(key);
                if (null == type) {
                    type = new BasicTypeImpl(javaClass);
                    this.putType(key, type);
                }
            }
        }
        return type;
    }

    public Map<String, TypeImpl<?>> getTypes() {
        return this.types;
    }

    protected boolean hasMappedSuperclass(String qualifiedClassNameKeyString) {
        return this.getSession().getProject().hasMappedSuperclass(qualifiedClassNameKeyString);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    private void preInitialize() {
        String descriptorJavaType;
        this.types = new LinkedHashMap();
        this.entities = new LinkedHashMap();
        this.embeddables = new LinkedHashMap();
        this.managedTypes = new LinkedHashMap();
        this.mappedSuperclasses = new LinkedHashSet();
        for (ClassDescriptor descriptor : this.getSession().getProject().getOrderedDescriptors()) {
            ManagedTypeImpl<?> managedType = ManagedTypeImpl.create(this, descriptor);
            descriptorJavaType = managedType.getJavaTypeName();
            if (null == descriptorJavaType) {
                AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_relationaldescriptor_javaclass_null_on_managedType", (Object)descriptor, managedType);
            }
            this.putType(descriptorJavaType, managedType);
            this.managedTypes.put(descriptorJavaType, managedType);
            if (managedType.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
                this.entities.put(descriptorJavaType, (EntityTypeImpl)managedType);
            }
            if (!managedType.getPersistenceType().equals((Object)Type.PersistenceType.EMBEDDABLE)) continue;
            this.embeddables.put(descriptorJavaType, (EmbeddableTypeImpl)managedType);
        }
        for (ClassDescriptor descriptor : this.getSession().getProject().getMappedSuperclassDescriptors().values()) {
            MappedSuperclassTypeImpl mappedSuperclassType = (MappedSuperclassTypeImpl)ManagedTypeImpl.create(this, descriptor);
            this.mappedSuperclasses.add(mappedSuperclassType);
            descriptorJavaType = mappedSuperclassType.getJavaTypeName();
            if (null == descriptorJavaType) {
                AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_relationaldescriptor_javaclass_null_on_managedType", (Object)descriptor, (Object)mappedSuperclassType);
            }
            this.putType(descriptorJavaType, mappedSuperclassType);
            this.managedTypes.put(descriptorJavaType, mappedSuperclassType);
        }
    }

    public void initialize(ClassLoader classLoader) {
        for (ManagedTypeImpl<?> potentialIdentifiableType : this.managedTypes.values()) {
            Class aClass = potentialIdentifiableType.getJavaType(classLoader);
            if (null == aClass) {
                AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_itentifiableType_javaclass_null_cannot_set_supertype", (Object)potentialIdentifiableType.getDescriptor(), (Object)this);
                continue;
            }
            Class superclass = aClass.getSuperclass();
            IdentifiableType identifiableTypeSuperclass = null;
            if (!potentialIdentifiableType.isIdentifiableType() || superclass == ClassConstants.OBJECT || superclass == null) continue;
            identifiableTypeSuperclass = (IdentifiableType)this.managedTypes.get(superclass.getName());
            ((IdentifiableTypeImpl)potentialIdentifiableType).setSupertype(identifiableTypeSuperclass);
            if (null != identifiableTypeSuperclass && ((IdentifiableTypeImpl)identifiableTypeSuperclass).isMappedSuperclass()) {
                ((MappedSuperclassTypeImpl)identifiableTypeSuperclass).addInheritingType((IdentifiableTypeImpl)potentialIdentifiableType);
            }
            ((IdentifiableTypeImpl)potentialIdentifiableType).setSupertype(identifiableTypeSuperclass);
        }
        for (ManagedTypeImpl<?> managedType : new ArrayList(this.managedTypes.values())) {
            managedType.initialize();
        }
        for (ManagedTypeImpl<?> potentialIdentifiableType : this.managedTypes.values()) {
            if (!potentialIdentifiableType.isIdentifiableType()) continue;
            ((IdentifiableTypeImpl)potentialIdentifiableType).initializeIdAttributes();
        }
        if (!(null != this.embeddables && !this.embeddables.isEmpty() || null != this.managedTypes && !this.managedTypes.isEmpty() || null != this.entities && !this.entities.isEmpty())) {
            AbstractSessionLog.getLog().log(6, "metamodel", "metamodel_type_collection_empty", null, true);
        }
        this.isInitialized = true;
    }

    public <X> ManagedType<X> managedType(Class<X> clazz) {
        String key = clazz == null ? null : clazz.getName();
        ManagedTypeImpl<?> aType = this.managedTypes.get(key);
        if (aType == null) {
            this.entityEmbeddableManagedTypeNotFound(this.managedTypes, null, clazz, "Managed", "ManagedType");
        }
        return aType;
    }

    public void printAllTypes() {
        if (null == this.types || this.types.isEmpty()) {
            AbstractSessionLog.getLog().log(6, "metamodel", "metamodel_type_collection_empty", null, true);
        } else {
            this.session.log(5, "metamodel", "metamodel_print_type_header", this.types.size());
            for (Type type : this.types.values()) {
                this.session.log(5, "metamodel", "metamodel_print_type_value", type);
            }
        }
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(this.getClass().getSimpleName());
        aBuffer.append("@");
        aBuffer.append(this.hashCode());
        aBuffer.append(" [");
        if (null != this.types) {
            aBuffer.append(" ");
            aBuffer.append(this.types.size());
            aBuffer.append(" Types: ");
        }
        if (null != this.managedTypes) {
            aBuffer.append(", ");
            aBuffer.append(this.managedTypes.size());
            aBuffer.append(" ManagedTypes: ");
        }
        if (null != this.entities) {
            aBuffer.append(", ");
            aBuffer.append(this.entities.size());
            aBuffer.append(" EntityTypes: ");
        }
        if (null != this.mappedSuperclasses) {
            aBuffer.append(", ");
            aBuffer.append(this.mappedSuperclasses.size());
            aBuffer.append(" MappedSuperclassTypes: ");
        }
        if (null != this.embeddables) {
            aBuffer.append(", ");
            aBuffer.append(this.embeddables.size());
            aBuffer.append(" EmbeddableTypes: ");
        }
        aBuffer.append("]");
        return aBuffer.toString();
    }
}

