/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.util.HashMap;
import java.util.Map;

public enum LogCategory {
    ALL(0, "all"),
    CACHE(1, "cache"),
    CONNECTION(2, "connection"),
    DDL(3, "ddl"),
    DMS(4, "dms"),
    EJB(5, "ejb"),
    EVENT(6, "event"),
    JPA(7, "jpa"),
    JPARS(8, "jpars"),
    METADATA(9, "metadata"),
    METAMODEL(10, "metamodel"),
    MISC(11, "misc"),
    MONITORING(12, "monitoring"),
    MOXY(13, "moxy"),
    PROCESSOR(14, "processor"),
    PROPAGATION(15, "propagation"),
    PROPERTIES(16, "properties"),
    QUERY(17, "query"),
    SEQUENCING(18, "sequencing"),
    SERVER(19, "server"),
    SQL(20, "sql"),
    TRANSACTION(21, "transaction"),
    WEAVER(22, "weaver");

    public static final int length;
    private static final String NAMESPACE_PREFIX = "eclipselink.logging.";
    private static final Map<String, LogCategory> stringValuesMap;
    private static final String[] nameSpaces;
    private static final String[] levelNameSpaces;
    private final byte id;
    private final String name;

    public static final LogCategory toValue(String name) {
        return name != null && name.length() > 0 ? stringValuesMap.get(name.toLowerCase()) : ALL;
    }

    private LogCategory(byte id, String name) {
        this.id = id;
        this.name = name;
    }

    public byte getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNameSpace() {
        return nameSpaces[this.id];
    }

    public String getLogLevelProperty() {
        return levelNameSpaces[this.id];
    }

    static {
        length = LogCategory.values().length;
        stringValuesMap = new HashMap<String, LogCategory>(2 * length);
        nameSpaces = new String[length];
        levelNameSpaces = new String[length];
        for (LogCategory category : LogCategory.values()) {
            stringValuesMap.put(category.name.toLowerCase(), category);
        }
        for (LogCategory category : LogCategory.values()) {
            LogCategory.nameSpaces[category.id] = (NAMESPACE_PREFIX + category.name).intern();
            LogCategory.levelNameSpaces[category.id] = ("eclipselink.logging.level." + category.name).intern();
        }
    }
}

