/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.perf;

import oracle.kv.impl.async.perf.PerfCondition;

public class PerfFilter {
    public static final String SAMPLE_RATE_PROPERTY = "oracle.kv.async.perf.samplerate";
    public static final int DEFAULT_SAMPLE_RATE = 1024;
    public static final LongFilt SYSTEM_SAMPLING = new LongFilt(){

        @Override
        public boolean accept(long count) {
            if (!PerfCondition.SYSTEM_PERF_ENABLED.holds()) {
                return false;
            }
            if (sampleRateNextPow2NumTrailingZeros == -1) {
                return false;
            }
            return Long.numberOfTrailingZeros(count) >= sampleRateNextPow2NumTrailingZeros;
        }
    };
    private static final int sampleRateNextPow2NumTrailingZeros = PerfFilter.getSampleRateNextPow2NumTrailingZeros();

    private static int getSampleRateNextPow2NumTrailingZeros() {
        int v = Math.max(0, Integer.getInteger(SAMPLE_RATE_PROPERTY, 1024));
        return v == 0 ? -1 : 32 - Integer.numberOfLeadingZeros(v - 1);
    }

    public static interface LongFilt {
        public boolean accept(long var1);
    }
}

