/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.measurement;

import com.sleepycat.je.utilint.JVMSystemUtils;
import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import oracle.kv.impl.measurement.ConciseStats;
import oracle.kv.impl.util.sklogger.PerfQuantile;

public class JVMStats
implements ConciseStats,
Serializable {
    public static volatile boolean stopPauseChecker;
    private static final long serialVersionUID = 1L;
    private static final int MAX_TRACKED_LATENCY = 1000;
    private static final String GARBAGE_COLLECTION_NOTIFICATION = "com.sun.management.gc.notification";
    private final long start;
    private final long end;
    private final long freeMemory;
    private final long maxMemory;
    private final long totalMemory;
    private final long pauseCount;
    private final int pause95;
    private final int pause99;
    private final int pauseMax;
    private final List<CollectorInfo> collectors;

    private static String getGcName(CompositeData compositeData) {
        return (String)compositeData.get("gcName");
    }

    private static long getGcDuration(CompositeData compositeData) {
        CompositeDataSupport gcInfo = (CompositeDataSupport)compositeData.get("gcInfo");
        return (Long)gcInfo.get("duration");
    }

    private JVMStats(long start, long end, Map<String, CollectorTotal> collectorTotals, Map<String, PerfQuantile> gcPerfQuantiles, PerfQuantile pauseQuantile) {
        this.start = start;
        this.end = end;
        Runtime rt = Runtime.getRuntime();
        this.freeMemory = rt.freeMemory();
        this.maxMemory = JVMSystemUtils.getRuntimeMaxMemory();
        this.totalMemory = rt.totalMemory();
        PerfQuantile.RateResult pauseResult = (PerfQuantile.RateResult)pauseQuantile.rateSinceLastTime("pause");
        this.pauseCount = pauseResult.getOperationCount();
        this.pause95 = pauseResult.get95th();
        this.pause99 = pauseResult.get99th();
        this.pauseMax = pauseResult.getMax();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        this.collectors = new ArrayList<CollectorInfo>(gcBeans.size());
        for (GarbageCollectorMXBean gc : gcBeans) {
            this.collectors.add(new CollectorInfo(gc, collectorTotals, gcPerfQuantiles));
        }
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getPauseCount() {
        return this.pauseCount;
    }

    public long getPause95th() {
        return this.pause95;
    }

    public long getPause99th() {
        return this.pause99;
    }

    public long getPauseMax() {
        return this.pauseMax;
    }

    public List<CollectorInfo> getCollectors() {
        return this.collectors;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    public String getFormattedStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("Memory");
        sb.append("\n\tfreeMemory=");
        sb.append(this.freeMemory);
        sb.append("\n\tmaxMemory=");
        sb.append(this.maxMemory);
        sb.append("\n\ttotalMemory=");
        sb.append(this.totalMemory);
        if (this.pauseCount > 0L) {
            sb.append("\n\tpauseCount=");
            sb.append(this.pauseCount);
        }
        if (this.pause95 > 0) {
            sb.append("\n\tpause95th=");
            sb.append(this.pause95);
        }
        if (this.pause99 > 0) {
            sb.append("\n\tpause99th=");
            sb.append(this.pause99);
        }
        if (this.pauseMax > 0) {
            sb.append("\n\tpauseMax=");
            sb.append(this.pauseMax);
        }
        for (CollectorInfo gc : this.collectors) {
            gc.getFormattedStats(sb);
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        return "JVMStats[" + this.getFormattedStats() + "]";
    }

    public static class CollectorInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final long count;
        private final long time;
        private final int percent95;
        private final int percent99;
        private final int max;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CollectorInfo(GarbageCollectorMXBean gc, Map<String, CollectorTotal> collectorTotals, Map<String, PerfQuantile> perfQuantiles) {
            CollectorTotal total;
            this.name = gc.getName();
            Map<String, CollectorTotal> map = collectorTotals;
            synchronized (map) {
                total = collectorTotals.get(this.name);
                if (total == null) {
                    total = new CollectorTotal();
                    collectorTotals.put(this.name, total);
                }
            }
            this.count = total.updateCount(gc.getCollectionCount());
            this.time = total.updateTime(gc.getCollectionTime());
            PerfQuantile quantile = perfQuantiles.get(gc.getName());
            if (quantile != null) {
                PerfQuantile.RateResult result = (PerfQuantile.RateResult)quantile.rateSinceLastTime("gcLatency");
                this.percent95 = result.get95th();
                this.percent99 = result.get99th();
                this.max = result.getMax();
            } else {
                this.percent95 = -1;
                this.percent99 = -1;
                this.max = -1;
            }
        }

        public String getName() {
            return this.name;
        }

        public long getCount() {
            return this.count;
        }

        public long getTime() {
            return this.time;
        }

        public long get95th() {
            return this.percent95;
        }

        public long get99th() {
            return this.percent99;
        }

        public long getMax() {
            return this.max;
        }

        void getFormattedStats(StringBuilder sb) {
            if (this.count > 0L) {
                sb.append("\n");
                sb.append("GC ");
                sb.append(this.name);
                sb.append("\n\tcount=");
                sb.append(this.count);
                sb.append("\n\ttime=");
                sb.append(this.time);
                if (this.percent95 >= 0) {
                    sb.append("\n\t95th=");
                    sb.append(this.percent95);
                }
                if (this.percent99 >= 0) {
                    sb.append("\n\t99th=");
                    sb.append(this.percent99);
                }
                if (this.max >= 0) {
                    sb.append("\n\tmax=");
                    sb.append(this.max);
                }
            }
        }
    }

    private static class PauseChecker
    implements Runnable {
        final PerfQuantile quantile = new PerfQuantile("pauses", 1000, new String[0]);

        PauseChecker() {
            Thread t = new Thread((Runnable)this, "KV Pause Checker");
            t.setDaemon(true);
            t.start();
        }

        @Override
        public void run() {
            while (!stopPauseChecker) {
                long start = System.nanoTime();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    continue;
                }
                long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                if (time <= 1L) continue;
                this.quantile.observe((int)time);
            }
        }
    }

    private static class CollectorTotal {
        private long count;
        private long time;

        private CollectorTotal() {
        }

        synchronized long updateCount(long newCount) {
            long change = newCount - this.count;
            this.count = newCount;
            return change;
        }

        synchronized long updateTime(long newTime) {
            long change = newTime - this.time;
            this.time = newTime;
            return change;
        }
    }

    public static class Tracker {
        private final Map<String, CollectorTotal> collectorTotals = Collections.synchronizedMap(new HashMap());
        private boolean checkRegisterForGCNotifications;
        private final Map<String, PerfQuantile> gcPerfQuantiles = Collections.synchronizedMap(new HashMap());
        private final PauseChecker pauseChecker = new PauseChecker();

        public JVMStats createStats(long start, long end) {
            this.maybeRegisterForNotifications();
            return new JVMStats(start, end, this.collectorTotals, this.gcPerfQuantiles, this.pauseChecker.quantile);
        }

        private synchronized void maybeRegisterForNotifications() {
            if (this.checkRegisterForGCNotifications) {
                return;
            }
            this.checkRegisterForGCNotifications = true;
            for (GarbageCollectorMXBean gcbean : ManagementFactory.getGarbageCollectorMXBeans()) {
                if (!(gcbean instanceof NotificationEmitter)) continue;
                ((NotificationEmitter)((Object)gcbean)).addNotificationListener(new GCListener(), null, null);
            }
        }

        private class GCListener
        implements NotificationListener {
            private GCListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object handback) {
                PerfQuantile quantile;
                long gcDuration;
                String gcName;
                if (!notification.getType().equals(JVMStats.GARBAGE_COLLECTION_NOTIFICATION)) {
                    return;
                }
                try {
                    CompositeData compositeData = (CompositeData)notification.getUserData();
                    gcName = JVMStats.getGcName(compositeData);
                    gcDuration = JVMStats.getGcDuration(compositeData);
                }
                catch (Exception e) {
                    return;
                }
                Map map = Tracker.this.gcPerfQuantiles;
                synchronized (map) {
                    quantile = (PerfQuantile)Tracker.this.gcPerfQuantiles.get(gcName);
                    if (quantile == null) {
                        quantile = new PerfQuantile("gcLatencies", 1000, new String[0]);
                        Tracker.this.gcPerfQuantiles.put(gcName, quantile);
                    }
                }
                quantile.observe((int)gcDuration);
            }
        }
    }
}

