/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.ConformResultsInUnitOfWorkTest;

public class ConformResultsAcrossWrappedOneToManyTest
extends ConformResultsInUnitOfWorkTest {
    public Vector expectedResult;

    public ConformResultsAcrossWrappedOneToManyTest() {
        this.setShouldUseWrapperPolicy(true);
    }

    @Override
    public void buildConformQuery() {
        if (this.conformedQuery != null) {
            return;
        }
        this.conformedQuery = new ReadAllQuery(Employee.class);
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.anyOf("managedEmployees").get("firstName").equal((Object)"Marcus");
        this.conformedQuery.setSelectionCriteria(expression);
        this.conformedQuery.conformResultsInUnitOfWork();
    }

    @Override
    public void prepareTest() {
        this.buildConformQuery();
        ReadAllQuery conformedQuery = (ReadAllQuery)this.conformedQuery;
        Vector employees = (Vector)this.unitOfWork.executeQuery((DatabaseQuery)conformedQuery);
        employees = conformedQuery.getContainerPolicy().vectorFor((Object)employees, (AbstractSession)((UnitOfWorkImpl)this.unitOfWork));
        Enumeration enumtr = employees.elements();
        while (enumtr.hasMoreElements()) {
            Employee employee = (Employee)enumtr.nextElement();
            conformedQuery.getContainerPolicy().vectorFor((Object)employee.getManagedEmployees(), (AbstractSession)((UnitOfWorkImpl)this.unitOfWork));
        }
        this.expectedResult = employees;
    }

    @Override
    public void verify() {
        int resultSize = ((Vector)this.result).size();
        if (resultSize != this.expectedResult.size()) {
            throw new TestErrorException("Result probably was not unwrapped while conforming.");
        }
    }
}

