/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.JavaLog;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLValidationTest;

public class JavaLogSessionNamespaceTest
extends SessionsXMLValidationTest {
    public JavaLogSessionNamespaceTest() {
        this.setName("JavaLogCategoryNameValidationTest");
        this.setSessionXmlFileName("org/eclipse/persistence/testing/models/sessionsxml/javalogsessions.xml");
        this.setSessionName("JavaLogSession");
    }

    @Override
    public void verify() {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader(this.getSessionXmlFileName());
        AbstractSession session = SessionManager.getManager().getSession(loader, this.getSessionName(), ((Object)((Object)this)).getClass().getClassLoader(), false, false);
        if (!(session.getSessionLog() instanceof JavaLog)) {
            throw new TestErrorException("Failed to create TopLink Session Log");
        }
        String sessionName = session.getName();
        String sessionNamespace = "org.eclipse.persistence.session." + sessionName;
        JavaLog log = (JavaLog)session.getSessionLog();
        if (!log.getCategoryLoggers().containsKey(sessionNamespace)) {
            throw new TestErrorException("JavaLog did not contain expected session namespace: [" + sessionNamespace + "] for session name: [" + sessionName + "]");
        }
    }
}

