/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.remote;

import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.ObjectDescriptor;
import org.eclipse.persistence.internal.sessions.remote.RemoteCommand;
import org.eclipse.persistence.internal.sessions.remote.RemoteCursoredStream;
import org.eclipse.persistence.internal.sessions.remote.RemoteFunctionCall;
import org.eclipse.persistence.internal.sessions.remote.RemoteScrollableCursor;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.internal.sessions.remote.ReplaceValueHoldersIterator;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.CursorPolicy;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.sessions.coordination.CommandManager;

public class RemoteSessionController {
    protected boolean isInTransaction;
    protected boolean isInEarlyTransaction;
    protected AbstractSession session;
    protected UnitOfWorkImpl unitOfWork;
    protected Map<ObjID, ValueHolderInterface> remoteValueHolders;
    protected Map<ObjID, Cursor> remoteCursors;
    protected CommandManager commandManager;

    public RemoteSessionController(AbstractSession session) {
        this.commandManager = session.getCommandManager();
        this.initialize(session);
    }

    public Transporter processCommand(Transporter remoteCommand) {
        Transporter transporter = new Transporter();
        try {
            ((RemoteCommand)remoteCommand.getObject()).execute(this.getSession(), this);
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter beginTransaction() {
        if (this.isInTransaction()) {
            this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
        }
        Transporter transporter = new Transporter();
        try {
            this.getSession().beginTransaction();
            if (this.isInTransaction()) {
                this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
            }
            if (this.getSession().isInTransaction()) {
                this.setIsInTransaction(true);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter beginEarlyTransaction() {
        if (this.isInTransaction()) {
            this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
        }
        Transporter transporter = new Transporter();
        try {
            this.getSession().beginTransaction();
            if (this.isInTransaction()) {
                this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
            }
            if (this.getSession().isInTransaction()) {
                this.isInTransaction = true;
                this.isInEarlyTransaction = true;
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    protected ObjectDescriptor buildObjectDescriptor(Object object) {
        ObjectDescriptor objectDescriptor = new ObjectDescriptor();
        ClassDescriptor descriptor = this.getSession().getDescriptor(object);
        Object key = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
        objectDescriptor.setKey(key);
        objectDescriptor.setWriteLockValue(this.getExecutionSession().getIdentityMapAccessorInstance().getWriteLockValue(key, object.getClass(), descriptor));
        objectDescriptor.setObject(object);
        CacheKey cacheKey = this.getExecutionSession().getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(key, object.getClass(), descriptor);
        if (cacheKey != null) {
            objectDescriptor.setReadTime(cacheKey.getReadTime());
        }
        return objectDescriptor;
    }

    public Transporter closeScrollableCursor(ObjID id) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(id);
            if (stream != null) {
                stream.close();
            }
            this.getRemoteCursors().remove(id);
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter commitRootUnitOfWork(Transporter remoteTransporter) {
        remoteTransporter.expand(this.session);
        if (this.isInTransaction()) {
            this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
        }
        RemoteUnitOfWork remoteUnitOfWork = (RemoteUnitOfWork)remoteTransporter.getObject();
        remoteUnitOfWork.reinitializeForSession(this.getSession(), this);
        Transporter transporter = new Transporter();
        try {
            if (remoteUnitOfWork.isFlush()) {
                remoteUnitOfWork.writeChanges();
            } else {
                remoteUnitOfWork.commitRootUnitOfWork();
                this.isInTransaction = false;
                this.isInEarlyTransaction = false;
            }
            transporter.setObject(remoteUnitOfWork);
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        transporter.prepare(remoteUnitOfWork);
        return transporter;
    }

    public Transporter commitTransaction() {
        Transporter transporter = new Transporter();
        try {
            this.getSession().commitTransaction();
            if (!this.getSession().isInTransaction()) {
                this.isInTransaction = false;
                this.isInEarlyTransaction = false;
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter cursoredStreamClose(Transporter remoteCursoredStreamOid) {
        Transporter transporter = new Transporter();
        try {
            ObjID id = (ObjID)remoteCursoredStreamOid.getObject();
            CursoredStream stream = (CursoredStream)this.getRemoteCursors().get(id);
            if (stream != null) {
                stream.close();
            }
            this.getRemoteCursors().remove(id);
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter cursoredStreamNextpage(Transporter remoteCursoredId, int pageSize) {
        Transporter transporter = new Transporter();
        Vector nextPagesObjects = null;
        IdentityHashMap objectDescriptors = new IdentityHashMap(pageSize);
        try {
            CursoredStream stream = (CursoredStream)this.getRemoteCursors().get(remoteCursoredId.getObject());
            if (stream != null) {
                Object objectNext;
                nextPagesObjects = stream.nextElements(pageSize);
                Enumeration enumtr = nextPagesObjects.elements();
                while (enumtr.hasMoreElements() && (objectNext = enumtr.nextElement()) != null) {
                    if (!stream.getQuery().isReadAllQuery() || stream.getQuery().isReportQuery()) continue;
                    this.replaceValueHoldersIn(objectNext, objectDescriptors);
                }
            } else {
                nextPagesObjects = new Vector(0);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        transporter.setObjectDescriptors(objectDescriptors);
        transporter.setObject(nextPagesObjects);
        return transporter;
    }

    public Transporter cursoredStreamSize(Transporter remoteCursoredStreamOid) {
        Transporter transporter = new Transporter();
        try {
            CursoredStream stream = (CursoredStream)this.getRemoteCursors().get(remoteCursoredStreamOid.getObject());
            if (stream != null) {
                transporter.setObject(stream.size());
            } else {
                transporter.setObject(0);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter cursorSelectObjects(Transporter remoteTransporter) {
        Transporter transporter = new Transporter();
        try {
            CursorPolicy policy = (CursorPolicy)remoteTransporter.getObject();
            this.unitOfWork = null;
            AbstractSession executionSession = this.getExecutionSession();
            if (policy.isCursoredStreamPolicy()) {
                CursoredStream stream = (CursoredStream)executionSession.executeQuery(policy.getQuery());
                RemoteCursoredStream remoteStream = new RemoteCursoredStream(stream);
                remoteStream.setObjectCollection(stream.nextElements(stream.getObjectCollection().size()));
                this.getRemoteCursors().put(remoteStream.getID(), stream);
                if (stream.getQuery().isReadAllQuery() && !stream.getQuery().isReportQuery()) {
                    transporter.setObjectDescriptors(this.replaceValueHoldersInAll(remoteStream.getObjectCollection(), new CollectionContainerPolicy(ClassConstants.Vector_class)));
                }
                transporter.setObject(remoteStream);
            } else if (policy.isScrollableCursorPolicy()) {
                ScrollableCursor stream = (ScrollableCursor)executionSession.executeQuery(policy.getQuery());
                RemoteScrollableCursor remoteStream = new RemoteScrollableCursor(stream);
                this.getRemoteCursors().put(remoteStream.getID(), stream);
                transporter.setObject(remoteStream);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter executeNamedQuery(Transporter nameTransporter, Transporter classTransporter, Transporter argumentsTransporter) {
        Transporter transporter = new Transporter();
        try {
            DatabaseQuery query;
            Object result;
            this.unitOfWork = null;
            AbstractSession executionSession = this.getExecutionSession();
            if (classTransporter.getObject() == null) {
                result = executionSession.executeQuery((String)nameTransporter.getObject(), (Vector)argumentsTransporter.getObject());
                query = executionSession.getQuery((String)nameTransporter.getObject());
            } else {
                result = executionSession.executeQuery((String)nameTransporter.getObject(), (Class)classTransporter.getObject(), (Vector)argumentsTransporter.getObject());
                query = executionSession.getDescriptor((Class)classTransporter.getObject()).getQueryManager().getQuery((String)nameTransporter.getObject());
            }
            transporter.setQuery(query);
            transporter.setObjectDescriptors(query.replaceValueHoldersIn(result, this));
            transporter.setObject(result);
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        transporter.prepare(this.session);
        return transporter;
    }

    public Transporter executeQuery(Transporter remoteTransporter) {
        remoteTransporter.expand(this.session);
        DatabaseQuery query = (DatabaseQuery)remoteTransporter.getObject();
        Transporter transporter = new Transporter();
        try {
            AbstractRecord argumentRow = query.getTranslationRow();
            query.setTranslationRow(null);
            this.unitOfWork = null;
            AbstractSession executionSession = this.getExecutionSession();
            Object result = argumentRow == null ? executionSession.executeQuery(query) : executionSession.executeQuery(query, argumentRow);
            transporter.setObjectDescriptors(query.replaceValueHoldersIn(result, this));
            transporter.setObject(result);
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        transporter.prepare(this.session);
        return transporter;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public Transporter getDefaultReadOnlyClasses() {
        Transporter transporter = new Transporter();
        try {
            transporter.setObject(this.getSession().getDefaultReadOnlyClasses());
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter getDescriptor(Transporter remoteTransporter) {
        Class theClass = (Class)remoteTransporter.getObject();
        Transporter transporter = new Transporter();
        try {
            ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
            transporter.setObject(descriptor);
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter getDescriptorForAlias(Transporter remoteTransporter) {
        String alias = (String)remoteTransporter.getObject();
        Transporter transporter = new Transporter();
        try {
            ClassDescriptor descriptor = this.getSession().getDescriptorForAlias(alias);
            transporter.setObject(descriptor);
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter getLogin() {
        Transporter transporter = new Transporter();
        try {
            transporter.setObject(this.getSession().getDatasourceLogin());
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    protected Map<ObjID, Cursor> getRemoteCursors() {
        return this.remoteCursors;
    }

    public Map<ObjID, ValueHolderInterface> getRemoteValueHolders() {
        return this.remoteValueHolders;
    }

    public Transporter getSequenceNumberNamed(Transporter remoteFunctionCall) {
        Transporter transporter = new Transporter();
        Object returnValue = null;
        try {
            RemoteFunctionCall functionCall = (RemoteFunctionCall)remoteFunctionCall.getObject();
            returnValue = functionCall.execute(this.session, this);
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        transporter.setObject(returnValue);
        return transporter;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    protected void initialize(AbstractSession session) {
        this.setSession(session);
        this.setRemoteValueHolders(new Hashtable<ObjID, ValueHolderInterface>(3));
        this.setRemoteCursors(new Hashtable<ObjID, Cursor>(3));
        this.setIsInTransaction(false);
    }

    public Transporter initializeIdentityMapsOnServerSession() {
        Transporter transporter = new Transporter();
        try {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter instantiateRemoteValueHolderOnServer(Transporter remoteTransporter) {
        remoteTransporter.expand(this.session);
        RemoteValueHolder clientValueHolder = (RemoteValueHolder)remoteTransporter.getObject();
        RemoteValueHolder serverValueHolder = (RemoteValueHolder)this.getRemoteValueHolders().get(clientValueHolder.getID());
        Transporter transporter = new Transporter();
        try {
            Object value = serverValueHolder.getMapping().getValueFromRemoteValueHolder(serverValueHolder);
            transporter.setObjectDescriptors(serverValueHolder.getMapping().replaceValueHoldersIn(value, this));
            if (value != null) {
                value.hashCode();
            }
            transporter.setObject(value);
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        transporter.prepare(this.session);
        return transporter;
    }

    protected boolean isInTransaction() {
        return this.isInTransaction;
    }

    public Map replaceValueHoldersIn(Object object) {
        IdentityHashMap result = new IdentityHashMap();
        this.replaceValueHoldersIn(object, result);
        return result;
    }

    public void replaceValueHoldersIn(Object object, Map objectDescriptors) {
        if (object == null) {
            return;
        }
        ReplaceValueHoldersIterator iterator = new ReplaceValueHoldersIterator(this);
        iterator.setResult(objectDescriptors);
        iterator.setSession(this.getExecutionSession());
        iterator.setShouldIterateOnIndirectionObjects(true);
        iterator.setShouldIterateOverIndirectionObjects(false);
        iterator.startIterationOn(object);
    }

    public Map replaceValueHoldersInAll(Object container, ContainerPolicy policy) {
        IdentityHashMap result = new IdentityHashMap();
        Object iter = policy.iteratorFor(container);
        while (policy.hasNext(iter)) {
            this.replaceValueHoldersIn(policy.next(iter, this.getSession()), result);
        }
        return result;
    }

    public Transporter rollbackTransaction() {
        Transporter transporter = new Transporter();
        try {
            this.getSession().rollbackTransaction();
            if (!this.getSession().isInTransaction()) {
                this.isInTransaction = false;
                this.isInEarlyTransaction = false;
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public void saveRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        this.getRemoteValueHolders().put(remoteValueHolder.getID(), remoteValueHolder);
    }

    public Transporter scrollableCursorAbsolute(Transporter remoteScrollableCursorOid, int rows) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                transporter.setObject(stream.absolute(rows));
            } else {
                transporter.setObject(Boolean.FALSE);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorAfterLast(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                stream.afterLast();
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorBeforeFirst(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                stream.beforeFirst();
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorClose(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                stream.close();
            }
            this.getRemoteCursors().remove(remoteScrollableCursorOid.getObject());
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorCurrentIndex(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                transporter.setObject(stream.currentIndex());
            } else {
                transporter.setObject(0);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorFirst(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                transporter.setObject(stream.first());
            } else {
                transporter.setObject(Boolean.FALSE);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorIsAfterLast(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                transporter.setObject(stream.isAfterLast());
            } else {
                transporter.setObject(Boolean.FALSE);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorIsBeforeFirst(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                transporter.setObject(stream.isBeforeFirst());
            } else {
                transporter.setObject(Boolean.FALSE);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorIsFirst(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                transporter.setObject(stream.isFirst());
            } else {
                transporter.setObject(Boolean.FALSE);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorIsLast(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                transporter.setObject(stream.isLast());
            } else {
                transporter.setObject(Boolean.FALSE);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorLast(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                transporter.setObject(stream.last());
            } else {
                transporter.setObject(Boolean.FALSE);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorNextObject(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                Object objectNext = null;
                if (stream.hasNext()) {
                    objectNext = stream.next();
                }
                if (objectNext == null) {
                    transporter.setObjectDescriptors(new IdentityHashMap());
                } else if (stream.getQuery().isReadAllQuery() && !stream.getQuery().isReportQuery()) {
                    transporter.setObjectDescriptors(this.replaceValueHoldersIn(objectNext));
                }
                transporter.setObject(objectNext);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorPreviousObject(Transporter remoteScrollableCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                Object objectPrevious = null;
                if (stream.hasPrevious()) {
                    objectPrevious = stream.previous();
                }
                if (objectPrevious == null) {
                    transporter.setObjectDescriptors(new IdentityHashMap());
                } else if (stream.getQuery().isReadAllQuery() && !stream.getQuery().isReportQuery()) {
                    transporter.setObjectDescriptors(this.replaceValueHoldersIn(objectPrevious));
                }
                transporter.setObject(objectPrevious);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorRelative(Transporter remoteScrollableCursorOid, int rows) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor stream = (ScrollableCursor)this.getRemoteCursors().get(remoteScrollableCursorOid.getObject());
            if (stream != null) {
                transporter.setObject(stream.relative(rows));
            } else {
                transporter.setObject(Boolean.FALSE);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    public Transporter scrollableCursorSize(Transporter remoteCursorOid) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor cursor = (ScrollableCursor)this.getRemoteCursors().get(remoteCursorOid.getObject());
            if (cursor != null) {
                transporter.setObject(cursor.size());
            } else {
                transporter.setObject(0);
            }
        }
        catch (RuntimeException exception) {
            transporter.setException(exception);
        }
        return transporter;
    }

    protected void setIsInTransaction(boolean isInTransaction) {
        this.isInTransaction = isInTransaction;
    }

    protected void setRemoteCursors(Map<ObjID, Cursor> remoteCursors) {
        this.remoteCursors = remoteCursors;
    }

    protected void setRemoteValueHolders(Map<ObjID, ValueHolderInterface> remoteValueHolders) {
        this.remoteValueHolders = remoteValueHolders;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    protected AbstractSession getExecutionSession() {
        AbstractSession executionSession = this.session;
        if (this.isInEarlyTransaction) {
            if (this.unitOfWork == null) {
                this.unitOfWork = this.session.acquireUnitOfWork();
                this.unitOfWork.setWasTransactionBegunPrematurely(true);
            }
            executionSession = this.unitOfWork;
        }
        return executionSession;
    }
}

