/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;

public class Util {
    public static final XMLPlatform XML_PLATFORM = XMLPlatformFactory.getInstance().getXMLPlatform();
    public static final Document TEMP_DOC = XML_PLATFORM.createDocument();
    public static final int OPAQUE = 2007;
    public static final String DEFAULT_ATTACHMENT_MIMETYPE = "application/octet-stream";
    public static final String WEB_INF_DIR = "WEB-INF/";
    public static final String WSDL_DIR = "wsdl/";
    public static final String[] META_INF_PATHS = new String[]{"META-INF/", "/META-INF/"};
    public static final String DBWS_SERVICE_XML = "eclipselink-dbws.xml";
    public static final String DBWS_OR_LABEL = "dbws-or";
    public static final String DBWS_OX_LABEL = "dbws-ox";
    public static final String DBWS_OR_XML = "eclipselink-dbws-or.xml";
    public static final String DBWS_OX_XML = "eclipselink-dbws-ox.xml";
    public static final String DBWS_SCHEMA_XML = "eclipselink-dbws-schema.xsd";
    public static final String DBWS_WSDL = "eclipselink-dbws.wsdl";
    public static final String DBWS_SESSIONS_XML = "eclipselink-dbws-sessions.xml";
    public static final String DBWS_OR_SESSION_NAME_SUFFIX = "dbws-or-session";
    public static final String DBWS_OX_SESSION_NAME_SUFFIX = "dbws-ox-session";
    public static final String TARGET_NAMESPACE_PREFIX = "ns1";
    public static final String SERVICE_NAMESPACE_PREFIX = "srvc";
    public static final String SERVICE_SUFFIX = "Service";
    public static final String ALL_QUERYNAME = "findAll";
    public static final String PK_QUERYNAME = "findByPrimaryKey";
    public static final String XMLTYPE_STR = "XMLTYPE";
    public static final String DOT_STR = ".";
    public static final String UNDERSCORE_STR = "_";
    public static final String TYPE_STR = "Type";
    public static final String COLLECTION_WRAPPER_STR = "CollectionWrapper";
    public static final String DASH_STR = "-";
    public static final String EMPTY_STR = "";
    public static final char COLON_CHAR = ':';
    public static final char SLASH_CHAR = '/';
    static final int[] chartype = new int[256];
    static final int FWHITESPACE = 1;
    static final int FDIGIT = 2;
    static final int FLETTER = 4;
    static final int FMISCNAME = 8;
    static final int FSTARTNAME = 16;
    public static final QName SXF_QNAME;
    public static final Map<QName, Class<?>> SCHEMA_2_CLASS;

    public static String sqlToXmlName(String name) {
        int length = name.length();
        if (length == 0) {
            return name;
        }
        StringBuilder xmlName = new StringBuilder();
        int beginAt = 1;
        char firstChar = name.charAt(0);
        if (firstChar == ':') {
            xmlName.append("_x003A_");
        } else if (length >= 2 && name.substring(0, 2).equals("_x")) {
            xmlName.append("_x005F_");
        } else if (firstChar >= '\ud800' && firstChar < '\udc00') {
            if (length > 1) {
                xmlName.append(Util.hexEscape(firstChar << 16 | name.charAt(1) & 0xFFFF));
                beginAt = 2;
            } else {
                xmlName.append(Util.hexEscape(firstChar));
            }
        } else if (Util.isFirstNameChar(firstChar)) {
            xmlName.append(firstChar);
        } else {
            xmlName.append(Util.hexEscape(firstChar));
        }
        for (int x = beginAt; x < length; ++x) {
            char c = name.charAt(x);
            if (c >= '\ud800' && c < '\udc00') {
                if (x + 1 < length) {
                    xmlName.append(Util.hexEscape(c << 16 | name.charAt(x + 1) & 0xFFFF));
                    ++x;
                    continue;
                }
                xmlName.append(Util.hexEscape(c));
                continue;
            }
            if (!Util.isNameChar(c)) {
                xmlName.append(Util.hexEscape(c));
                continue;
            }
            xmlName.append(c);
        }
        return xmlName.toString();
    }

    public static String xmlToSqlName(String name) {
        String sqlName = EMPTY_STR;
        int length = name.length();
        boolean unescapeMode = false;
        String hexString = null;
        for (int x = 0; x < length; ++x) {
            char c = name.charAt(x);
            if (unescapeMode) {
                if (c >= 'A' && c <= 'F' || c >= '0' && c <= '9') {
                    hexString = hexString + c;
                    continue;
                }
                if (c == '_') {
                    unescapeMode = false;
                    if (hexString == null) continue;
                    int len = hexString.length();
                    if (len > 4) {
                        char i1 = (char)Integer.parseInt(hexString.substring(0, len - 4), 16);
                        char i2 = (char)Integer.parseInt(hexString.substring(len - 4), 16);
                        sqlName = sqlName + i1;
                        sqlName = sqlName + i2;
                        continue;
                    }
                    try {
                        int i = Integer.parseInt(hexString, 16);
                        if (i == 65535) continue;
                        sqlName = sqlName + (char)i;
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new RuntimeException(nfe);
                    }
                }
                sqlName = sqlName + "_x" + hexString + c;
                unescapeMode = false;
                continue;
            }
            if (c == '_' && x + 1 < length && name.charAt(x + 1) == 'x') {
                unescapeMode = true;
                hexString = EMPTY_STR;
                ++x;
                continue;
            }
            sqlName = sqlName + c;
        }
        return sqlName;
    }

    public static String hexEscape(char c) {
        String outPutString = Integer.toHexString(c);
        switch (outPutString.length()) {
            case 1: {
                outPutString = "_x000" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 2: {
                outPutString = "_x00" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 3: {
                outPutString = "_x0" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 4: {
                outPutString = "_x" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
            }
        }
        return outPutString;
    }

    public static String hexEscape(int c) {
        String outPutString = Integer.toHexString(c);
        switch (outPutString.length()) {
            case 1: 
            case 5: {
                outPutString = "_x000" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 2: 
            case 6: {
                outPutString = "_x00" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 3: 
            case 7: {
                outPutString = "_x0" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 4: 
            case 8: {
                outPutString = "_x" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
            }
        }
        return outPutString;
    }

    public static boolean isNameChar(char c) {
        boolean res = c < '\u0100' ? (chartype[c] & 0xE) != 0 : (c >= '\u2180' && c <= '\u2182' || c >= '\u3041' && c <= '\u3094' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u3105' && c <= '\u312c' || c >= '\uac00' && c <= '\ud7a3' || c >= '\u0e47' && c <= '\u0e4e' ? true : c != '\u02ff' && c != '\u0346' && c != '\u0362' && c != '\u0487' && c != '\u05a2' && c != '\u05ba' && c != '\u05be' && c != '\u05c0' && c != '\u05c3' && c != '\u0653' && c != '\u06b8' && c != '\u06b9' && c != '\u06e9' && c != '\u06ee' && c != '\u0904' && c != '\u093b' && c != '\u094e' && c != '\u0955' && c != '\u0964' && c != '\u0984' && c != '\u09c5' && c != '\u09c9' && c != '\u09ce' && c != '\u09d8' && c != '\u09e4' && c != '\u0a03' && c != '\u0a3d' && c != '\u0a46' && c != '\u0a49' && c != '\u0a4e' && c != '\u0a80' && c != '\u0a84' && c != '\u0abb' && c != '\u0ac6' && c != '\u0aca' && c != '\u0ace' && c != '\u0b04' && c != '\u0b3b' && c != '\u0b44' && c != '\u0b4a' && c != '\u0b4e' && c != '\u0b58' && c != '\u0b84' && c != '\u0bc3' && c != '\u0bc9' && c != '\u0bd6' && c != '\u0c0d' && c != '\u0c45' && c != '\u0c49' && c != '\u0c54' && c != '\u0c81' && c != '\u0c84' && c != '\u0cc5' && c != '\u0cc9' && c != '\u0cd4' && c != '\u0cd7' && c != '\u0d04' && c != '\u0d45' && c != '\u0d49' && c != '\u0d4e' && c != '\u0d58' && c != '\u0e3f' && c != '\u0e3b' && c != '\u0e4f' && c != '\u0eba' && c != '\u0ebe' && c != '\u0ece' && c != '\u0f1a' && c != '\u0f36' && c != '\u0f38' && c != '\u0f3b' && c != '\u0f3a' && c != '\u0f70' && c != '\u0f85' && c != '\u0f8c' && c != '\u0f96' && c != '\u0f98' && c != '\u0fb0' && c != '\u0fb8' && c != '\u0fba' && c != '\u20dd' && c != '\u20e2' && c != '\u3030' && c != '\u309b' && c != '\u066a' && c != '\u06fa' && c != '\u0970' && c != '\u09f2' && c != '\u0af0' && c != '\u0b70' && c != '\u0c65' && c != '\u0ce5' && c != '\u0cf0' && c != '\u0d70' && c != '\u0e5a' && c != '\u0eda' && c != '\u0f2a' && c != '\u02d2' && c != '\u03fe' && c != '\u065f' && c != '\u0e5c' && c != '\u0c04');
        return res;
    }

    public static boolean isFirstNameChar(char c) {
        boolean res = c < '\u0100' ? (chartype[c] & 0x14) != 0 : (c >= '\u2180' && c <= '\u2182' || c == '\u3007' || c >= '\u3021' && c <= '\u3029' || c >= '\u3041' && c <= '\u3094' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u3105' && c <= '\u312c' || c >= '\uac00' && c <= '\ud7a3' ? true : c != '\u1101' && c != '\u1104' && c != '\u1108' && c != '\u110a' && c != '\u110d' && c != '\u113b' && c != '\u1141' && c != '\u114d' && c != '\u114f' && c != '\u1151' && c != '\u1156' && c != '\u1162' && c != '\u1164' && c != '\u1166' && c != '\u116b' && c != '\u116f' && c != '\u1174' && c != '\u119f' && c != '\u11ac' && c != '\u11b6' && c != '\u11b9' && c != '\u11bb' && c != '\u11c3' && c != '\u11f1' && c != '\u0132' && c != '\u0133' && c != '\u013f' && c != '\u0140' && c != '\u0149' && c != '\u017f' && c != '\u01c4' && c != '\u01cc' && c != '\u01f1' && c != '\u01f3' && c != '\u0e46' && c != '\u113f' && c != '\u01f6' && c != '\u01f9' && c != '\u0230' && c != '\u03d7' && c != '\u03dd' && c != '\u03e1' && c != '\u040d' && c != '\u0450' && c != '\u045d' && c != '\u04ec' && c != '\u04ed' && c != '\u06b8' && c != '\u06bf' && c != '\u06cf' && c != '\u0e2f' && c != '\u0eaf' && c != '\u0f6a' && c != '\u4cff' && c != '\u212f' && c != '\u0587');
        return res;
    }

    public static Class<?> getClassFromJDBCType(String typeName, DatabasePlatform databasePlatform) {
        Class clz = databasePlatform.getClassTypes().get(typeName);
        if (clz == null) {
            return ClassConstants.Object_Class;
        }
        return clz;
    }

    public static String getTypeNameForJDBCType(int jdbcType) {
        String typeName = null;
        switch (jdbcType) {
            case 2007: 
            case 2009: {
                typeName = XMLTYPE_STR;
                break;
            }
        }
        return typeName;
    }

    public static int getJDBCTypeForTypeName(String typeName) {
        int typeCode = -1;
        if (typeName.equals(XMLTYPE_STR)) {
            typeCode = 2007;
        }
        return typeCode;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            Util.chartype[i] = 0;
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                Util.chartype[i] = 1;
            }
            if (Character.isLetter(c)) {
                int n = i;
                chartype[n] = chartype[n] | 4;
            }
            if (!Character.isDigit(c)) continue;
            int n = i;
            chartype[n] = chartype[n] | 2;
        }
        chartype[46] = chartype[46] | 8;
        chartype[45] = chartype[45] | 8;
        chartype[95] = chartype[95] | 0x18;
        chartype[183] = chartype[183] | 8;
        SXF_QNAME = new QName(EMPTY_STR, "simple-xml-format");
        SCHEMA_2_CLASS = Collections.unmodifiableMap(new HashMap<QName, Class<?>>(){
            {
                this.put(Constants.ANY_SIMPLE_TYPE_QNAME, ClassConstants.Object_Class);
                this.put(Constants.BASE_64_BINARY_QNAME, ClassConstants.APBYTE);
                this.put(Constants.BOOLEAN_QNAME, ClassConstants.BOOLEAN);
                this.put(Constants.BYTE_QNAME, ClassConstants.BYTE);
                this.put(Constants.DATE_QNAME, ClassConstants.CALENDAR);
                this.put(Constants.DATE_TIME_QNAME, ClassConstants.CALENDAR);
                this.put(Constants.DECIMAL_QNAME, ClassConstants.BIGDECIMAL);
                this.put(Constants.DOUBLE_QNAME, ClassConstants.DOUBLE);
                this.put(Constants.DURATION_QNAME, ClassConstants.STRING);
                this.put(Constants.FLOAT_QNAME, ClassConstants.FLOAT);
                this.put(Constants.G_YEAR_MONTH_QNAME, ClassConstants.STRING);
                this.put(Constants.G_YEAR_QNAME, ClassConstants.STRING);
                this.put(Constants.G_MONTH_QNAME, ClassConstants.STRING);
                this.put(Constants.G_MONTH_DAY_QNAME, ClassConstants.STRING);
                this.put(Constants.G_DAY_QNAME, ClassConstants.STRING);
                this.put(Constants.HEX_BINARY_QNAME, ClassConstants.APBYTE);
                this.put(Constants.INT_QNAME, ClassConstants.INTEGER);
                this.put(Constants.INTEGER_QNAME, ClassConstants.BIGINTEGER);
                this.put(Constants.LONG_QNAME, ClassConstants.LONG);
                this.put(Constants.QNAME_QNAME, QName.class);
                this.put(Constants.SHORT_QNAME, ClassConstants.SHORT);
                this.put(Constants.STRING_QNAME, ClassConstants.STRING);
                this.put(Constants.TIME_QNAME, ClassConstants.CALENDAR);
                this.put(Constants.UNSIGNED_BYTE_QNAME, ClassConstants.SHORT);
                this.put(Constants.UNSIGNED_INT_QNAME, ClassConstants.LONG);
                this.put(Constants.UNSIGNED_SHORT_QNAME, ClassConstants.INTEGER);
            }
        });
    }
}

