/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import oracle.kv.ReturnValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.RowReaderImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.ValueReader;
import oracle.kv.impl.api.table.ValueSerializer;
import oracle.kv.table.RecordDef;
import oracle.kv.table.ReturnRow;

public class ReturnRowImpl
extends RowImpl
implements ReturnRow {
    private static final long serialVersionUID = 1L;
    private final ReturnRow.Choice returnChoice;

    ReturnRowImpl(RecordDef field, TableImpl table, ReturnRow.Choice returnChoice) {
        super(field, table);
        this.returnChoice = returnChoice;
    }

    private ReturnRowImpl(ReturnRowImpl other) {
        super(other);
        this.returnChoice = other.returnChoice;
    }

    @Override
    public ReturnRow.Choice getReturnChoice() {
        return this.returnChoice;
    }

    @Override
    public ReturnRowImpl clone() {
        return new ReturnRowImpl(this);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof ReturnRowImpl) {
            ReturnRowImpl otherImpl = (ReturnRowImpl)other;
            return this.returnChoice == otherImpl.returnChoice;
        }
        return false;
    }

    static ReturnValueVersion.Choice mapChoice(ReturnRow.Choice choice) {
        if (choice == null) {
            return ReturnValueVersion.Choice.NONE;
        }
        switch (choice) {
            case VALUE: {
                return ReturnValueVersion.Choice.VALUE;
            }
            case VERSION: {
                return ReturnValueVersion.Choice.VERSION;
            }
            case ALL: {
                return ReturnValueVersion.Choice.ALL;
            }
            case NONE: {
                return ReturnValueVersion.Choice.NONE;
            }
        }
        throw new IllegalStateException("Unknown choice: " + (Object)((Object)choice));
    }

    ReturnValueVersion makeReturnValueVersion() {
        return new ReturnValueVersion(ReturnRowImpl.mapChoice(this.returnChoice));
    }

    void init(TableAPIImpl impl, ReturnValueVersion rvv, ValueSerializer.RowSerializer key, long prevExpirationTime, ValueReader<?> reader) {
        if ((this.returnChoice == ReturnRow.Choice.VALUE || this.returnChoice == ReturnRow.Choice.ALL) && rvv.getValue() != null) {
            RowImpl newRow;
            this.table.readKeyFields(reader, key);
            impl.getRowFromValueVersion(rvv, key, prevExpirationTime, false, reader);
            if (reader instanceof RowReaderImpl && (newRow = (RowImpl)reader.getValue()).getTableVersion() != this.getTableVersion()) {
                this.copyFrom(newRow, true);
                this.setTableVersion(newRow.getTableVersion());
            }
        }
        reader.setExpirationTime(prevExpirationTime);
        reader.setVersion(rvv.getVersion());
    }

    @Override
    public void setVersion(Version version) {
        super.setVersion(this.returnChoice == ReturnRow.Choice.VALUE ? null : version);
    }
}

