/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Stack;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprMapFilter;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class MapFilterIter
extends PlanIter {
    private final ExprMapFilter.FilterKind theKind;
    private final PlanIter theInput;
    private final PlanIter thePredIter;
    private final int theCtxItemReg;
    private final int theCtxElemReg;
    private final int theCtxKeyReg;

    public MapFilterIter(Expr e, int resultReg, PlanIter input, PlanIter predIter, int ctxItemReg, int ctxElemReg, int ctxKeyReg) {
        super(e, resultReg);
        this.theKind = ((ExprMapFilter)e).getFilterKind();
        this.theInput = input;
        this.thePredIter = predIter;
        this.theCtxItemReg = ctxItemReg;
        this.theCtxElemReg = ctxElemReg;
        this.theCtxKeyReg = ctxKeyReg;
    }

    MapFilterIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = MapFilterIter.readOrdinal(in, ExprMapFilter.FilterKind.values().length);
        this.theKind = ExprMapFilter.FilterKind.values()[ordinal];
        this.theInput = MapFilterIter.deserializeIter(in, serialVersion);
        this.thePredIter = MapFilterIter.deserializeIter(in, serialVersion);
        this.theCtxItemReg = MapFilterIter.readPositiveInt(in, true);
        this.theCtxElemReg = MapFilterIter.readPositiveInt(in, true);
        this.theCtxKeyReg = MapFilterIter.readPositiveInt(in, true);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theKind.ordinal());
        MapFilterIter.serializeIter(this.theInput, out, serialVersion);
        MapFilterIter.serializeIter(this.thePredIter, out, serialVersion);
        out.writeInt(this.theCtxItemReg);
        out.writeInt(this.theCtxElemReg);
        out.writeInt(this.theCtxKeyReg);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.MAP_FILTER;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new MapFilterState(this));
        this.theInput.open(rcb);
        if (this.thePredIter != null) {
            this.thePredIter.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        MapFilterState state = (MapFilterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (state.theComputePredOnce && state.isOpen()) {
            state.setState(PlanIterState.StateEnum.RUNNING);
            this.computePredExpr(rcb, state);
            if (!state.thePredValue) {
                state.done();
                return false;
            }
        }
        while (true) {
            FieldValueImpl ctxItem = null;
            if (state.theCtxItem != null && !state.theCtxItem.isNull()) {
                boolean done = true;
                if (state.theCtxItem.isMap()) {
                    MapValueImpl map = (MapValueImpl)state.theCtxItem;
                    if (state.theKeysIter.hasNext()) {
                        done = false;
                        state.theFieldPos = -1;
                        state.theCtxKey = state.theKeysIter.next();
                        if (this.theCtxElemReg >= 0 || this.theKind == ExprMapFilter.FilterKind.VALUES) {
                            state.theCtxElem = map.get(state.theCtxKey);
                        }
                    }
                } else {
                    RecordValueImpl rec = (RecordValueImpl)state.theCtxItem;
                    if (state.theFieldPos < rec.getNumFields()) {
                        done = false;
                        state.theCtxKey = rec.getFieldName(state.theFieldPos);
                        if (this.theCtxElemReg >= 0 || this.theKind == ExprMapFilter.FilterKind.VALUES) {
                            state.theCtxElem = rec.get(state.theFieldPos);
                        }
                        ++state.theFieldPos;
                    }
                }
                if (!done) {
                    if (state.theComputePredPerElem) {
                        this.computePredExpr(rcb, state);
                        if (!state.thePredValue) continue;
                    }
                    FieldValueImpl result = this.theKind == ExprMapFilter.FilterKind.KEYS ? FieldDefImpl.stringDef.createString(state.theCtxKey) : state.theCtxElem;
                    rcb.setRegVal(this.theResultReg, result);
                    return true;
                }
                state.theCtxItem = null;
            }
            if (state.theArrays.isEmpty()) {
                boolean more = this.theInput.next(rcb);
                if (!more) {
                    state.done();
                    return false;
                }
                int inputReg = this.theInput.getResultReg();
                ctxItem = rcb.getRegVal(inputReg);
                if (ctxItem.isAtomic()) continue;
                if (ctxItem.isNull()) {
                    state.theCtxItem = ctxItem;
                    rcb.setRegVal(this.theResultReg, ctxItem);
                    return true;
                }
            } else {
                ArrayAndPos arrayCtx = state.theArrays.peek();
                ArrayValueImpl array = arrayCtx.theArray;
                ctxItem = array.getElement(arrayCtx.thePos);
                ++arrayCtx.thePos;
                if (arrayCtx.thePos >= array.size()) {
                    state.theArrays.pop();
                }
                if (ctxItem.isAtomic()) continue;
            }
            if (ctxItem.isArray()) {
                ArrayValueImpl array = (ArrayValueImpl)ctxItem;
                if (array.size() <= 0) continue;
                ArrayAndPos arrayCtx = new ArrayAndPos(array);
                state.theArrays.push(arrayCtx);
                continue;
            }
            if (ctxItem.isRecord()) {
                state.theFieldPos = 0;
                state.theCtxItem = ctxItem;
            } else if (ctxItem.isMap()) {
                MapValueImpl map = (MapValueImpl)ctxItem;
                state.theKeysIter = map.getMap().keySet().iterator();
                state.theCtxItem = ctxItem;
            } else {
                throw new QueryStateException("Unexpected kind of item" + ctxItem);
            }
            if (!state.theComputePredPerMap) continue;
            this.computePredExpr(rcb, state);
            if (state.thePredValue) continue;
            state.theCtxItem = null;
        }
    }

    void computePredExpr(RuntimeControlBlock rcb, MapFilterState state) {
        boolean more;
        if (this.thePredIter == null) {
            state.thePredValue = true;
            return;
        }
        this.thePredIter.reset(rcb);
        if (this.theCtxItemReg >= 0) {
            rcb.setRegVal(this.theCtxItemReg, state.theCtxItem);
        }
        if (this.theCtxElemReg >= 0) {
            rcb.setRegVal(this.theCtxElemReg, state.theCtxElem);
        }
        if (this.theCtxKeyReg >= 0) {
            rcb.setRegVal(this.theCtxKeyReg, FieldDefImpl.stringDef.createString(state.theCtxKey));
        }
        if (!(more = this.thePredIter.next(rcb))) {
            state.thePredValue = false;
        } else {
            FieldValueImpl val = rcb.getRegVal(this.thePredIter.getResultReg());
            if (val.isNull()) {
                state.thePredValue = false;
            } else if (val.isBoolean()) {
                state.thePredValue = val.getBoolean();
            } else {
                throw new QueryException("Predicate expression in map filter has invalid type:\n" + val.getDefinition().getDDLString(), this.getLocation());
            }
        }
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
        if (this.thePredIter != null) {
            this.thePredIter.reset(rcb);
        }
        MapFilterState state = (MapFilterState)rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        MapFilterState state = (MapFilterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        if (this.thePredIter != null) {
            this.thePredIter.close(rcb);
        }
        state.close();
    }

    @Override
    void getParentItemContext(RuntimeControlBlock rcb, PlanIter.ParentItemContext ctx) {
        MapFilterState state = (MapFilterState)rcb.getState(this.theStatePos);
        ctx.theParentItem = state.theCtxItem;
        ctx.theTargetPos = state.theFieldPos - 1;
        ctx.theTargetKey = state.theCtxKey;
    }

    @Override
    void displayName(StringBuilder sb) {
        sb.append((Object)this.theKind);
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
        if (this.thePredIter != null) {
            sb.append(",\n");
            this.thePredIter.display(sb, formatter);
        }
        if (this.theCtxItemReg >= 0) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("theCtxItemReg : ").append(this.theCtxItemReg);
        }
        if (this.theCtxElemReg >= 0) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("theCtxElemReg : ").append(this.theCtxElemReg);
        }
        if (this.theCtxKeyReg >= 0) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("theCtxKeyReg : ").append(this.theCtxKeyReg);
        }
    }

    private static class MapFilterState
    extends PlanIterState {
        FieldValueImpl theCtxItem;
        int theFieldPos;
        Iterator<String> theKeysIter;
        String theCtxKey;
        FieldValueImpl theCtxElem;
        Stack<ArrayAndPos> theArrays = new Stack();
        boolean thePredValue;
        boolean theComputePredOnce;
        boolean theComputePredPerMap;
        boolean theComputePredPerElem;

        MapFilterState(MapFilterIter iter) {
            this.theComputePredOnce = iter.theCtxItemReg < 0 && iter.theCtxElemReg < 0 && iter.theCtxKeyReg < 0;
            this.theComputePredPerMap = iter.theCtxItemReg >= 0 && iter.theCtxElemReg < 0 && iter.theCtxKeyReg < 0;
            this.theComputePredPerElem = iter.theCtxElemReg >= 0 || iter.theCtxKeyReg >= 0;
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theCtxItem = null;
            this.theFieldPos = 0;
            this.theKeysIter = null;
            if (this.theArrays != null) {
                this.theArrays.clear();
            }
        }

        @Override
        public void close() {
            super.close();
            this.theCtxItem = null;
            this.theKeysIter = null;
            this.theArrays = null;
            this.theCtxKey = null;
            this.theCtxElem = null;
        }
    }

    private static class ArrayAndPos {
        ArrayValueImpl theArray;
        int thePos;

        ArrayAndPos(ArrayValueImpl array) {
            this.theArray = array;
            this.thePos = 0;
        }
    }
}

