/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.tools.logex;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.glassfish.pfl.basic.logex.ExceptionWrapper;
import org.glassfish.pfl.basic.logex.WrapperGenerator;
import org.glassfish.pfl.basic.tools.argparser.ArgParser;
import org.glassfish.pfl.basic.tools.argparser.DefaultValue;
import org.glassfish.pfl.basic.tools.argparser.Help;
import org.glassfish.pfl.basic.tools.file.FileWrapper;
import org.glassfish.pfl.basic.tools.file.Scanner;

public class ExceptionResourceGenerator {
    private final Arguments args;
    Scanner.Action action = new Scanner.Action(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evaluate(FileWrapper arg) {
            String fileName = arg.getAbsoluteName();
            if (fileName.endsWith(".class")) {
                String absSourceName = ExceptionResourceGenerator.this.args.source().getAbsolutePath();
                String relArgName = fileName.substring(absSourceName.length() + 1, fileName.length() - ".class".length());
                File output = new File(ExceptionResourceGenerator.this.args.destination(), relArgName + ".properties");
                FileWrapper dest = new FileWrapper(output);
                String className = relArgName.replace(File.separatorChar, '.');
                ExceptionWrapper ew = null;
                try {
                    Class<?> cls = Class.forName(className);
                    ew = cls.getAnnotation(ExceptionWrapper.class);
                    if (ew != null) {
                        if (ExceptionResourceGenerator.this.args.verbose() > 0) {
                            ExceptionResourceGenerator.this.msg("Writing resource file for class " + cls.getName());
                        }
                        List<String> resStrings = ExceptionResourceGenerator.getResources(cls);
                        dest.open(FileWrapper.OpenMode.WRITE_EMPTY);
                        dest.writeLine("### Resource file generated on " + new Date());
                        dest.writeLine("#");
                        dest.writeLine("# Resources for class " + className);
                        dest.writeLine("#");
                        if (resStrings != null) {
                            for (String str : resStrings) {
                                dest.writeLine(str);
                            }
                        }
                    }
                }
                catch (Exception exc) {
                    if (ExceptionResourceGenerator.this.args.verbose() > 0) {
                        ExceptionResourceGenerator.this.msg("Error in processing class " + className);
                        exc.printStackTrace();
                    }
                }
                finally {
                    if (ew != null) {
                        dest.close();
                    }
                }
            }
            return true;
        }
    };

    private ExceptionResourceGenerator(String[] strs) throws IOException {
        ArgParser ap = new ArgParser(Arguments.class);
        this.args = ap.parse(strs, Arguments.class);
        this.args.destination().delete();
    }

    private void msg(String string) {
        System.out.println(string);
    }

    private static String getLoggerName(Class<?> cls) {
        ExceptionWrapper ew = cls.getAnnotation(ExceptionWrapper.class);
        String str = ew.loggerName();
        if (str.length() == 0) {
            str = cls.getPackage().getName();
        }
        return str;
    }

    public static List<String> getResources(Class<?> cls) {
        WrapperGenerator.MessageInfo minfo;
        Field self;
        if (cls.getAnnotation(ExceptionWrapper.class) == null) {
            throw new RuntimeException(cls + " does not have an @ExceptionWrapper annotation");
        }
        try {
            self = cls.getDeclaredField("self");
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not get field named self in " + cls, ex);
        }
        int mod = self.getModifiers();
        if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod)) {
            throw new RuntimeException(cls + " is not public static");
        }
        if (!self.getType().equals(cls)) {
            throw new RuntimeException(cls.getName() + ".self does not have the correct type");
        }
        try {
            minfo = (WrapperGenerator.MessageInfo)self.get(null);
        }
        catch (Exception exc) {
            throw new RuntimeException("Could not access field self in " + cls, exc);
        }
        Map mmap = minfo.getMessageInfo();
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : mmap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append((String)entry.getKey());
            sb.append("=\"");
            sb.append((String)entry.getValue());
            sb.append("\"");
            result.add(sb.toString());
        }
        return result;
    }

    private void run() throws IOException {
        Scanner scanner = new Scanner(this.args.verbose(), this.args.source());
        scanner.scan(this.action);
    }

    public static void main(String[] strs) throws IOException {
        new ExceptionResourceGenerator(strs).run();
    }

    private static interface Arguments {
        @Help(value="Set to >0 to get information about actions taken for every file.  Larger values give more detail.")
        @DefaultValue(value="0")
        public int verbose();

        @Help(value="Source directory for classes to scan")
        @DefaultValue(value="")
        public File source();

        @Help(value="Destination file for resources")
        @DefaultValue(value="")
        public File destination();
    }
}

