/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAbstractNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlMarshalNullRepresentation;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNsForm;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchema;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchemaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlType;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.IsSetNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;

public class XmlBindingsGenerator {
    public static final String SIMPLE_XML_FORMAT_PKG = "org.eclipse.persistence.internal.xr.sxf";
    public static final String DATAHANDLER_CLASSNAME = "jakarta.activation.DataHandler";

    public static List<XmlBindings> generateXmlBindings(List<ClassDescriptor> descriptors) {
        HashMap<String, ArrayList<XMLDescriptor>> descriptorMap = new HashMap<String, ArrayList<XMLDescriptor>>();
        for (ClassDescriptor cdesc : descriptors) {
            XMLDescriptor xdesc = (XMLDescriptor)cdesc;
            String packageName = XmlBindingsGenerator.getPackageName(xdesc.getJavaClassName());
            if (packageName.equals(SIMPLE_XML_FORMAT_PKG)) continue;
            ArrayList<XMLDescriptor> descriptorList = (ArrayList<XMLDescriptor>)descriptorMap.get(packageName);
            if (descriptorList == null) {
                descriptorList = new ArrayList<XMLDescriptor>();
                descriptorMap.put(packageName, descriptorList);
            }
            descriptorList.add(xdesc);
        }
        ArrayList<XmlBindings> bindingsList = new ArrayList<XmlBindings>();
        for (String pkg : descriptorMap.keySet()) {
            List xdescList;
            XmlBindings xmlBindings = XmlBindingsGenerator.generateXmlBindings(pkg, xdescList = (List)descriptorMap.get(pkg));
            if (xmlBindings == null) continue;
            bindingsList.add(xmlBindings);
        }
        return bindingsList;
    }

    public static XmlBindings generateXmlBindings(String packageName, List<XMLDescriptor> descriptors) {
        String defaultNamespace = null;
        HashMap prefixMap = new HashMap();
        XmlBindings.JavaTypes jTypes = new XmlBindings.JavaTypes();
        for (XMLDescriptor xdesc : descriptors) {
            if (xdesc.getNamespaceResolver() != null) {
                if (defaultNamespace == null) {
                    defaultNamespace = xdesc.getNamespaceResolver().getDefaultNamespaceURI();
                }
                Map preMap = xdesc.getNamespaceResolver().getPrefixesToNamespaces();
                for (String pfx : preMap.keySet()) {
                    if (pfx.equals("xmime")) continue;
                    prefixMap.put(pfx, preMap.get(pfx));
                }
            }
            jTypes.getJavaType().add(XmlBindingsGenerator.generateJavaType(xdesc));
        }
        XmlBindings xmlBindings = null;
        if (jTypes.getJavaType().size() > 0) {
            xmlBindings = new XmlBindings();
            xmlBindings.setJavaTypes(jTypes);
            xmlBindings.setPackageName(packageName);
            if (defaultNamespace != null || !prefixMap.isEmpty()) {
                XmlSchema xSchema = new XmlSchema();
                xSchema.setNamespace(defaultNamespace == null ? "" : defaultNamespace);
                xSchema.setElementFormDefault(XmlNsForm.QUALIFIED);
                if (!prefixMap.isEmpty()) {
                    for (String pfx : prefixMap.keySet()) {
                        XmlSchema.XmlNs xmlNs = new XmlSchema.XmlNs();
                        xmlNs.setNamespaceUri((String)prefixMap.get(pfx));
                        xmlNs.setPrefix(pfx);
                        xSchema.getXmlNs().add(xmlNs);
                    }
                }
                xmlBindings.setXmlSchema(xSchema);
            }
        }
        return xmlBindings;
    }

    protected static JavaType generateJavaType(XMLDescriptor xdesc) {
        String defaultNamespace = null;
        if (xdesc.getNamespaceResolver() != null) {
            defaultNamespace = xdesc.getNamespaceResolver().getDefaultNamespaceURI();
        }
        String schemaContext = null;
        if (xdesc.getSchemaReference() != null) {
            schemaContext = xdesc.getSchemaReference().getSchemaContext();
        }
        JavaType jType = new JavaType();
        jType.setName(XmlBindingsGenerator.getClassName(xdesc.getJavaClassName()));
        jType.setXmlAccessorType(XmlAccessType.FIELD);
        if (schemaContext != null) {
            XmlType xType = new XmlType();
            xType.setName(schemaContext.substring(1, schemaContext.length()));
            if (defaultNamespace != null) {
                xType.setNamespace(defaultNamespace);
            }
            jType.setXmlType(xType);
        }
        XmlRootElement xmlRootElt = new XmlRootElement();
        xmlRootElt.setName(xdesc.getDefaultRootElement());
        if (defaultNamespace != null) {
            xmlRootElt.setNamespace(defaultNamespace);
        }
        jType.setXmlRootElement(xmlRootElt);
        jType.setJavaAttributes(new JavaType.JavaAttributes());
        for (XMLMapping xMap : xdesc.getMappings()) {
            if (((XMLField)xMap.getField()).getXPathFragment().isAttribute()) {
                JAXBElement<XmlAttribute> jAtt = XmlBindingsGenerator.generateXmlAttribute(xMap);
                if (jAtt == null) continue;
                jType.getJavaAttributes().getJavaAttribute().add(jAtt);
                continue;
            }
            JAXBElement<XmlElement> jElt = XmlBindingsGenerator.generateXmlElement(xMap);
            if (jElt == null) continue;
            jType.getJavaAttributes().getJavaAttribute().add(jElt);
        }
        return jType;
    }

    protected static JAXBElement<XmlAttribute> generateXmlAttribute(XMLMapping xmap) {
        XmlAttribute xAtt = null;
        if (xmap instanceof XMLDirectMapping) {
            xAtt = xmap instanceof XMLBinaryDataMapping ? XmlBindingsGenerator.processXMLBinaryDataMappingAttribute((XMLBinaryDataMapping)xmap) : XmlBindingsGenerator.processXMLDirectMappingAttribute((XMLDirectMapping)xmap);
        } else if (xmap instanceof XMLCompositeDirectCollectionMapping) {
            xAtt = XmlBindingsGenerator.processXMLCompositeDirectCollectionMappingAttribute((XMLCompositeDirectCollectionMapping)xmap);
        }
        if (xAtt == null) {
            return null;
        }
        return new JAXBElement(new QName("http://www.eclipse.org/eclipselink/xsds/persistence/oxm", "xml-attribute"), XmlAttribute.class, (Object)xAtt);
    }

    protected static JAXBElement<XmlElement> generateXmlElement(XMLMapping xmap) {
        XmlElement xElt = null;
        if (xmap instanceof XMLCompositeObjectMapping) {
            xElt = XmlBindingsGenerator.processXMLCompositeObjectMapping((XMLCompositeObjectMapping)xmap);
        } else if (xmap instanceof XMLCompositeCollectionMapping) {
            xElt = XmlBindingsGenerator.processXMLCompositeCollectionMapping((XMLCompositeCollectionMapping)xmap);
        } else if (xmap instanceof XMLCompositeDirectCollectionMapping) {
            xElt = XmlBindingsGenerator.processXMLCompositeDirectCollectionMapping((XMLCompositeDirectCollectionMapping)xmap);
        } else if (xmap instanceof XMLDirectMapping) {
            xElt = xmap instanceof XMLBinaryDataMapping ? XmlBindingsGenerator.processXMLBinaryDataMapping((XMLBinaryDataMapping)xmap) : XmlBindingsGenerator.processXMLDirectMapping((XMLDirectMapping)xmap);
        }
        if (xElt == null) {
            return null;
        }
        return new JAXBElement(new QName("http://www.eclipse.org/eclipselink/xsds/persistence/oxm", "xml-element"), XmlElement.class, (Object)xElt);
    }

    protected static XmlAttribute processXMLMapping(XMLField xfld, String attName, String xpath, String attClassification, AbstractNullPolicy nullPolicy, String containerName, boolean inlineBinary, boolean isSWARef, String mimeType) {
        QName schemaType;
        XmlAttribute xAtt = new XmlAttribute();
        xAtt.setJavaAttribute(attName);
        xAtt.setXmlPath(xpath);
        if (xfld.isRequired()) {
            xAtt.setRequired(Boolean.valueOf(true));
        }
        if (inlineBinary) {
            xAtt.setXmlInlineBinaryData(Boolean.valueOf(true));
        }
        if (isSWARef) {
            xAtt.setXmlAttachmentRef(Boolean.valueOf(true));
        }
        if (attClassification != null) {
            xAtt.setType(attClassification);
        }
        if (containerName != null) {
            xAtt.setContainerType(containerName);
        }
        if (mimeType != null) {
            xAtt.setXmlMimeType(mimeType);
        }
        if ((schemaType = xfld.getSchemaType()) != null) {
            XmlSchemaType xSchemaType = new XmlSchemaType();
            xSchemaType.setName(schemaType.getLocalPart());
            xAtt.setXmlSchemaType(xSchemaType);
        }
        if (!XmlBindingsGenerator.isDefaultNullPolicy(nullPolicy)) {
            XmlNullPolicy xmlNullPolicy;
            if (nullPolicy instanceof NullPolicy) {
                xmlNullPolicy = new XmlNullPolicy();
                xmlNullPolicy.setIsSetPerformedForAbsentNode(Boolean.valueOf(nullPolicy.getIsSetPerformedForAbsentNode()));
            } else {
                xmlNullPolicy = new XmlIsSetNullPolicy();
            }
            xmlNullPolicy.setEmptyNodeRepresentsNull(Boolean.valueOf(nullPolicy.isNullRepresentedByEmptyNode()));
            xmlNullPolicy.setXsiNilRepresentsNull(Boolean.valueOf(nullPolicy.isNullRepresentedByXsiNil()));
            xmlNullPolicy.setNullRepresentationForXml(XmlMarshalNullRepresentation.fromValue((String)nullPolicy.getMarshalNullRepresentation().toString()));
            xAtt.setXmlAbstractNullPolicy(new JAXBElement(new QName("http://www.eclipse.org/eclipselink/xsds/persistence/oxm", "xml-null-policy"), XmlAbstractNullPolicy.class, (Object)xmlNullPolicy));
        }
        return xAtt;
    }

    protected static XmlAttribute processXMLBinaryDataMappingAttribute(XMLBinaryDataMapping xmap) {
        String attClassName = xmap.getAttributeClassificationName();
        if (xmap.isSwaRef()) {
            attClassName = DATAHANDLER_CLASSNAME;
        }
        return XmlBindingsGenerator.processXMLMapping((XMLField)xmap.getField(), xmap.getAttributeName(), xmap.getXPath(), attClassName, xmap.getNullPolicy(), null, xmap.shouldInlineBinaryData(), xmap.isSwaRef(), xmap.getMimeType());
    }

    protected static XmlAttribute processXMLCompositeDirectCollectionMappingAttribute(XMLCompositeDirectCollectionMapping xmap) {
        return XmlBindingsGenerator.processXMLMapping((XMLField)xmap.getField(), xmap.getAttributeName(), xmap.getXPath(), null, xmap.getNullPolicy(), xmap.getContainerPolicy().getContainerClassName(), false, false, null);
    }

    protected static XmlAttribute processXMLDirectMappingAttribute(XMLDirectMapping xmap) {
        return XmlBindingsGenerator.processXMLMapping((XMLField)xmap.getField(), xmap.getAttributeName(), xmap.getXPath(), xmap.getAttributeClassificationName(), xmap.getNullPolicy(), null, false, false, null);
    }

    protected static XmlElement processXMLMapping(XMLField xfld, String attName, String xpath, String attClassification, AbstractNullPolicy nullPolicy, boolean isCDATA, String containerName, boolean inlineBinary, boolean isSWARef, String mimeType) {
        QName schemaType;
        XmlElement xElt = new XmlElement();
        xElt.setJavaAttribute(attName);
        xElt.setXmlPath(xpath);
        if (xfld.isRequired()) {
            xElt.setRequired(Boolean.valueOf(true));
        }
        if (isCDATA) {
            xElt.setCdata(Boolean.valueOf(true));
        }
        if (inlineBinary) {
            xElt.setXmlInlineBinaryData(Boolean.valueOf(true));
        }
        if (isSWARef) {
            xElt.setXmlAttachmentRef(Boolean.valueOf(true));
        }
        if (attClassification != null) {
            xElt.setType(attClassification);
        }
        if (containerName != null) {
            xElt.setContainerType(containerName);
        }
        if (mimeType != null) {
            xElt.setXmlMimeType(mimeType);
        }
        if ((schemaType = xfld.getSchemaType()) != null) {
            XmlSchemaType xSchemaType = new XmlSchemaType();
            xSchemaType.setName(schemaType.getLocalPart());
            xElt.setXmlSchemaType(xSchemaType);
        }
        if (!XmlBindingsGenerator.isDefaultNullPolicy(nullPolicy)) {
            XmlNullPolicy xmlNullPolicy;
            if (nullPolicy instanceof NullPolicy) {
                xmlNullPolicy = new XmlNullPolicy();
                xmlNullPolicy.setIsSetPerformedForAbsentNode(Boolean.valueOf(nullPolicy.getIsSetPerformedForAbsentNode()));
            } else {
                xmlNullPolicy = new XmlIsSetNullPolicy();
            }
            xmlNullPolicy.setEmptyNodeRepresentsNull(Boolean.valueOf(nullPolicy.isNullRepresentedByEmptyNode()));
            xmlNullPolicy.setXsiNilRepresentsNull(Boolean.valueOf(nullPolicy.isNullRepresentedByXsiNil()));
            xmlNullPolicy.setNullRepresentationForXml(XmlMarshalNullRepresentation.fromValue((String)nullPolicy.getMarshalNullRepresentation().toString()));
            xElt.setXmlAbstractNullPolicy(new JAXBElement(new QName("http://www.eclipse.org/eclipselink/xsds/persistence/oxm", "xml-null-policy"), XmlAbstractNullPolicy.class, (Object)xmlNullPolicy));
        }
        return xElt;
    }

    protected static XmlElement processXMLDirectMapping(XMLDirectMapping xmap) {
        return XmlBindingsGenerator.processXMLMapping((XMLField)xmap.getField(), xmap.getAttributeName(), xmap.getXPath(), xmap.getAttributeClassificationName(), xmap.getNullPolicy(), xmap.isCDATA(), null, false, false, null);
    }

    protected static XmlElement processXMLBinaryDataMapping(XMLBinaryDataMapping xmap) {
        String attClassName = xmap.getAttributeClassificationName();
        if (xmap.isSwaRef()) {
            attClassName = DATAHANDLER_CLASSNAME;
        }
        return XmlBindingsGenerator.processXMLMapping((XMLField)xmap.getField(), xmap.getAttributeName(), xmap.getXPath(), attClassName, xmap.getNullPolicy(), xmap.isCDATA(), null, xmap.shouldInlineBinaryData(), xmap.isSwaRef(), xmap.getMimeType());
    }

    protected static XmlElement processXMLCompositeDirectCollectionMapping(XMLCompositeDirectCollectionMapping xmap) {
        return XmlBindingsGenerator.processXMLMapping((XMLField)xmap.getField(), xmap.getAttributeName(), xmap.getXPath(), null, xmap.getNullPolicy(), xmap.isCDATA(), xmap.getContainerPolicy().getContainerClassName(), false, false, null);
    }

    protected static XmlElement processXMLCompositeObjectMapping(XMLCompositeObjectMapping xmap) {
        return XmlBindingsGenerator.processXMLMapping((XMLField)xmap.getField(), xmap.getAttributeName(), xmap.getXPath(), xmap.getReferenceClassName(), xmap.getNullPolicy(), false, null, false, false, null);
    }

    protected static XmlElement processXMLCompositeCollectionMapping(XMLCompositeCollectionMapping xmap) {
        return XmlBindingsGenerator.processXMLMapping((XMLField)xmap.getField(), xmap.getAttributeName(), xmap.getXPath(), xmap.getReferenceClassName(), xmap.getNullPolicy(), false, xmap.getContainerPolicy().getContainerClassName(), false, false, null);
    }

    protected static String getPackageName(String javaClassName) {
        if (javaClassName.lastIndexOf(".") == -1) {
            return "";
        }
        return javaClassName.substring(0, javaClassName.lastIndexOf("."));
    }

    protected static String getClassName(String javaClassName) {
        if (javaClassName.lastIndexOf(".") == -1) {
            return javaClassName;
        }
        return javaClassName.substring(javaClassName.lastIndexOf(".") + 1, javaClassName.length());
    }

    protected static boolean isDefaultNullPolicy(AbstractNullPolicy nullPolicy) {
        if (nullPolicy instanceof IsSetNullPolicy) {
            return false;
        }
        boolean xsiNil = nullPolicy.isNullRepresentedByXsiNil();
        boolean emptyNode = nullPolicy.isNullRepresentedByEmptyNode();
        boolean setForAbsent = nullPolicy.getIsSetPerformedForAbsentNode();
        XMLNullRepresentationType marshalNull = nullPolicy.getMarshalNullRepresentation();
        return !xsiNil && emptyNode && setForAbsent && marshalNull == XMLNullRepresentationType.ABSENT_NODE;
    }
}

