/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inheritance;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.inheritance.Bus;
import org.eclipse.persistence.testing.models.jpa.inheritance.Person;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class MultipleTableInheritanceCreateTest
extends EntityContainerTestBase {
    protected boolean m_reset = false;
    protected Exception m_exception;

    public MultipleTableInheritanceCreateTest() {
        this.setDescription("Tests the creation of an inheritance subclass that uses multiple tables with a different pk column than its parent");
    }

    @Override
    public void setup() {
        super.setup();
        this.m_reset = true;
        this.m_exception = null;
        ((EntityManagerImpl)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() throws Exception {
        try {
            Person busDriver = new Person();
            busDriver.setName("Guy Pelletier");
            Bus bus = new Bus();
            bus.setBusDriver(busDriver);
            bus.setFuelCapacity(Integer.valueOf(275));
            bus.setPassengerCapacity(Integer.valueOf(100));
            this.beginTransaction();
            this.getEntityManager().persist((Object)bus);
            this.getEntityManager().persist((Object)busDriver);
            this.commitTransaction();
        }
        catch (DatabaseException e) {
            this.m_exception = e;
        }
    }

    @Override
    public void reset() {
        if (this.m_reset) {
            this.m_reset = false;
        }
    }

    public void verify() {
        if (this.m_exception != null) {
            throw new TestErrorException("Exception was thrown when creating a bus: " + this.m_exception.getMessage());
        }
    }
}

