/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.sessionbean;

import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.rmi.PortableRemoteObject;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.sessionbean.EmployeeService;

public class FindAllThread
implements Runnable {
    public int threadNumber;
    public boolean succeeded = true;
    public boolean finished = false;
    public String relatedException = "";
    protected EmployeeService service;

    public FindAllThread() {
    }

    public FindAllThread(int threadNumber) {
        this.threadNumber = threadNumber;
    }

    public EmployeeService getEmployeeService() throws Exception {
        if (this.service == null) {
            Properties properties = new Properties();
            String url = System.getProperty("server.url");
            if (url != null) {
                properties.put("java.naming.provider.url", url);
            }
            InitialContext context = new InitialContext(properties);
            try {
                this.service = (EmployeeService)PortableRemoteObject.narrow((Object)context.lookup("EmployeeService#org.eclipse.persistence.testing.models.jpa.sessionbean.EmployeeService"), EmployeeService.class);
            }
            catch (NameNotFoundException notFoundException) {
                throw new Error("Lookup failed.", notFoundException);
            }
        }
        return this.service;
    }

    @Override
    public void run() {
        int repeatTimes = 300;
        for (int i = 1; i <= repeatTimes; ++i) {
            String prefix = "===Thread " + this.threadNumber + "===FindAll iteration " + i;
            try {
                System.out.println(prefix);
                List result = this.getEmployeeService().findAll();
                int employCount = 0;
                for (Employee employee : result) {
                    ++employCount;
                }
                if (employCount != 2) {
                    this.relatedException = prefix + "===The count is " + employCount + ", Failed to find all employees";
                    this.succeeded = false;
                    break;
                }
                Thread.sleep(3000L);
                continue;
            }
            catch (Exception e) {
                this.relatedException = prefix + e.toString();
                this.succeeded = false;
                break;
            }
        }
        System.out.println(this.relatedException);
        this.finished = true;
    }
}

