/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class DeleteAllQueryTest
extends AutoVerifyTestCase {
    private Exception exception;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getAbstractSession().rollbackTransaction();
    }

    protected void setup() {
        this.exception = null;
        this.getAbstractSession().beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        DeleteAllQuery deleteQuery = new DeleteAllQuery();
        deleteQuery.setReferenceClass(Employee.class);
        deleteQuery.setObjects(new Vector());
        try {
            this.getSession().executeQuery((DatabaseQuery)deleteQuery);
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    protected void verify() {
        if (this.exception == null) {
            throw new TestErrorException("No exception has been thrown");
        }
        if (!(this.exception instanceof QueryException) || ((QueryException)((Object)this.exception)).getErrorCode() != 6131) {
            throw new TestErrorException("Wrong exception thrown: ", (Throwable)this.exception);
        }
        Vector employees = this.getSession().readAllObjects(Employee.class);
        if (employees.size() == 0) {
            throw new TestErrorException("The delete all query test failed.  All the employees were deleted.");
        }
    }
}

