/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.inheritance.Vehicle;

public class InheritanceViewPrepareTest
extends AutoVerifyTestCase {
    protected ReadAllQuery query;

    public InheritanceViewPrepareTest() {
        this.setDescription("Tests the inheritance view query is prepare correctly with binding.");
    }

    public void setup() {
        if (this.getSession().getPlatform().isTimesTen()) {
            throw new TestWarningException("TimesTen does not support TO_NUMBER");
        }
        if (this.getSession().getPlatform().isDB2()) {
            throw new TestWarningException("The test does not support DB2 (Bug 4563813).");
        }
        this.query = new ReadAllQuery();
        this.query.setReferenceClass(Vehicle.class);
        this.query.bindAllParameters();
        ExpressionBuilder vehicle = new ExpressionBuilder();
        this.query.setSelectionCriteria(vehicle.get("id").equal(vehicle.getParameter("id").toNumber()));
        this.query.addArgument("id");
    }

    public void test() {
        Vector<String> arguments = new Vector<String>(1);
        arguments.add(null);
        List result = (List)this.getSession().executeQuery((DatabaseQuery)this.query, arguments);
        arguments = new Vector(1);
        arguments.add("0");
        result = (List)this.getSession().executeQuery((DatabaseQuery)this.query, arguments);
    }

    protected void verify() {
        if (this.query.getSQLString().indexOf("?") == -1) {
            throw new TestErrorException("SQL not prepared correctly: " + this.query.getSQLString());
        }
    }
}

