/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.options;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public class RefreshCascadeAllNoIndirectionTest
extends AutoVerifyTestCase {
    public RefreshCascadeAllNoIndirectionTest() {
        this.setDescription("This test verifies that infinite recursion will not occur when refreshing an object with cascade all and no indirection");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        try {
            ReadObjectQuery query = new ReadObjectQuery(PolicyHolder.class);
            query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").equal((Object)"Bob"));
            query.refreshIdentityMapResult();
            query.setCascadePolicy(3);
            this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (StackOverflowError ex) {
            throw new TestErrorException("Refresh-Cascade All with no indirection caused infinite recursion");
        }
    }
}

