/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CanChangeReadOnlySetTest
extends TransactionalTestCase {
    public EclipseLinkException testException;

    public CanChangeReadOnlySetTest() {
        this.setDescription("Test the canChangeReadOnlySet flag to verify functionality.");
    }

    public void test() {
        try {
            Employee employeeFromCache = (Employee)this.getSession().readObject(Employee.class);
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            uow.registerObject((Object)employeeFromCache);
            Vector<Class<Employee>> vector = new Vector<Class<Employee>>(1);
            vector.add(Employee.class);
            uow.addReadOnlyClasses(vector);
        }
        catch (ValidationException exception) {
            this.testException = exception;
        }
    }

    public void verify() {
        if (this.testException == null || this.testException.getErrorCode() != 7040) {
            throw new TestErrorException("No exception or incorrect exception thrown.  Expected ValidationException cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork got:" + (Object)((Object)this.testException));
        }
    }
}

